/**
 * @file EvolutionGeniviDbusObexClientCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for ObexClient.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for ObexClient.
 */

#include "EvolutionGeniviDbusObexClientCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"
#include "EvolutionGeniviUtils.h"
#include "FwAssert.h"

using namespace ::org::bluez::obex::Client;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusObexClientCallbackIf::EvolutionGeniviDbusObexClientCallbackIf()
{
}

EvolutionGeniviDbusObexClientCallbackIf::EvolutionGeniviDbusObexClientCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusObexClientCallbackIf::~EvolutionGeniviDbusObexClientCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusObexClientCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(objPath);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_OBEX_CLIENT);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}

void EvolutionGeniviDbusObexClientCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(objPath);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_OBEX_CLIENT);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}
// "ServiceAvailableIF" implementation --- end

// org/bluez/obex/ClientProxy implementation --- start
void EvolutionGeniviDbusObexClientCallbackIf::onCancelSessionError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CancelSessionError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_CancelSessionResult(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusObexClientCallbackIf::onCancelSessionResponse(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CancelSessionResponse >& response)
{
   (void)(proxy);
   onResponse(ptrNew_Ipc2Bts_CancelSessionResult(), response);
}

void EvolutionGeniviDbusObexClientCallbackIf::onCreateSessionError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CreateSessionError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_CreateSessionResult(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusObexClientCallbackIf::onCreateSessionResponse(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< CreateSessionResponse >& response)
{
   (void)(proxy);
   Ipc2Bts_CreateSessionResult* ptrResultMsg = ptrNew_Ipc2Bts_CreateSessionResult();
   if(NULL != ptrResultMsg)
   {
      ptrResultMsg->setSession(response->getSession());
      onResponse(ptrResultMsg, response->getAct());
   }
}

void EvolutionGeniviDbusObexClientCallbackIf::onRemoveSessionError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< RemoveSessionError >& error)
{
   (void)(proxy);
   onError(ptrNew_Ipc2Bts_RemoveSessionResult(), error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusObexClientCallbackIf::onRemoveSessionResponse(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< RemoveSessionResponse >& response)
{
   (void)(proxy);
   onResponse(ptrNew_Ipc2Bts_RemoveSessionResult(), response);
}

void EvolutionGeniviDbusObexClientCallbackIf::onSessionCreatedError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionCreatedError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusObexClientCallbackIf::onSessionCreatedSignal(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionCreatedSignal >& signal)
{
   (void)(proxy);
   (void)(signal);
   // ignore
}

void EvolutionGeniviDbusObexClientCallbackIf::onSessionRemovedError(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionRemovedError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusObexClientCallbackIf::onSessionRemovedSignal(const ::boost::shared_ptr< ClientProxy >& proxy, const ::boost::shared_ptr< SessionRemovedSignal >& signal)
{
   (void)(proxy);
   (void)(signal);
   // ignore
}
// org/bluez/obex/ClientProxy implementation --- end

} //genivi
} //btstackif
