/**
 * @file EvolutionGeniviDbusLESeamlessPairingCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for LESeamlessPairing.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for LESeamlessPairing.
 */

#include "EvolutionGeniviDbusLESeamlessPairingCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"
#include "EvolutionGeniviUtils.h"
#include "FwAssert.h"

using namespace ::org::bluez::SeamlessPairing;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusLESeamlessPairingCallbackIf::EvolutionGeniviDbusLESeamlessPairingCallbackIf()
{
}

EvolutionGeniviDbusLESeamlessPairingCallbackIf::EvolutionGeniviDbusLESeamlessPairingCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusLESeamlessPairingCallbackIf::~EvolutionGeniviDbusLESeamlessPairingCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusLESeamlessPairingCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(0 != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_BLE_SEAMLESS_PAIRING);
      ptrMsg->setObjPath(objPath);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}

void EvolutionGeniviDbusLESeamlessPairingCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(0 != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_BLE_SEAMLESS_PAIRING);
      ptrMsg->setObjPath(objPath);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}
// "ServiceAvailableIF" implementation --- end

// org/bluez/SeamlessPairingProxy implementation --- start
void EvolutionGeniviDbusLESeamlessPairingCallbackIf::onSendErrorCodeError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< SendErrorCodeError >& error)
{
   Ipc2Bts_SendSeamlessPairingErrorCodeResult* ptrResultMsg = ptrNew_Ipc2Bts_SendSeamlessPairingErrorCodeResult();
   if(0 != ptrResultMsg)
   {
      ptrResultMsg->setDevice(proxy->getDBusObjectPath());
   }
   onError(ptrResultMsg, error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusLESeamlessPairingCallbackIf::onSendErrorCodeResponse(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< SendErrorCodeResponse >& response)
{
   Ipc2Bts_SendSeamlessPairingErrorCodeResult* ptrResultMsg = ptrNew_Ipc2Bts_SendSeamlessPairingErrorCodeResult();
   if(0 != ptrResultMsg)
   {
      ptrResultMsg->setDevice(proxy->getDBusObjectPath());
   }
   onResponse(ptrResultMsg, response);
}

void EvolutionGeniviDbusLESeamlessPairingCallbackIf::onAllowAccessError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AllowAccessError >& error)
{
   Ipc2Bts_SeamlessPairingAllowAccessResult* ptrResultMsg = ptrNew_Ipc2Bts_SeamlessPairingAllowAccessResult();
   if(0 != ptrResultMsg)
   {
      ptrResultMsg->setDevice(proxy->getDBusObjectPath());
   }
   onError(ptrResultMsg, error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusLESeamlessPairingCallbackIf::onAllowAccessResponse(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AllowAccessResponse >& response)
{
   Ipc2Bts_SeamlessPairingAllowAccessResult* ptrResultMsg = ptrNew_Ipc2Bts_SeamlessPairingAllowAccessResult();
   if(0 != ptrResultMsg)
   {
      ptrResultMsg->setDevice(proxy->getDBusObjectPath());
   }
   onResponse(ptrResultMsg, response);
}

void EvolutionGeniviDbusLESeamlessPairingCallbackIf::onErrorCodeReceivedError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< ErrorCodeReceivedError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusLESeamlessPairingCallbackIf::onErrorCodeReceivedSignal(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< ErrorCodeReceivedSignal >& signal)
{
   Ipc2Bts_SeamlessPairingErrorCodeReceived* ptrStatusMsg = ptrNew_Ipc2Bts_SeamlessPairingErrorCodeReceived();
   if(0 != ptrStatusMsg)
   {
      ptrStatusMsg->setDevice(proxy->getDBusObjectPath());
      ptrStatusMsg->setStatus((BTSBLEStatus)signal->getStatus()); // cast OK because enum and Evolution value match
   }
   onSignal(ptrStatusMsg, signal->getAct());
}

void EvolutionGeniviDbusLESeamlessPairingCallbackIf::onAccessRequestError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AccessRequestError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusLESeamlessPairingCallbackIf::onAccessRequestSignal(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< AccessRequestSignal >& signal)
{
   Ipc2Bts_SeamlessPairingAccessRequest* ptrStatusMsg = ptrNew_Ipc2Bts_SeamlessPairingAccessRequest();
   if(0 != ptrStatusMsg)
   {
      ptrStatusMsg->setDevice(proxy->getDBusObjectPath());
   }
   onSignal(ptrStatusMsg, signal->getAct());
}

void EvolutionGeniviDbusLESeamlessPairingCallbackIf::onPairingDataError(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< PairingDataError >& error)
{
   Ipc2Bts_SeamlessPairingPairingDataUpdate* ptrStatusMsg = ptrNew_Ipc2Bts_SeamlessPairingPairingDataUpdate();
   if(0 != ptrStatusMsg)
   {
      ptrStatusMsg->setDevice(proxy->getDBusObjectPath());
   }
   onError(ptrStatusMsg, error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
}

void EvolutionGeniviDbusLESeamlessPairingCallbackIf::onPairingDataUpdate(const ::boost::shared_ptr< SeamlessPairingProxy >& proxy, const ::boost::shared_ptr< PairingDataUpdate >& update)
{
   Ipc2Bts_SeamlessPairingPairingDataUpdate* ptrStatusMsg = ptrNew_Ipc2Bts_SeamlessPairingPairingDataUpdate();
   if(0 != ptrStatusMsg)
   {
      ptrStatusMsg->setDevice(proxy->getDBusObjectPath());
      ptrStatusMsg->setPairingData(update->getPairingData());
   }
   onUpdate(ptrStatusMsg, update->getAct());
}
// org/bluez/SeamlessPairingProxy implementation --- end

} //genivi
} //btstackif
