/**
 * @file EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpVoiceCallManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for HfpVoiceCallManager.
 */

#include "EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"

using namespace ::org::ofono::VoiceCallManager;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf()
{
}

EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::~EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
}
// "ServiceAvailableIF" implementation --- end

// org/ofono/VoiceCallManagerProxy implementation --- start
void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onGetPropertiesError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onGetPropertiesResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onGetCallsError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetCallsError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onGetCallsResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetCallsResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onDialError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< DialError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onDialResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< DialResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onMemDialError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< MemDialError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onMemDialResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< MemDialResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onRedialError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< RedialError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onRedialResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< RedialResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onSwapCallsError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SwapCallsError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onSwapCallsResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SwapCallsResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onReleaseAndAnswerError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< ReleaseAndAnswerError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onReleaseAndAnswerResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< ReleaseAndAnswerResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onReleaseAndSwapError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< ReleaseAndSwapError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onReleaseAndSwapResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< ReleaseAndSwapResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onHoldAndAnswerError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HoldAndAnswerError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onHoldAndAnswerResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HoldAndAnswerResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onHangupAllError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupAllError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onHangupAllResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupAllResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onPrivateChatError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< PrivateChatError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onPrivateChatResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< PrivateChatResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onCreateMultipartyError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CreateMultipartyError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onCreateMultipartyResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CreateMultipartyResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onHangupMultipartyError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupMultipartyError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onHangupMultipartyResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupMultipartyResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onSendTonesError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SendTonesError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onSendTonesResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SendTonesResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onCallAddedError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallAddedError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onCallAddedSignal(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallAddedSignal >& signal)
{
   (void)(proxy);
   (void)(signal);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onCallRemovedError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallRemovedError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onCallRemovedSignal(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallRemovedSignal >& signal)
{
   (void)(proxy);
   (void)(signal);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onPropertyChangedError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallbackIf::onPropertyChangedSignal(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal)
{
   (void)(proxy);
   (void)(signal);
}
// org/ofono/VoiceCallManagerProxy implementation --- end

} //genivi
} //btstackif
