/**
 * @file EvolutionGeniviDbusHfpSiriFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for HfpSiri.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for HfpSiri.
 */

#include "EvolutionGeniviDbusHfpSiriFactory.h"
#include "EvolutionGeniviDbusHfpSiriCallbackIf.h"

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusHfpSiriFactory::EvolutionGeniviDbusHfpSiriFactory()
{
   _createdLocally = true;
   _cb = NULL;
}

EvolutionGeniviDbusHfpSiriFactory::~EvolutionGeniviDbusHfpSiriFactory()
{
   _cb = NULL;
}

EvolutionGeniviDbusHfpSiriFactory& EvolutionGeniviDbusHfpSiriFactory::getInstance(void)
{
   static EvolutionGeniviDbusHfpSiriFactory factory;
   return factory;
}

::ccdbusif::IEvolutionGeniviDbusHfpSiriCallbackIf* EvolutionGeniviDbusHfpSiriFactory::getCb(IDbusRecHandler* handler)
{
   if(NULL != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new EvolutionGeniviDbusHfpSiriCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void EvolutionGeniviDbusHfpSiriFactory::destroyCb(void)
{
   if((NULL != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = NULL;
   }
}

void EvolutionGeniviDbusHfpSiriFactory::setCbForTesting(EvolutionGeniviDbusHfpSiriCallbackIf* testCallback)
{
   if(NULL != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

} //genivi
} //btstackif
