/**
 * @file EvolutionGeniviDbusHfpSiriCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpSiri.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for HfpSiri.
 */

#include "EvolutionGeniviDbusHfpSiriCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"

using namespace ::org::ofono::evo::Siri;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusHfpSiriCallbackIf::EvolutionGeniviDbusHfpSiriCallbackIf()
{
}

EvolutionGeniviDbusHfpSiriCallbackIf::EvolutionGeniviDbusHfpSiriCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusHfpSiriCallbackIf::~EvolutionGeniviDbusHfpSiriCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusHfpSiriCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
}

void EvolutionGeniviDbusHfpSiriCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);
   /* TODO
   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }
   */
   // TODO: implement
}
// "ServiceAvailableIF" implementation --- end

// org/ofono/evo/SiriProxy implementation --- start
void EvolutionGeniviDbusHfpSiriCallbackIf::onGetPropertiesError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpSiriCallbackIf::onGetPropertiesResponse(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpSiriCallbackIf::onEnableError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< EnableError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpSiriCallbackIf::onEnableResponse(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< EnableResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpSiriCallbackIf::onSetNRError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< SetNRError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpSiriCallbackIf::onSetNRResponse(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< SetNRResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpSiriCallbackIf::onSetPropertyError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpSiriCallbackIf::onSetPropertyResponse(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response)
{
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpSiriCallbackIf::onPropertyChangedError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error)
{
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpSiriCallbackIf::onPropertyChangedSignal(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal)
{
   (void)(proxy);
   (void)(signal);
}
// org/ofono/evo/SiriProxy implementation --- end

} //genivi
} //btstackif
