/**
 * @file EvolutionGeniviDbusHfpModemFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for HfpModem.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for HfpModem.
 */

#include "EvolutionGeniviDbusHfpModemFactory.h"
#include "EvolutionGeniviDbusHfpModemCallbackIf.h"

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusHfpModemFactory::EvolutionGeniviDbusHfpModemFactory()
{
   _createdLocally = true;
   _cb = NULL;
}

EvolutionGeniviDbusHfpModemFactory::~EvolutionGeniviDbusHfpModemFactory()
{
   _cb = NULL;
}

EvolutionGeniviDbusHfpModemFactory& EvolutionGeniviDbusHfpModemFactory::getInstance(void)
{
   static EvolutionGeniviDbusHfpModemFactory factory;
   return factory;
}

IEvolutionGeniviHfpModemCallbackIf* EvolutionGeniviDbusHfpModemFactory::getCb(IDbusRecHandler* handler)
{
   if(NULL != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new EvolutionGeniviDbusHfpModemCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void EvolutionGeniviDbusHfpModemFactory::destroyCb(void)
{
   if((NULL != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = NULL;
   }
}

void EvolutionGeniviDbusHfpModemFactory::setCbForTesting(IEvolutionGeniviHfpModemCallbackIf* testCallback)
{
   if(NULL != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

void EvolutionGeniviDbusHfpModemFactory::setReceiveHandler(IDbusRecHandler* handler)
{
   if(NULL != _cb)
   {
      _cb->setReceiveHandler(handler);
   }
}

void EvolutionGeniviDbusHfpModemFactory::setHfpHandsfreeIf(::ccdbusif::IEvolutionGeniviDbusHfpHandsfreeSendRequestIf* handler)
{
   if(NULL != _cb)
   {
      _cb->setHfpHandsfreeIf(handler);
   }
}

} //genivi
} //btstackif
