/**
 * @file EvolutionGeniviDbusHfpManagerFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for HfpManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for HfpManager.
 */

#include "EvolutionGeniviDbusHfpManagerFactory.h"
#include "EvolutionGeniviDbusHfpManagerCallbackIf.h"

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusHfpManagerFactory::EvolutionGeniviDbusHfpManagerFactory()
{
   _createdLocally = true;
   _cb = NULL;
}

EvolutionGeniviDbusHfpManagerFactory::~EvolutionGeniviDbusHfpManagerFactory()
{
   _cb = NULL;
}

EvolutionGeniviDbusHfpManagerFactory& EvolutionGeniviDbusHfpManagerFactory::getInstance(void)
{
   static EvolutionGeniviDbusHfpManagerFactory factory;
   return factory;
}

IEvolutionGeniviHfpManagerCallbackIf* EvolutionGeniviDbusHfpManagerFactory::getCb(IDbusRecHandler* handler)
{
   if(NULL != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new EvolutionGeniviDbusHfpManagerCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void EvolutionGeniviDbusHfpManagerFactory::destroyCb(void)
{
   if((NULL != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = NULL;
   }
}

void EvolutionGeniviDbusHfpManagerFactory::setCbForTesting(IEvolutionGeniviHfpManagerCallbackIf* testCallback)
{
   if(NULL != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

void EvolutionGeniviDbusHfpManagerFactory::setReceiveHandler(IDbusRecHandler* handler)
{
   if(NULL != _cb)
   {
      _cb->setReceiveHandler(handler);
   }
}

void EvolutionGeniviDbusHfpManagerFactory::setHfpHandsfreeIf(::ccdbusif::IEvolutionGeniviDbusHfpHandsfreeSendRequestIf* handler)
{
   if(NULL != _cb)
   {
      _cb->setHfpHandsfreeIf(handler);
   }
}

void EvolutionGeniviDbusHfpManagerFactory::setHfpModemIf(::ccdbusif::IEvolutionGeniviDbusHfpModemSendRequestIf* handler)
{
   if(NULL != _cb)
   {
      _cb->setHfpModemIf(handler);
   }
}

} //genivi
} //btstackif
