/**
 * @file EvolutionGeniviDbusHfpHandsfreeCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpHandsfree.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for HfpHandsfree.
 */

#include "EvolutionGeniviDbusHfpHandsfreeCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"
#include "EvolutionGeniviUtils.h"
#include "cc_dbus_if/EvolutionGeniviDbusParser.h"

#include "FwAssert.h"

using namespace ::org::ofono::Handsfree;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusHfpHandsfreeCallbackIf::EvolutionGeniviDbusHfpHandsfreeCallbackIf()
{
}

EvolutionGeniviDbusHfpHandsfreeCallbackIf::EvolutionGeniviDbusHfpHandsfreeCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusHfpHandsfreeCallbackIf::~EvolutionGeniviDbusHfpHandsfreeCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   /*--- BTS_FB_CONNECTION start ----------------------------------------------------------------*/
   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_HFP_HANDSFREE);
      ptrMsg->setObjPath(objPath);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
   /*--- BTS_FB_CONNECTION end ------------------------------------------------------------------*/
}

void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   /*--- BTS_FB_CONNECTION start ----------------------------------------------------------------*/
   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_HFP_HANDSFREE);
      ptrMsg->setObjPath(objPath);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
   /*--- BTS_FB_CONNECTION end ------------------------------------------------------------------*/
}
// "ServiceAvailableIF" implementation --- end

// org/ofono/HandsfreeProxy implementation --- start
void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onGetPropertiesError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error)
{
   /*--- BTS_FB_CONNECTION start ----------------------------------------------------------------*/
   BTSFunctionBlock destFuncBlock = BTS_FB_CONNECTION;

   Ipc2Bts_GetHandsfreeProperties* ptrResultMsg = ptrNew_Ipc2Bts_GetHandsfreeProperties();
   if(NULL != ptrResultMsg)
   {
      ptrResultMsg->setBtsDestinationFunctionBlock(destFuncBlock);
      ptrResultMsg->setModem(proxy->getDBusObjectPath());
   }
   onError(ptrResultMsg, error, convertErrorCode2InternalValue(error->getName(), error->getMessage()));
   /*--- BTS_FB_CONNECTION end ------------------------------------------------------------------*/
}

void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onGetPropertiesResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response)
{
   /*--- BTS_FB_CONNECTION start ----------------------------------------------------------------*/
   BTSFunctionBlock destFuncBlock = BTS_FB_CONNECTION;

   Ipc2Bts_GetHandsfreeProperties* ptrResultMsg = ptrNew_Ipc2Bts_GetHandsfreeProperties();
   if(NULL != ptrResultMsg)
   {
      ptrResultMsg->setBtsDestinationFunctionBlock(destFuncBlock);
      ptrResultMsg->setModem(proxy->getDBusObjectPath());

      // check received properties for Features + InbandRinging
      ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
      parser.setTraces(true);
      BTSDbusPropertyList outPropertyList;

      if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(), parser.getHfpHandsfreeProperty2String(::ccdbusif::evolution::HFP_HANDSFREE_FEATURES), (int)::ccdbusif::evolution::IF_HANDSFREE))
      {
         if(1 == outPropertyList.size())
         {
            const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

            Ipc2Bts_HandsfreeFeaturesUpdate* ptrFeaturesUpd = ptrNew_Ipc2Bts_HandsfreeFeaturesUpdate();
            if(NULL != ptrFeaturesUpd)
            {
               ptrFeaturesUpd->setBtsDestinationFunctionBlock(destFuncBlock);
               ptrFeaturesUpd->setModem(proxy->getDBusObjectPath());
               BTSHfpSupportedFeatures& features = ptrFeaturesUpd->getFeaturesMutable();

               if(false == outProperty.propData.getNone())
               {
                  const ::std::vector<std::string>& featureList = outProperty.propData.getStringArray();

                  for(size_t i = 0; i < featureList.size(); i++)
                  {
                     features.setBit(parser.getHfpHandsfreeFeatures2Enum(featureList[i]));
                  }
               }
            }
            onUpdate(ptrFeaturesUpd, ::ccdbusif::DEFAULT_ACT);
         }
         else
         {
            FW_NORMAL_ASSERT_ALWAYS();
         }
      }

      outPropertyList.clear();
      if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(), parser.getHfpHandsfreeProperty2String(::ccdbusif::evolution::HFP_HANDSFREE_INBANDRINGING), (int)::ccdbusif::evolution::IF_HANDSFREE))
      {
         if(1 == outPropertyList.size())
         {
            const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

            Ipc2Bts_HandsfreeInbandRingingUpdate* ptrInbandUpd = ptrNew_Ipc2Bts_HandsfreeInbandRingingUpdate();
            if(NULL != ptrInbandUpd)
            {
               ptrInbandUpd->setBtsDestinationFunctionBlock(destFuncBlock);
               ptrInbandUpd->setModem(proxy->getDBusObjectPath());
               ptrInbandUpd->setInbandRingingEnabled(outProperty.propData.getBool());
            }
            onUpdate(ptrInbandUpd, ::ccdbusif::DEFAULT_ACT);
         }
         else
         {
            FW_NORMAL_ASSERT_ALWAYS();
         }
      }
   }
   onResponse(ptrResultMsg, response->getAct());
   /*--- BTS_FB_CONNECTION end ------------------------------------------------------------------*/
}

void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onSetPropertyError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error)
{
   // TODO: implement
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onSetPropertyResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response)
{
   // TODO: implement
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onRequestPhoneNumberError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RequestPhoneNumberError >& error)
{
   // TODO: implement
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onRequestPhoneNumberResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RequestPhoneNumberResponse >& response)
{
   // TODO: implement
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onGetSubscriberError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetSubscriberError >& error)
{
   // TODO: implement
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onGetSubscriberResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetSubscriberResponse >& response)
{
   // TODO: implement
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onSendCustomATCommandError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SendCustomATCommandError >& error)
{
   // TODO: implement
   (void)(proxy);
   (void)(error);
}

void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onSendCustomATCommandResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SendCustomATCommandResponse >& response)
{
   // TODO: implement
   (void)(proxy);
   (void)(response);
}

void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onPropertyChangedError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onPropertyChangedSignal(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal)
{
   /*--- BTS_FB_CONNECTION start ----------------------------------------------------------------*/
   BTSFunctionBlock destFuncBlock = BTS_FB_CONNECTION;

   // check received property for Features + InbandRinging
   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);
   ::ccdbusif::evolution::HfpHandsfreeProperty propEnum = parser.getHfpHandsfreeProperty2Enum(signal->getName());

   if(::ccdbusif::evolution::HFP_HANDSFREE_FEATURES == propEnum)
   {
      BTSDbusPropertyList outPropertyList;
      parser.parseProperty(outPropertyList, signal->getValueMutable(), signal->getName(), (int)::ccdbusif::evolution::IF_HANDSFREE);

      if(1 == outPropertyList.size())
      {
         const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

         Ipc2Bts_HandsfreeFeaturesUpdate* ptrFeaturesUpd = ptrNew_Ipc2Bts_HandsfreeFeaturesUpdate();
         if(NULL != ptrFeaturesUpd)
         {
            ptrFeaturesUpd->setBtsDestinationFunctionBlock(destFuncBlock);
            ptrFeaturesUpd->setModem(proxy->getDBusObjectPath());
            BTSHfpSupportedFeatures& features = ptrFeaturesUpd->getFeaturesMutable();

            if(false == outProperty.propData.getNone())
            {
               const ::std::vector<std::string>& featureList = outProperty.propData.getStringArray();

               for(size_t i = 0; i < featureList.size(); i++)
               {
                  features.setBit(parser.getHfpHandsfreeFeatures2Enum(featureList[i]));
               }
            }
         }
         onUpdate(ptrFeaturesUpd, signal->getAct());
      }
      else
      {
         FW_NORMAL_ASSERT_ALWAYS();
      }
   }
   else if(::ccdbusif::evolution::HFP_HANDSFREE_INBANDRINGING == propEnum)
   {
      BTSDbusPropertyList outPropertyList;
      parser.parseProperty(outPropertyList, signal->getValueMutable(), signal->getName(), (int)::ccdbusif::evolution::IF_HANDSFREE);

      if(1 == outPropertyList.size())
      {
         const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

         Ipc2Bts_HandsfreeInbandRingingUpdate* ptrInbandUpd = ptrNew_Ipc2Bts_HandsfreeInbandRingingUpdate();
         if(NULL != ptrInbandUpd)
         {
            ptrInbandUpd->setBtsDestinationFunctionBlock(destFuncBlock);
            ptrInbandUpd->setModem(proxy->getDBusObjectPath());
            ptrInbandUpd->setInbandRingingEnabled(outProperty.propData.getBool());
         }
         onUpdate(ptrInbandUpd, signal->getAct());
      }
      else
      {
         FW_NORMAL_ASSERT_ALWAYS();
      }
   }
   /*--- BTS_FB_CONNECTION end ------------------------------------------------------------------*/
}

void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onRecvATCommandError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RecvATCommandError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusHfpHandsfreeCallbackIf::onRecvATCommandSignal(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RecvATCommandSignal >& signal)
{
   // TODO: implement
   (void)(proxy);
   (void)(signal);
}
// org/ofono/HandsfreeProxy implementation --- end

} //genivi
} //btstackif
