/**
 * @file EvolutionGeniviDbusGeniviTraceCallbackIf.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for GeniviTrace.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for GeniviTrace.
 */

#include "EvolutionGeniviDbusGeniviTraceCallbackIf.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"
#include "BtsUtils.h"
#include "FwAssert.h"

using namespace ::org::bluez::genivi::Trace;
using namespace ::asf::core;

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusGeniviTraceCallbackIf::EvolutionGeniviDbusGeniviTraceCallbackIf()
{
}

EvolutionGeniviDbusGeniviTraceCallbackIf::EvolutionGeniviDbusGeniviTraceCallbackIf(IDbusRecHandler* recHandler) : DbusCallbackIf(recHandler)
{
}

EvolutionGeniviDbusGeniviTraceCallbackIf::~EvolutionGeniviDbusGeniviTraceCallbackIf()
{
}

// "ServiceAvailableIF" implementation --- start
void EvolutionGeniviDbusGeniviTraceCallbackIf::onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(objPath);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_GENIVI_TRACE);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}

void EvolutionGeniviDbusGeniviTraceCallbackIf::onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(objPath);

   BTSDbusServiceAvailability availabilityEvent = BTS_DBUS_SERVICE_NOT_AVAILABLE;

   if(ServiceState__Available == currentState)
   {
      availabilityEvent = BTS_DBUS_SERVICE_AVAILABLE;
   }

   Ipc2Bts_ServiceAvailabilityConnection* ptrMsg = ptrNew_Ipc2Bts_ServiceAvailabilityConnection();

   if(NULL != ptrMsg)
   {
      ptrMsg->setInterface(BTS_GEN_DBUS_SERVICE_GENIVI_TRACE);
      ptrMsg->setAvailabilityEvent(availabilityEvent);
   }

   onSignal(ptrMsg, ::ccdbusif::DEFAULT_ACT, true);
}
// "ServiceAvailableIF" implementation --- end

// org/bluez/genivi/TraceProxy implementation --- start
void EvolutionGeniviDbusGeniviTraceCallbackIf::onReportDebugTraceError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportDebugTraceError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusGeniviTraceCallbackIf::onReportDebugTraceSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportDebugTraceSignal >& signal)
{
   (void)(proxy);
   Ipc2Bts_ReportGeniviDebugTrace* ptrMsg = ptrNew_Ipc2Bts_ReportGeniviDebugTrace();
   if(NULL != ptrMsg)
   {
      ptrMsg->setErrFile(signal->getErr_file());
      ptrMsg->setErrLine(signal->getErr_line());
      ptrMsg->setLevel(signal->getLevel());
      ptrMsg->setCategory(signal->getCategory());
      ptrMsg->setErrorCode(signal->getError_code());
      ptrMsg->setData(signal->getData());
      onSignal(ptrMsg, signal->getAct());
   }
}

void EvolutionGeniviDbusGeniviTraceCallbackIf::onFatalErrorError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< FatalErrorError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   FW_NORMAL_ASSERT_ALWAYS();
}

void EvolutionGeniviDbusGeniviTraceCallbackIf::onFatalErrorSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< FatalErrorSignal >& signal)
{
   (void)(proxy);
   Ipc2Bts_GeniviFatalError* ptrMsg = ptrNew_Ipc2Bts_GeniviFatalError();
   if(NULL != ptrMsg)
   {
      ptrMsg->setErrFile(signal->getErr_file());
      ptrMsg->setErrLine(signal->getErr_line());
      ptrMsg->setErrCode(signal->getErr_code());
      ptrMsg->setFmt(signal->getFmt());
      ptrMsg->setErrValue(signal->getErr_value());
      onSignal(ptrMsg, signal->getAct());
   }
}
// org/bluez/genivi/TraceProxy implementation --- end

} //genivi
} //btstackif
