/**
 * @file EvolutionGeniviDbusAgentManagerFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for AgentManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for AgentManager.
 */

#include "EvolutionGeniviDbusAgentManagerFactory.h"
#include "EvolutionGeniviDbusAgentManagerCallbackIf.h"

namespace btstackif {
namespace genivi {

EvolutionGeniviDbusAgentManagerFactory::EvolutionGeniviDbusAgentManagerFactory()
{
   _createdLocally = true;
   _cb = NULL;
}

EvolutionGeniviDbusAgentManagerFactory::~EvolutionGeniviDbusAgentManagerFactory()
{
   _cb = NULL;
}

EvolutionGeniviDbusAgentManagerFactory& EvolutionGeniviDbusAgentManagerFactory::getInstance(void)
{
   static EvolutionGeniviDbusAgentManagerFactory factory;
   return factory;
}

::ccdbusif::IEvolutionGeniviDbusAgentManagerCallbackIf* EvolutionGeniviDbusAgentManagerFactory::getCb(IDbusRecHandler* handler)
{
   if(NULL != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new EvolutionGeniviDbusAgentManagerCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void EvolutionGeniviDbusAgentManagerFactory::destroyCb(void)
{
   if((NULL != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = NULL;
   }
}

void EvolutionGeniviDbusAgentManagerFactory::setCbForTesting(EvolutionGeniviDbusAgentManagerCallbackIf* testCallback)
{
   if(NULL != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

} //genivi
} //btstackif
