/**
 * @file DbusAccessAlpsEvolutionExt.cpp
 *
 * @par SW-Component
 * IPC
 *
 * @brief Implementation of DBUS functionality for Alps Evolution Genivi extensions.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of DBUS functionality for Alps Evolution Genivi extensions.
 */

#include "DbusAccess_GEN.h"
#include "FwAssert.h"
#include "AlpsEvolutionBluetoothLowEnergyDbusIf.h"

namespace btstackif {
namespace genivi {

void DbusAccess::createAlpsEvolutionGeniviExtensions(IN const BTSLocalStackConfiguration& configuration, IN const BTSUserMode userMode, IN const BTSInterfaceType interface)
{
   (void)(interface);

   if((BTS_USER_MODE_CONNECTION == userMode) ||
      (BTS_USER_MODE_CONN_WO_AGENT == userMode) ||
      (BTS_USER_MODE_ALL_WI_AGENT == userMode) ||
      (BTS_USER_MODE_ALL_WO_AGENT == userMode))
   {
      if(true == configuration.bluetoothLowEnergyEnabled)
      {
         IDbusIfHandler* ble = new alpsevolutionext::AlpsEvolutionBluetoothLowEnergyDbusIf();
         if(0 != ble)
         {
            ble->enable(true);
            _connectionExtensions.push_back(ble);
         }
         else
         {
            FW_NORMAL_ASSERT_ALWAYS();
         }
      }
   }
}

} //genivi
} //btstackif
