/**
 * @file ConnManDbusTechnologyFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief ConnMan instance factory for Technology.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan instance factory for Technology.
 */

#include "ConnManDbusTechnologyFactory.h"
#include "ConnManDbusTechnologyCallbackIf.h"

namespace btstackif {
namespace genivi {

ConnManDbusTechnologyFactory::ConnManDbusTechnologyFactory()
{
   _createdLocally = true;
   _cb = NULL;
}

ConnManDbusTechnologyFactory::~ConnManDbusTechnologyFactory()
{
   _cb = NULL;
}

ConnManDbusTechnologyFactory& ConnManDbusTechnologyFactory::getInstance(void)
{
   static ConnManDbusTechnologyFactory factory;
   return factory;
}

::ccdbusif::IConnManDbusTechnologyCallbackIf* ConnManDbusTechnologyFactory::getCb(IDbusRecHandler* handler)
{
   if(NULL != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new ConnManDbusTechnologyCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void ConnManDbusTechnologyFactory::destroyCb(void)
{
   if((NULL != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = NULL;
   }
}

void ConnManDbusTechnologyFactory::setCbForTesting(ConnManDbusTechnologyCallbackIf* testCallback)
{
   if(NULL != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

} //genivi
} //btstackif
