/**
 * @file ConnManDbusServiceFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief ConnMan instance factory for Service.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan instance factory for Service.
 */

#include "ConnManDbusServiceFactory.h"
#include "ConnManDbusServiceCallbackIf.h"

namespace btstackif {
namespace genivi {

ConnManDbusServiceFactory::ConnManDbusServiceFactory()
{
   _createdLocally = true;
   _cb = NULL;
}

ConnManDbusServiceFactory::~ConnManDbusServiceFactory()
{
   _cb = NULL;
}

ConnManDbusServiceFactory& ConnManDbusServiceFactory::getInstance(void)
{
   static ConnManDbusServiceFactory factory;
   return factory;
}

::ccdbusif::IConnManDbusServiceCallbackIf* ConnManDbusServiceFactory::getCb(IDbusRecHandler* handler)
{
   if(NULL != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new ConnManDbusServiceCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void ConnManDbusServiceFactory::destroyCb(void)
{
   if((NULL != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = NULL;
   }
}

void ConnManDbusServiceFactory::setCbForTesting(ConnManDbusServiceCallbackIf* testCallback)
{
   if(NULL != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

} //genivi
} //btstackif
