/**
 * @file IntrospectableDbusCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Introspectable DBUS Callback Interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for Introspectable DBUS callbacks.
 */

#ifndef _INTROSPECTABLE_DBUS_CALLBACK_IF_H_
#define _INTROSPECTABLE_DBUS_CALLBACK_IF_H_

#include "cc_dbus_if/IIntrospectableDbusCallbackIf.h"

#include "introspect/org/freedesktop/DBus/IntrospectableProxy.h"

#include "DbusCallbackIf.h"

using namespace ::introspect::org::freedesktop::DBus::Introspectable;

using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class IntrospectableDbusCallbackIf : public DbusCallbackIf, public ::ccdbusif::IIntrospectableDbusCallbackIf
{
public:
   IntrospectableDbusCallbackIf(IDbusRecHandler* recHandler);
   virtual ~IntrospectableDbusCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onIntrospectableProxyAvailable(const ::std::string& busName, const ::std::string& objPath, const ::ccdbusif::DbusBusType busType, void* user, const ServiceState previousState, const ServiceState currentState);
   virtual void onIntrospectableProxyUnavailable(const ::std::string& busName, const ::std::string& objPath, const ::ccdbusif::DbusBusType busType, void* user, const ServiceState previousState, const ServiceState currentState);
   // "ServiceAvailableIF" implementation --- end

   // Introspectable implementation --- start
   virtual void onIntrospectError(const ::boost::shared_ptr< IntrospectableProxy >& proxy, const ::boost::shared_ptr< IntrospectError >& error);
   virtual void onIntrospectResponse(const ::boost::shared_ptr< IntrospectableProxy >& proxy, const ::boost::shared_ptr< IntrospectResponse >& response);
   // Introspectable implementation --- end

protected:
   IntrospectableDbusCallbackIf();
};

} //genivi
} //btstackif

#endif //_INTROSPECTABLE_DBUS_CALLBACK_IF_H_
