/**
 * @file IEvolutionGeniviHfpManagerCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for HfpManager.
 */

#ifndef _I_EVOLUTION_GENIVI_HFP_MANAGER_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_HFP_MANAGER_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusHfpManagerCallbackIf.h"

using namespace ::org::ofono::Manager;
using namespace ::asf::core;

// class forward declarations
namespace ccdbusif {
class IEvolutionGeniviDbusHfpHandsfreeSendRequestIf;
class IEvolutionGeniviDbusHfpModemSendRequestIf;
} //ccdbusif

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class IEvolutionGeniviHfpManagerCallbackIf : public ::ccdbusif::IEvolutionGeniviDbusHfpManagerCallbackIf
{
public:
   virtual ~IEvolutionGeniviHfpManagerCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/ofono/ManagerProxy implementation --- start
   virtual void onGetModemsError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetModemsError >& error) = 0;

   virtual void onGetModemsResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetModemsResponse >& response) = 0;

   virtual void onModemAddedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ModemAddedError >& error) = 0;

   virtual void onModemAddedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ModemAddedSignal >& signal) = 0;

   virtual void onModemRemovedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ModemRemovedError >& error) = 0;

   virtual void onModemRemovedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ModemRemovedSignal >& signal) = 0;
   // org/ofono/ManagerProxy implementation --- end

   virtual void setReceiveHandler(IDbusRecHandler* handler) = 0;

   virtual void setHfpHandsfreeIf(::ccdbusif::IEvolutionGeniviDbusHfpHandsfreeSendRequestIf* handler) = 0;

   virtual void setHfpModemIf(::ccdbusif::IEvolutionGeniviDbusHfpModemSendRequestIf* handler) = 0;
};

} //genivi
} //btstackif

#endif //_I_EVOLUTION_GENIVI_HFP_MANAGER_CALLBACK_IF_H_
