/**
 * @file EvolutionGeniviDbusServiceCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Service.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for Service.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_SERVICE_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_SERVICE_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusServiceCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/bluez/ServiceProxy.h"

using namespace ::org::bluez::Service;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusServiceCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusServiceCallbackIf
{
public:
   EvolutionGeniviDbusServiceCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusServiceCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/ServiceProxy implementation --- start
   virtual void onConnectError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ConnectError >& error);

   virtual void onConnectResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ConnectResponse >& response);

   virtual void onDisconnectError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error);

   virtual void onDisconnectResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response);

   virtual void onRemoteUUIDError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< RemoteUUIDError >& error);

   virtual void onRemoteUUIDUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< RemoteUUIDUpdate >& update);

   virtual void onStateError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< StateError >& error);

   virtual void onStateUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< StateUpdate >& update);

   virtual void onDeviceError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DeviceError >& error);

   virtual void onDeviceUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DeviceUpdate >& update);

   virtual void onVersionError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< VersionError >& error);

   virtual void onVersionUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< VersionUpdate >& update);
   // org/bluez/ServiceProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusServiceCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_SERVICE_CALLBACK_IF_H_
