/**
 * @file EvolutionGeniviDbusObexTransferFactory.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for ObexTransfer.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for ObexTransfer.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_FACTORY_H_
#define _EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_FACTORY_H_

#include <stdbool.h> // <cstdbool> is marked with C++11

// class forward declarations
namespace ccdbusif {
class IEvolutionGeniviDbusObexTransferCallbackIf;
} //ccdbusif

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

// class forward declarations
class EvolutionGeniviDbusObexTransferCallbackIf;

/**
 *
 */
class EvolutionGeniviDbusObexTransferFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static EvolutionGeniviDbusObexTransferFactory& getInstance(void);

   /**
    * Get callback instance (pointer).
    *
    * @param[in] handler: receive handler
    *
    * @return = pointer to callback instance
    */
   ::ccdbusif::IEvolutionGeniviDbusObexTransferCallbackIf* getCb(IDbusRecHandler* handler);

   /**
    * Destroy callback instance (pointer).
    */
   void destroyCb(void);

   /**
    * Set callback instance (pointer).
    * For testing purpose (unit test).
    * If callback instance is set by external user via this interface the caller is responsible to free the callback instance at the end of the test run.
    *
    * @param[in] testCallback: test version of callback instance (pointer)
    */
   void setCbForTesting(EvolutionGeniviDbusObexTransferCallbackIf* testCallback);

private:
   /**
    * Default constructor. Private!!!
    */
   EvolutionGeniviDbusObexTransferFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~EvolutionGeniviDbusObexTransferFactory();

   bool _createdLocally; /**< creator flag */
   EvolutionGeniviDbusObexTransferCallbackIf* _cb; /**< callback instance */
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_FACTORY_H_
