/**
 * @file EvolutionGeniviDbusLEAdapterCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for LEAdapter.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for LEAdapter.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_LE_ADAPTER_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_LE_ADAPTER_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusLEAdapterCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/bluez/LE_Adapter1Proxy.h"

using namespace ::org::bluez::LE_Adapter1;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusLEAdapterCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusLEAdapterCallbackIf
{
public:
   EvolutionGeniviDbusLEAdapterCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusLEAdapterCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/LE_Adapter1Proxy implementation --- start
   virtual void onCreateLeDeviceError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< CreateLeDeviceError >& error);

   virtual void onCreateLeDeviceResponse(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< CreateLeDeviceResponse >& response);

   virtual void onRemoveLeDeviceError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< RemoveLeDeviceError >& error);

   virtual void onRemoveLeDeviceResponse(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< RemoveLeDeviceResponse >& response);

   virtual void onLeAdapterInitializationError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeAdapterInitializationError >& error);

   virtual void onLeAdapterInitializationSignal(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeAdapterInitializationSignal >& signal);

   virtual void onLeDeviceCreatedError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeDeviceCreatedError >& error);

   virtual void onLeDeviceCreatedSignal(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeDeviceCreatedSignal >& signal);

   virtual void onLeDeviceRemovedError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeDeviceRemovedError >& error);

   virtual void onLeDeviceRemovedSignal(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeDeviceRemovedSignal >& signal);

   virtual void onAddressTypeError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressTypeError >& error);

   virtual void onAddressTypeUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressTypeUpdate >& update);

   virtual void onAddressError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressError >& error);

   virtual void onAddressUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressUpdate >& update);

   virtual void onAliasError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AliasError >& error);

   virtual void onAliasUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AliasUpdate >& update);

   virtual void onAdvertisingTimeoutError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertisingTimeoutError >& error);

   virtual void onAdvertisingTimeoutUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertisingTimeoutUpdate >& update);

   virtual void onDiscoverableModeError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoverableModeError >& error);

   virtual void onDiscoverableModeUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoverableModeUpdate >& update);

   virtual void onAdvertisingDataError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertisingDataError >& error);

   virtual void onAdvertisingDataUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertisingDataUpdate >& update);

   virtual void onAdvertiseEnableError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertiseEnableError >& error);

   virtual void onAdvertiseEnableUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertiseEnableUpdate >& update);
   // org/bluez/LE_Adapter1Proxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusLEAdapterCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_LE_ADAPTER_CALLBACK_IF_H_
