/**
 * @file EvolutionGeniviDbusHfpModemCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpModem.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for HfpModem.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_MODEM_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_MODEM_CALLBACK_IF_H_

#include "IEvolutionGeniviHfpModemCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/ofono/ModemProxy.h"

using namespace ::org::ofono::Modem;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusHfpModemCallbackIf : public DbusCallbackIf, public IEvolutionGeniviHfpModemCallbackIf
{
public:
   EvolutionGeniviDbusHfpModemCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusHfpModemCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/ofono/ModemProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error);

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response);

   virtual void onSetPropertyError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error);

   virtual void onSetPropertyResponse(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response);

   virtual void onAcceptSCOConnectError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< AcceptSCOConnectError >& error);

   virtual void onAcceptSCOConnectResponse(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< AcceptSCOConnectResponse >& response);

   virtual void onPropertyChangedError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error);

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal);

   virtual void onSCOConnectRequestError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< SCOConnectRequestError >& error);

   virtual void onSCOConnectRequestSignal(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< SCOConnectRequestSignal >& signal);
   // org/ofono/ModemProxy implementation --- end

   virtual void setReceiveHandler(IDbusRecHandler* handler);

   virtual void setHfpHandsfreeIf(::ccdbusif::IEvolutionGeniviDbusHfpHandsfreeSendRequestIf* handler);

protected:
   EvolutionGeniviDbusHfpModemCallbackIf();

private:
   ::ccdbusif::IEvolutionGeniviDbusHfpHandsfreeSendRequestIf* _hfpHandsfreeIf;

   void handleInterfaces(const BTSFunctionBlock destFuncBlock, const ::std::string& modemObjPath, const ::ccdbusif::DbusVariantProperty& outProperty, const act_t token);
};

/*
 * inline methods
 */
inline void EvolutionGeniviDbusHfpModemCallbackIf::setReceiveHandler(IDbusRecHandler* handler)
{
   setHandler(handler);
}

inline void EvolutionGeniviDbusHfpModemCallbackIf::setHfpHandsfreeIf(::ccdbusif::IEvolutionGeniviDbusHfpHandsfreeSendRequestIf* handler)
{
   _hfpHandsfreeIf = handler;
}

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_MODEM_CALLBACK_IF_H_
