/**
 * @file EvolutionGeniviDbusDeviceFactory.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for Device.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Device.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_DEVICE_FACTORY_H_
#define _EVOLUTION_GENIVI_DBUS_DEVICE_FACTORY_H_

#include <stdbool.h> // <cstdbool> is marked with C++11

// class forward declarations
namespace ccdbusif {
class IEvolutionGeniviDbusDeviceCallbackIf;
} //ccdbusif

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

// class forward declarations
class EvolutionGeniviDbusDeviceCallbackIf;

/**
 *
 */
class EvolutionGeniviDbusDeviceFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static EvolutionGeniviDbusDeviceFactory& getInstance(void);

   /**
    * Get callback instance (pointer).
    *
    * @param[in] handler: receive handler
    *
    * @return = pointer to callback instance
    */
   ::ccdbusif::IEvolutionGeniviDbusDeviceCallbackIf* getCb(IDbusRecHandler* handler);

   /**
    * Destroy callback instance (pointer).
    */
   void destroyCb(void);

   /**
    * Set callback instance (pointer).
    * For testing purpose (unit test).
    * If callback instance is set by external user via this interface the caller is responsible to free the callback instance at the end of the test run.
    *
    * @param[in] testCallback: test version of callback instance (pointer)
    */
   void setCbForTesting(EvolutionGeniviDbusDeviceCallbackIf* testCallback);

private:
   /**
    * Default constructor. Private!!!
    */
   EvolutionGeniviDbusDeviceFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~EvolutionGeniviDbusDeviceFactory();

   bool _createdLocally; /**< creator flag */
   EvolutionGeniviDbusDeviceCallbackIf* _cb; /**< callback instance */
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_DEVICE_FACTORY_H_
