/**
 * @file EvolutionGeniviDbusAgentManagerCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for AgentManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback Interface for AgentManager.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_AGENT_MANAGER_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_DBUS_AGENT_MANAGER_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusAgentManagerCallbackIf.h"
#include "DbusCallbackIf.h"

#include "org/bluez/AgentManagerProxy.h"

using namespace ::org::bluez::AgentManager;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class EvolutionGeniviDbusAgentManagerCallbackIf : public DbusCallbackIf, public ::ccdbusif::IEvolutionGeniviDbusAgentManagerCallbackIf
{
public:
   EvolutionGeniviDbusAgentManagerCallbackIf(IDbusRecHandler* recHandler);
   virtual ~EvolutionGeniviDbusAgentManagerCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/AgentManagerProxy implementation --- start
   virtual void onRegisterAgentError(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RegisterAgentError >& error);

   virtual void onRegisterAgentResponse(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RegisterAgentResponse >& response);

   virtual void onUnregisterAgentError(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< UnregisterAgentError >& error);

   virtual void onUnregisterAgentResponse(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< UnregisterAgentResponse >& response);

   virtual void onRequestDefaultAgentError(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RequestDefaultAgentError >& error);

   virtual void onRequestDefaultAgentResponse(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RequestDefaultAgentResponse >& response);
   // org/bluez/AgentManagerProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   EvolutionGeniviDbusAgentManagerCallbackIf();
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_DBUS_AGENT_MANAGER_CALLBACK_IF_H_
