/**
 * @file ConnManDbusTechnologyCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief ConnMan DBUS Callback Interface for Technology.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS Callback Interface for Technology.
 */

#ifndef _CONN_MAN_DBUS_TECHNOLOGY_CALLBACK_IF_H_
#define _CONN_MAN_DBUS_TECHNOLOGY_CALLBACK_IF_H_

#include "cc_dbus_if/IConnManDbusTechnologyCallbackIf.h"
#include "DbusCallbackIf.h"

#include "net/connman/TechnologyProxy.h"

using namespace ::net::connman::Technology;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class ConnManDbusTechnologyCallbackIf : public DbusCallbackIf, public ::ccdbusif::IConnManDbusTechnologyCallbackIf
{
public:
   ConnManDbusTechnologyCallbackIf(IDbusRecHandler* recHandler);
   virtual ~ConnManDbusTechnologyCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // net/connman/TechnologyProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error);

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response);

   virtual void onPropertyChangedError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error);

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal);
   // net/connman/TechnologyProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

protected:
   ConnManDbusTechnologyCallbackIf();
};

} //genivi
} //btstackif

#endif //_CONN_MAN_DBUS_TECHNOLOGY_CALLBACK_IF_H_
