/**
 * @file ConnManDbusServiceFactory.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief ConnMan instance factory for Service.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan instance factory for Service.
 */

#ifndef _CONN_MAN_DBUS_SERVICE_FACTORY_H_
#define _CONN_MAN_DBUS_SERVICE_FACTORY_H_

#include <stdbool.h> // <cstdbool> is marked with C++11

namespace ccdbusif {
class IConnManDbusServiceCallbackIf;
} //ccdbusif

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

// class forward declarations
class ConnManDbusServiceCallbackIf;

/**
 *
 */
class ConnManDbusServiceFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static ConnManDbusServiceFactory& getInstance(void);

   /**
    * Get callback instance (pointer).
    *
    * @param[in] handler: receive handler
    *
    * @return = pointer to callback instance
    */
   ::ccdbusif::IConnManDbusServiceCallbackIf* getCb(IDbusRecHandler* handler);

   /**
    * Destroy callback instance (pointer).
    */
   void destroyCb(void);

   /**
    * Set callback instance (pointer).
    * For testing purpose (unit test).
    * If callback instance is set by external user via this interface the caller is responsible to free the callback instance at the end of the test run.
    *
    * @param[in] testCallback: test version of callback instance (pointer)
    */
   void setCbForTesting(ConnManDbusServiceCallbackIf* testCallback);

private:
   /**
    * Default constructor. Private!!!
    */
   ConnManDbusServiceFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~ConnManDbusServiceFactory();

   bool _createdLocally; /**< creator flag */
   ConnManDbusServiceCallbackIf* _cb; /**< callback instance */
};

} //genivi
} //btstackif

#endif //_CONN_MAN_DBUS_SERVICE_FACTORY_H_
