/**
 * @file ConnManDbusManagerCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief ConnMan DBUS Callback Interface for Manager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details ConnMan DBUS Callback Interface for Manager.
 */

#ifndef _CONN_MAN_DBUS_MANAGER_CALLBACK_IF_H_
#define _CONN_MAN_DBUS_MANAGER_CALLBACK_IF_H_

#include "cc_dbus_if/IConnManDbusManagerCallbackIf.h"
#include "cc_dbus_if/IConnManDbusServiceSendRequestIf.h"
#include "DbusCallbackIf.h"

#include "net/connman/ManagerProxy.h"

using namespace ::net::connman::Manager;
using namespace ::asf::core;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 *
 */
class ConnManDbusManagerCallbackIf : public DbusCallbackIf, public ::ccdbusif::IConnManDbusManagerCallbackIf
{
public:
   ConnManDbusManagerCallbackIf(IDbusRecHandler* recHandler);
   virtual ~ConnManDbusManagerCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // net/connman/ManagerProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error);

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response);

   virtual void onGetTechnologiesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetTechnologiesError >& error);

   virtual void onGetTechnologiesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetTechnologiesResponse >& response);

   virtual void onGetServicesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetServicesError >& error);

   virtual void onGetServicesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetServicesResponse >& response);

   virtual void onPropertyChangedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error);

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal);

   virtual void onTechnologyAddedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TechnologyAddedError >& error);

   virtual void onTechnologyAddedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TechnologyAddedSignal >& signal);

   virtual void onTechnologyRemovedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TechnologyRemovedError >& error);

   virtual void onTechnologyRemovedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TechnologyRemovedSignal >& signal);

   virtual void onServicesChangedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ServicesChangedError >& error);

   virtual void onServicesChangedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ServicesChangedSignal >& signal);
   // net/connman/ManagerProxy implementation --- end

   inline void setReceiveHandler(IDbusRecHandler* handler) { setHandler(handler); }

   virtual void setServiceIf(::ccdbusif::IConnManDbusServiceSendRequestIf* handler) {_serviceIf = handler; };

protected:
   ConnManDbusManagerCallbackIf();

   void checkServiceEntry(const ::std::string& objPath, ::std::map< ::std::string, ::asf::dbus::DBusVariant >& paramDict, const act_t token);
   void checkRemovedEntry(const ::std::string& objPath, const act_t token);

private:
   ::ccdbusif::IConnManDbusServiceSendRequestIf* _serviceIf;
};

} //genivi
} //btstackif

#endif //_CONN_MAN_DBUS_MANAGER_CALLBACK_IF_H_
