/**
 * @file EvolutionGeniviSerialFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for Serial.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Serial.
 */

#include "EvolutionGeniviSerialFactory.h"
#include "EvolutionGeniviSerialCallbackIf.h"

namespace btstackif {
namespace genivi {

EvolutionGeniviSerialFactory::EvolutionGeniviSerialFactory() :
_createdLocally(true),
_cb(0)
{
}

EvolutionGeniviSerialFactory::~EvolutionGeniviSerialFactory()
{
   _cb = 0;
}

EvolutionGeniviSerialFactory& EvolutionGeniviSerialFactory::getInstance(void)
{
   static EvolutionGeniviSerialFactory factory;
   return factory;
}

IEvolutionGeniviSerialCallbackIf* EvolutionGeniviSerialFactory::getCb(IDbusRecHandler* handler)
{
   if(0 != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new EvolutionGeniviSerialCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void EvolutionGeniviSerialFactory::destroyCb(void)
{
   if((0 != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = 0;
   }
}

void EvolutionGeniviSerialFactory::setCbForTesting(IEvolutionGeniviSerialCallbackIf* testCallback)
{
   if(0 != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

} //genivi
} //btstackif
