/**
 * @file IEvolutionGeniviAgentCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Agent.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for Agent.
 */

#ifndef _I_EVOLUTION_GENIVI_AGENT_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_AGENT_CALLBACK_IF_H_

#include "cc_dbus_if/IEvolutionGeniviDbusAgentCallbackIf.h"

using namespace ::org::bluez::Agent;

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

/**
 * Callback interface class for Agent.
 */
class IEvolutionGeniviAgentCallbackIf : public ::ccdbusif::IEvolutionGeniviDbusAgentCallbackIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviAgentCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   // --- not needed because Agent interface is provided by local side ---
   // "ServiceAvailableIF" implementation --- end

   // /org/bluez/AgentStub implementation --- start
   virtual void onReleaseRequest(const ::boost::shared_ptr< ReleaseRequest >& request, const act_t act) = 0;

   virtual void onRequestPinCodeRequest(const ::boost::shared_ptr< RequestPinCodeRequest >& request, const act_t act) = 0;

   virtual void onDisplayPinCodeRequest(const ::boost::shared_ptr< DisplayPinCodeRequest >& request, const act_t act) = 0;

   virtual void onRequestPasskeyRequest(const ::boost::shared_ptr< RequestPasskeyRequest >& request, const act_t act) = 0;

   virtual void onRequestConfirmationRequest(const ::boost::shared_ptr< RequestConfirmationRequest >& request, const act_t act) = 0;

   virtual void onCancelRequest(const ::boost::shared_ptr< CancelRequest >& request, const act_t act) = 0;

   virtual void onCancelRequestRequest(const ::boost::shared_ptr< CancelRequestRequest >& request, const act_t act) = 0;

   virtual void onAuthorizeServiceRequest(const ::boost::shared_ptr< AuthorizeServiceRequest >& request, const act_t act) = 0;

   virtual void onRequestAuthorizationRequest(const ::boost::shared_ptr< RequestAuthorizationRequest >& request, const act_t act) = 0;

   virtual void onRequestLinkkeyRequest(const ::boost::shared_ptr< RequestLinkkeyRequest >& request, const act_t act) = 0;

   virtual void onDisplayPasskeyRequest (const ::boost::shared_ptr< DisplayPasskeyRequest >& request, const act_t act) = 0;
   // /org/bluez/AgentStub implementation --- end

   /**
    * Set receive handler.
    *
    * @param[in] handler: receive handler
    */
   virtual void setReceiveHandler(IDbusRecHandler* handler) = 0;

   /**
    * Set callback id.
    *
    * @param[in] callbackId: callback id
    */
   virtual void setCallbackId(const unsigned int callbackId) = 0;

   /**
    * Get callback id.
    *
    * @return = callback id
    */
   virtual unsigned int getCallbackId(void) const = 0;
};

} //genivi
} //btstackif

#endif //_I_EVOLUTION_GENIVI_AGENT_CALLBACK_IF_H_
