/**
 * @file IConnectionOrgFreedesktopObjectManagerCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief OrgFreedesktop DBUS Callback Interface for ObjectManager.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for OrgFreedesktop DBUS callback for ObjectManager.
 */

#ifndef _I_CONNECTION_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_
#define _I_CONNECTION_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_

#include "cc_dbus_if/IOrgFreedesktopDbusObjectManagerCallbackIf.h"

using namespace ::objmgr::org::freedesktop::DBus::ObjectManager;

// class forward declarations
namespace ccdbusif {
class IEvolutionGeniviDbusDeviceSendRequestIf;
class IEvolutionGeniviDbusServiceSendRequestIf;
class IEvolutionGeniviDbusSerialSendRequestIf;
} //ccdbusif

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

// class forward declarations
class IEvolutionGeniviSerialCallbackIf;

/**
 * Callback interface class for ObjectManager.
 */
class IConnectionOrgFreedesktopObjectManagerCallbackIf : public ::ccdbusif::IOrgFreedesktopDbusObjectManagerCallbackIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IConnectionOrgFreedesktopObjectManagerCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM) = 0;

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM) = 0;
   // "ServiceAvailableIF" implementation --- end

   // /objmgr/org/freedesktop/DBus/ObjectManagerProxy implementation --- start
   virtual void onGetManagedObjectsErrorCb(const ::boost::shared_ptr< GetManagedObjectsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onGetManagedObjectsResponseCb(const ::boost::shared_ptr< GetManagedObjectsResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onInterfacesAddedErrorCb(const ::boost::shared_ptr< InterfacesAddedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onInterfacesAddedSignalCb(const ::boost::shared_ptr< InterfacesAddedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onInterfacesRemovedErrorCb(const ::boost::shared_ptr< InterfacesRemovedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   virtual void onInterfacesRemovedSignalCb(const ::boost::shared_ptr< InterfacesRemovedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;
   // /objmgr/org/freedesktop/DBus/ObjectManagerProxy implementation --- end

   /**
    * Set receive handler.
    *
    * @param[in] handler: receive handler
    */
   virtual void setReceiveHandler(IDbusRecHandler* handler) = 0;

   /**
    * Set callback id.
    *
    * @param[in] callbackId: callback id
    */
   virtual void setCallbackId(const unsigned int callbackId) = 0;

   /**
    * Get callback id.
    *
    * @return = callback id
    */
   virtual unsigned int getCallbackId(void) const = 0;

   /**
    * Set device handler.
    *
    * @param[in] deviceSendIf: device handler
    */
   virtual void setDeviceSendIf(::ccdbusif::IEvolutionGeniviDbusDeviceSendRequestIf* deviceSendIf) = 0;

   /**
    * Set service handler.
    *
    * @param[in] serviceSendIf: service handler
    */
   virtual void setServiceSendIf(::ccdbusif::IEvolutionGeniviDbusServiceSendRequestIf* serviceSendIf) = 0;

   /**
    * Set serial handler.
    *
    * @param[in] serialSendIf: serial handler
    */
   virtual void setSerialSendIf(::ccdbusif::IEvolutionGeniviDbusSerialSendRequestIf* serialSendIf) = 0;

   /**
    * Set serial callback.
    *
    * @param[in] serialCb: serial callback
    */
   virtual void setSerialCb(IEvolutionGeniviSerialCallbackIf* serialCb) = 0;

   /**
    * Simulation command.
    *
    * @param[in] enable: enable flag
    */
   virtual void setSimulateRequestConfirmation(const bool enable) = 0;
};

} //genivi
} //btstackif

#endif //_I_CONNECTION_ORG_FREEDESKTOP_OBJECT_MANAGER_CALLBACK_IF_H_
