/**
 * @file EvolutionGeniviSerialCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback for Serial.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback for Serial.
 */

#ifndef _EVOLUTION_GENIVI_SERIAL_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_SERIAL_CALLBACK_IF_H_

#include "IEvolutionGeniviSerialCallbackIf.h"
#include "DbusCallbackIf.h"

using namespace ::org::bluez::Serial;

namespace btstackif {
namespace genivi {

/**
 * Callback class for Serial.
 */
class EvolutionGeniviSerialCallbackIf : public DbusCallbackIf, public IEvolutionGeniviSerialCallbackIf
{
public:
   /**
    * Constructor.
    *
    * @param[in] recHandler: receive handler
    */
   EvolutionGeniviSerialCallbackIf(IDbusRecHandler* recHandler);

   /**
    * Destructor.
    */
   virtual ~EvolutionGeniviSerialCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM);

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM);
   // "ServiceAvailableIF" implementation --- end

   // /org/bluez/SerialProxy implementation --- start
   virtual void onSendDataErrorCb(const ::boost::shared_ptr< SendDataError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onSendDataResponseCb(const ::boost::shared_ptr< SendDataResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onSppDataIndErrorCb(const ::boost::shared_ptr< SppDataIndError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onSppDataIndSignalCb(const ::boost::shared_ptr< SppDataIndSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onFlowCtrlSendErrorCb(const ::boost::shared_ptr< FlowCtrlSendError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onFlowCtrlSendSignalCb(const ::boost::shared_ptr< FlowCtrlSendSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceFilePathErrorCb(const ::boost::shared_ptr< DeviceFilePathError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceFilePathSignalCb(const ::boost::shared_ptr< DeviceFilePathSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onFlowCtrlRecvErrorCb(const ::boost::shared_ptr< FlowCtrlRecvError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onFlowCtrlRecvUpdateCb(const ::boost::shared_ptr< FlowCtrlRecvUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const ::ccdbusif::DbusBusType busType = ::ccdbusif::BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());
   // /org/bluez/SerialProxy implementation --- end

   virtual void setReceiveHandler(IDbusRecHandler* handler);

   virtual void setCallbackId(const unsigned int callbackId);

   virtual unsigned int getCallbackId(void) const;

private:
   unsigned int _callbackId; /**< callback id */
};

/**
 * inline methods
 */
inline void EvolutionGeniviSerialCallbackIf::setReceiveHandler(IDbusRecHandler* handler)
{
   setHandler(handler);
}

inline void EvolutionGeniviSerialCallbackIf::setCallbackId(const unsigned int callbackId)
{
   _callbackId = callbackId;
}

inline unsigned int EvolutionGeniviSerialCallbackIf::getCallbackId(void) const
{
   return _callbackId;
}

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_SERIAL_CALLBACK_IF_H_
