/**
 * @file EvolutionGeniviAgentCallbackIf.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi DBUS Callback for Agent.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Callback for Agent.
 */

#ifndef _EVOLUTION_GENIVI_AGENT_CALLBACK_IF_H_
#define _EVOLUTION_GENIVI_AGENT_CALLBACK_IF_H_

#include "IEvolutionGeniviAgentCallbackIf.h"
#include "DbusCallbackIf.h"

using namespace ::org::bluez::Agent;

namespace btstackif {
namespace genivi {

/**
 * Callback class for Agent.
 */
class EvolutionGeniviAgentCallbackIf : public DbusCallbackIf, public IEvolutionGeniviAgentCallbackIf
{
public:
   /**
    * Constructor.
    *
    * @param[in] recHandler: receive handler
    */
   EvolutionGeniviAgentCallbackIf(IDbusRecHandler* recHandler);

   /**
    * Destructor.
    */
   virtual ~EvolutionGeniviAgentCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   // --- not needed because Agent interface is provided by local side ---
   // "ServiceAvailableIF" implementation --- end

   // /org/bluez/AgentStub implementation --- start
   virtual void onReleaseRequest(const ::boost::shared_ptr< ReleaseRequest >& request, const act_t act);

   virtual void onRequestPinCodeRequest(const ::boost::shared_ptr< RequestPinCodeRequest >& request, const act_t act);

   virtual void onDisplayPinCodeRequest(const ::boost::shared_ptr< DisplayPinCodeRequest >& request, const act_t act);

   virtual void onRequestPasskeyRequest(const ::boost::shared_ptr< RequestPasskeyRequest >& request, const act_t act);

   virtual void onRequestConfirmationRequest(const ::boost::shared_ptr< RequestConfirmationRequest >& request, const act_t act);

   virtual void onCancelRequest(const ::boost::shared_ptr< CancelRequest >& request, const act_t act);

   virtual void onCancelRequestRequest(const ::boost::shared_ptr< CancelRequestRequest >& request, const act_t act);

   virtual void onAuthorizeServiceRequest(const ::boost::shared_ptr< AuthorizeServiceRequest >& request, const act_t act);

   virtual void onRequestAuthorizationRequest(const ::boost::shared_ptr< RequestAuthorizationRequest >& request, const act_t act);

   virtual void onRequestLinkkeyRequest(const ::boost::shared_ptr< RequestLinkkeyRequest >& request, const act_t act);

   virtual void onDisplayPasskeyRequest(const ::boost::shared_ptr< DisplayPasskeyRequest >& request, const act_t act);
   // /org/bluez/AgentStub implementation --- end

   virtual void setReceiveHandler(IDbusRecHandler* handler);

   virtual void setCallbackId(const unsigned int callbackId);

   virtual unsigned int getCallbackId(void) const;

private:
   unsigned int _callbackId; /**< callback id */
};

/**
 * inline methods
 */
inline void EvolutionGeniviAgentCallbackIf::setReceiveHandler(IDbusRecHandler* handler)
{
   setHandler(handler);
}

inline void EvolutionGeniviAgentCallbackIf::setCallbackId(const unsigned int callbackId)
{
   _callbackId = callbackId;
}

inline unsigned int EvolutionGeniviAgentCallbackIf::getCallbackId(void) const
{
   return _callbackId;
}

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_AGENT_CALLBACK_IF_H_
