/**
 * @file EvolutionGeniviAdapterFactory.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief EvolutionGenivi instance factory for Adapter.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Adapter.
 */

#ifndef _EVOLUTION_GENIVI_ADAPTER_FACTORY_H_
#define _EVOLUTION_GENIVI_ADAPTER_FACTORY_H_

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {

// class forward declarations
class IEvolutionGeniviAdapterCallbackIf;

/**
 * Factory class for EvolutionGeniviAdapter.
 */
class EvolutionGeniviAdapterFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static EvolutionGeniviAdapterFactory& getInstance(void);

   /**
    * Get callback instance (pointer).
    *
    * @param[in] handler: receive handler
    *
    * @return = pointer to callback instance
    */
   IEvolutionGeniviAdapterCallbackIf* getCb(IDbusRecHandler* handler);

   /**
    * Destroy callback instance (pointer).
    */
   void destroyCb(void);

   /**
    * Set callback instance (pointer).
    * For testing purpose (unit test).
    * If callback instance is set by external user via this interface the caller is responsible to free the callback instance at the end of the test run.
    *
    * @param[in] testCallback: test version of callback instance (pointer)
    */
   void setCbForTesting(IEvolutionGeniviAdapterCallbackIf* testCallback);

private:
   /**
    * Default constructor. Private!!!
    */
   EvolutionGeniviAdapterFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~EvolutionGeniviAdapterFactory();

   bool _createdLocally; /**< creator flag */
   IEvolutionGeniviAdapterCallbackIf* _cb; /**< callback instance */
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_ADAPTER_FACTORY_H_
