/**
 * @file EvolutionGeniviStackTypesTrace.cpp
 *
 * @par SW-Component
 * Trace
 *
 * @brief Trace enum to string.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Trace enum to string.
 * This file is completely generated by parser tooling (code generation). => DO NOT EDIT!
 */

#include "EvolutionGeniviStackTypesTrace.h"

namespace btstackif {
namespace genivi {

const char* getLogStatus2String(BTSLogStatus value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_LOG_WRITE:
         result = "WRITE";
         break;
      case BTS_LOG_READ:
         result = "READ";
         break;
      case BTS_LOG_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getStatusCode2String(BTSStatusCode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_STATUS_CODE_SUCCESS:
         result = "SUCCESS";
         break;
      case BTS_STATUS_CODE_UNKNOWN_OPCODE:
         result = "UNKNOWN_OPCODE";
         break;
      case BTS_STATUS_CODE_ILLEGAL_FORMAT:
         result = "ILLEGAL_FORMAT";
         break;
      case BTS_STATUS_CODE_ILLEGAL_PARAM:
         result = "ILLEGAL_PARAM";
         break;
      case BTS_STATUS_CODE_OPERATION_FAIL:
         result = "OPERATION_FAIL";
         break;
      case BTS_STATUS_CODE_SYSTEM_BUSY:
         result = "SYSTEM_BUSY";
         break;
      case BTS_STATUS_CODE_ILLEGAL_OPERATION:
         result = "ILLEGAL_OPERATION";
         break;
      case BTS_STATUS_CODE_ILLEGAL_STATE:
         result = "ILLEGAL_STATE";
         break;
      case BTS_STATUS_CODE_PS_FAILURE:
         result = "PS_FAILURE";
         break;
      case BTS_STATUS_CODE_SDP_FAILURE:
         result = "SDP_FAILURE";
         break;
      case BTS_STATUS_CODE_ABNORMAL:
         result = "ABNORMAL";
         break;
      case BTS_STATUS_CODE_ABORTED:
         result = "ABORTED";
         break;
      case BTS_STATUS_CODE_EXTENDED_ERROR:
         result = "EXTENDED_ERROR";
         break;
      case BTS_STATUS_CODE_SDP_CONNECTION_ERROR:
         result = "SDP_CONNECTION_ERROR";
         break;
      case BTS_STATUS_CODE_TIMEOUT_ERROR:
         result = "TIMEOUT_ERROR";
         break;
      case BTS_STATUS_CODE_RESTRICTED_CONNECTION:
         result = "RESTRICTED_CONNECTION";
         break;
      case BTS_STATUS_CODE_RAWDATA_ILLEGAL:
         result = "RAWDATA_ILLEGAL";
         break;
      case BTS_STATUS_CODE_SERVICE_NOTSUPPORTED:
         result = "SERVICE_NOTSUPPORTED";
         break;
      case BTS_STATUS_CODE_MOREDATA_EXPECTED:
         result = "MOREDATA_EXPECTED";
         break;
      case BTS_STATUS_CODE_PAGE_TIMEOUT:
         result = "PAGE_TIMEOUT";
         break;
      case BTS_STATUS_CODE_LMP_TIMEOUT:
         result = "LMP_TIMEOUT";
         break;
      case BTS_STATUS_CODE_SERVICE_CONNECT_TIMEOUT:
         result = "SERVICE_CONNECT_TIMEOUT";
         break;
      case BTS_STATUS_CODE_AUTHENTICATION_FAILURE:
         result = "AUTHENTICATION_FAILURE";
         break;
      case BTS_STATUS_CODE_PIN_OR_KEY_MISSING:
         result = "PIN_OR_KEY_MISSING";
         break;
      case BTS_STATUS_CODE_ROLE_CHANGE_NOT_ALLOWED:
         result = "ROLE_CHANGE_NOT_ALLOWED";
         break;
      case BTS_STATUS_CODE_CONNECT_REJECT_BDADDR:
         result = "CONNECT_REJECT_BDADDR";
         break;
      case BTS_STATUS_CODE_ACL_EXISTS:
         result = "ACL_EXISTS";
         break;
      case BTS_STATUS_CODE_ACL_NOT_CONNECTED:
         result = "ACL_NOT_CONNECTED";
         break;
      case BTS_STATUS_CODE_HW_FAILURE:
         result = "HW_FAILURE";
         break;
      case BTS_STATUS_CODE_CONNECT_REJECT_LIMITED_RESOURCES:
         result = "CONNECT_REJECT_LIMITED_RESOURCES";
         break;
      case BTS_STATUS_CODE_CONNECT_REJECT_SECURITY_REASONS:
         result = "CONNECT_REJECT_SECURITY_REASONS";
         break;
      case BTS_STATUS_CODE_REMOTE_DISCONNECT_LOW_RESOURCES:
         result = "REMOTE_DISCONNECT_LOW_RESOURCES";
         break;
      case BTS_STATUS_CODE_REMOTE_DISCONNECT_POWEROFF:
         result = "REMOTE_DISCONNECT_POWEROFF";
         break;
      case BTS_STATUS_CODE_PAIRING_NOT_ALLOWED:
         result = "PAIRING_NOT_ALLOWED";
         break;
      case BTS_STATUS_CODE_CONNECTION_ACCEPT_TIMEOUT:
         result = "CONNECTION_ACCEPT_TIMEOUT";
         break;
      case BTS_STATUS_CODE_LOCAL_REJECT:
         result = "LOCAL_REJECT";
         break;
      case BTS_STATUS_CODE_REMOTE_REJECT:
         result = "REMOTE_REJECT";
         break;
      case BTS_STATUS_CODE_INTERFACE_REMOVED:
         result = "INTERFACE_REMOVED";
         break;
      case BTS_STATUS_CODE_REMOTE_DISCONNECT_ACL:
         result = "REMOTE_DISCONNECT_ACL";
         break;
      case BTS_STATUS_CODE_ONLY_RSSI_SUCCESS:
         result = "ONLY_RSSI_SUCCESS";
         break;
      case BTS_STATUS_CODE_ONLY_LINK_QUALITY_SUCCESS:
         result = "ONLY_LINK_QUALITY_SUCCESS";
         break;
      case BTS_STATUS_CODE_FAULT_LC_LMP_IN_INVALID_PACKET:
         result = "FAULT_LC_LMP_IN_INVALID_PACKET";
         break;
      case BTS_STATUS_CODE_FAULT_HOSTIO_FROZEN_HANDLES:
         result = "FAULT_HOSTIO_FROZEN_HANDLES";
         break;
      case BTS_STATUS_CODE_DSP_LOAD_SEQUENCING_ERROR:
         result = "DSP_LOAD_SEQUENCING_ERROR";
         break;
      case BTS_STATUS_CODE_SUCCESS_SLAVE:
         result = "SUCCESS_SLAVE";
         break;
      case BTS_STATUS_CODE_SERVICE_INCOMING:
         result = "SERVICE_INCOMING";
         break;
      case BTS_STATUS_CODE_INSTANCE_COLLISION:
         result = "INSTANCE_COLLISION";
         break;
      case BTS_STATUS_CODE_CONNECT_COLLISION:
         result = "CONNECT_COLLISION";
         break;
      case BTS_STATUS_CODE_START_OTHER_CODES:
         result = "START_OTHER_CODES";
         break;
      case BTS_STATUS_CODE_INVALID_ARGUMENTS:
         result = "INVALID_ARGUMENTS";
         break;
      case BTS_STATUS_CODE_IN_PROGRESS:
         result = "IN_PROGRESS";
         break;
      case BTS_STATUS_CODE_ALREADY_EXISTS:
         result = "ALREADY_EXISTS";
         break;
      case BTS_STATUS_CODE_NOT_SUPPORTED:
         result = "NOT_SUPPORTED";
         break;
      case BTS_STATUS_CODE_NOT_CONNECTED:
         result = "NOT_CONNECTED";
         break;
      case BTS_STATUS_CODE_ALREADY_CONNECTED:
         result = "ALREADY_CONNECTED";
         break;
      case BTS_STATUS_CODE_NOT_AVAILABLE:
         result = "NOT_AVAILABLE";
         break;
      case BTS_STATUS_CODE_NOT_AUTHORIZED:
         result = "NOT_AUTHORIZED";
         break;
      case BTS_STATUS_CODE_AGENT_NOT_AVAILABLE:
         result = "AGENT_NOT_AVAILABLE";
         break;
      case BTS_STATUS_CODE_NOT_READY:
         result = "NOT_READY";
         break;
      case BTS_STATUS_CODE_FAILED:
         result = "FAILED";
         break;
      case BTS_STATUS_CODE_INVALID_FORMAT:
         result = "INVALID_FORMAT";
         break;
      case BTS_STATUS_CODE_NOT_IMPLEMENTED:
         result = "NOT_IMPLEMENTED";
         break;
      case BTS_STATUS_CODE_NOT_FOUND:
         result = "NOT_FOUND";
         break;
      case BTS_STATUS_CODE_NOT_ACTIVE:
         result = "NOT_ACTIVE";
         break;
      case BTS_STATUS_CODE_TIMED_OUT:
         result = "TIMED_OUT";
         break;
      case BTS_STATUS_CODE_IN_USE:
         result = "IN_USE";
         break;
      case BTS_STATUS_CODE_FORBIDDEN:
         result = "FORBIDDEN";
         break;
      case BTS_STATUS_CODE_CONNECT_FAILED:
         result = "CONNECT_FAILED";
         break;
      case BTS_STATUS_CODE_DOES_NOT_EXIST:
         result = "DOES_NOT_EXIST";
         break;
      case BTS_STATUS_CODE_CONNECTION_LOST:
         result = "CONNECTION_LOST";
         break;
      case BTS_STATUS_CODE_AUTHENTICATION_ERROR:
         result = "AUTHENTICATION_ERROR";
         break;
      case BTS_STATUS_CODE_PAIRING_CANCELLED:
         result = "PAIRING_CANCELLED";
         break;
      case BTS_STATUS_CODE_UNKNOWN_REASON:
         result = "UNKNOWN_REASON";
         break;
      case BTS_STATUS_CODE_RETRY_ABORTED:
         result = "RETRY_ABORTED";
         break;
      case BTS_STATUS_CODE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getBtApplDisconnectReason2String(BTSBtApplDisconnectReason value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_BT_APPL_DISCONNECT_REASON_LOCAL_DEVICE:
         result = "LOCAL_DEVICE";
         break;
      case BTS_BT_APPL_DISCONNECT_REASON_REMOTE_DEVICE:
         result = "REMOTE_DEVICE";
         break;
      case BTS_BT_APPL_DISCONNECT_REASON_EXCEPTION:
         result = "EXCEPTION";
         break;
      case BTS_BT_APPL_DISCONNECT_REASON_LINK_LOSS:
         result = "LINK_LOSS";
         break;
      case BTS_BT_APPL_DISCONNECT_REASON_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getServiceState2String(BTSServiceState value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_SERVICE_STATE_DISCONNECTED:
         result = "DISCONNECTED";
         break;
      case BTS_SERVICE_STATE_CONNECTING:
         result = "CONNECTING";
         break;
      case BTS_SERVICE_STATE_CONNECTED:
         result = "CONNECTED";
         break;
      case BTS_SERVICE_STATE_DISCONNECTING:
         result = "DISCONNECTING";
         break;
      case BTS_SERVICE_STATE_ERROR:
         result = "ERROR";
         break;
      case BTS_SERVICE_STATE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getDebugTraceLevelBit2String(BTSDebugTraceLevelBit value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_DEBUG_TRACE_LEVEL_FATAL:
         result = "FATAL";
         break;
      case BTS_DEBUG_TRACE_LEVEL_ERROR:
         result = "ERROR";
         break;
      case BTS_DEBUG_TRACE_LEVEL_WARN:
         result = "WARN";
         break;
      case BTS_DEBUG_TRACE_LEVEL_INFO:
         result = "INFO";
         break;
      case BTS_DEBUG_TRACE_LEVEL_DEBUG:
         result = "DEBUG";
         break;
      case BTS_DEBUG_TRACE_LEVEL_LOG:
         result = "LOG";
         break;
      case BTS_DEBUG_TRACE_LEVEL_RESERVED:
         result = "RESERVED";
         break;
      case BTS_DEBUG_TRACE_LEVEL_TIME:
         result = "TIME";
         break;
      case BTS_DEBUG_TRACE_LEVEL_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getDebugTraceMode2String(BTSDebugTraceMode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_DEBUG_TRACE_MODE_DISABLE:
         result = "DISABLE";
         break;
      case BTS_DEBUG_TRACE_MODE_AUTO:
         result = "AUTO";
         break;
      case BTS_DEBUG_TRACE_MODE_MANUAL:
         result = "MANUAL";
         break;
      case BTS_DEBUG_TRACE_MODE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getDebugBtAppCategoryBit2String(BTSDebugBtAppCategoryBit value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_DEBUG_BT_APP_CAT_GAP:
         result = "GAP";
         break;
      case BTS_DEBUG_BT_APP_CAT_CM_DM:
         result = "CM_DM";
         break;
      case BTS_DEBUG_BT_APP_CAT_SPP:
         result = "SPP";
         break;
      case BTS_DEBUG_BT_APP_CAT_HFP:
         result = "HFP";
         break;
      case BTS_DEBUG_BT_APP_CAT_AVP:
         result = "AVP";
         break;
      case BTS_DEBUG_BT_APP_CAT_AVP_RESERVED:
         result = "AVP_RESERVED";
         break;
      case BTS_DEBUG_BT_APP_CAT_PBDL_HFP:
         result = "PBDL_HFP";
         break;
      case BTS_DEBUG_BT_APP_CAT_PBDL_SPP:
         result = "PBDL_SPP";
         break;
      case BTS_DEBUG_BT_APP_CAT_PBDL_PBAP:
         result = "PBDL_PBAP";
         break;
      case BTS_DEBUG_BT_APP_CAT_PBDL_SYNCML:
         result = "PBDL_SYNCML";
         break;
      case BTS_DEBUG_BT_APP_CAT_MSG_HFP:
         result = "MSG_HFP";
         break;
      case BTS_DEBUG_BT_APP_CAT_MSG_MAP:
         result = "MSG_MAP";
         break;
      case BTS_DEBUG_BT_APP_CAT_MSG_SPP:
         result = "MSG_SPP";
         break;
      case BTS_DEBUG_BT_APP_CAT_DUN:
         result = "DUN";
         break;
      case BTS_DEBUG_BT_APP_CAT_OPPS:
         result = "OPPS";
         break;
      case BTS_DEBUG_BT_APP_CAT_OPPC:
         result = "OPPC";
         break;
      case BTS_DEBUG_BT_APP_CAT_BIPR:
         result = "BIPR";
         break;
      case BTS_DEBUG_BT_APP_CAT_BIPI:
         result = "BIPI";
         break;
      case BTS_DEBUG_BT_APP_CAT_PAN:
         result = "PAN";
         break;
      case BTS_DEBUG_BT_APP_CAT_DI:
         result = "DI";
         break;
      case BTS_DEBUG_BT_APP_CAT_HS:
         result = "HS";
         break;
      case BTS_DEBUG_BT_APP_CAT_MISC:
         result = "MISC";
         break;
      case BTS_DEBUG_BT_APP_CAT_SAP:
         result = "SAP";
         break;
      case BTS_DEBUG_BT_APP_CAT_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getDebugBtStackCategoryBit2String(BTSDebugBtStackCategoryBit value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_DEBUG_BT_STACK_CAT_HCI:
         result = "HCI";
         break;
      case BTS_DEBUG_BT_STACK_CAT_L2CAP:
         result = "L2CAP";
         break;
      case BTS_DEBUG_BT_STACK_CAT_RFCOMM:
         result = "RFCOMM";
         break;
      case BTS_DEBUG_BT_STACK_CAT_OBEX:
         result = "OBEX";
         break;
      case BTS_DEBUG_BT_STACK_CAT_SDP:
         result = "SDP";
         break;
      case BTS_DEBUG_BT_STACK_CAT_GAP:
         result = "GAP";
         break;
      case BTS_DEBUG_BT_STACK_CAT_SPP:
         result = "SPP";
         break;
      case BTS_DEBUG_BT_STACK_CAT_BTMNG:
         result = "BTMNG";
         break;
      case BTS_DEBUG_BT_STACK_CAT_SEC:
         result = "SEC";
         break;
      case BTS_DEBUG_BT_STACK_CAT_AVRCP:
         result = "AVRCP";
         break;
      case BTS_DEBUG_BT_STACK_CAT_A2DP:
         result = "A2DP";
         break;
      case BTS_DEBUG_BT_STACK_CAT_DUN:
         result = "DUN";
         break;
      case BTS_DEBUG_BT_STACK_CAT_OPP:
         result = "OPP";
         break;
      case BTS_DEBUG_BT_STACK_CAT_HANDSFREE:
         result = "HANDSFREE";
         break;
      case BTS_DEBUG_BT_STACK_CAT_BIP:
         result = "BIP";
         break;
      case BTS_DEBUG_BT_STACK_CAT_PBAP:
         result = "PBAP";
         break;
      case BTS_DEBUG_BT_STACK_CAT_3GPP:
         result = "3GPP";
         break;
      case BTS_DEBUG_BT_STACK_CAT_SYNCML:
         result = "SYNCML";
         break;
      case BTS_DEBUG_BT_STACK_CAT_MAP:
         result = "MAP";
         break;
      case BTS_DEBUG_BT_STACK_CAT_BNEP:
         result = "BNEP";
         break;
      case BTS_DEBUG_BT_STACK_CAT_PAN:
         result = "PAN";
         break;
      case BTS_DEBUG_BT_STACK_CAT_DI:
         result = "DI";
         break;
      case BTS_DEBUG_BT_STACK_CAT_A2MP:
         result = "A2MP";
         break;
      case BTS_DEBUG_BT_STACK_CAT_LAYER_SPP_TRANS:
         result = "LAYER_SPP_TRANS";
         break;
      case BTS_DEBUG_BT_STACK_CAT_BTCOMMON:
         result = "BTCOMMON";
         break;
      case BTS_DEBUG_BT_STACK_CAT_SAP:
         result = "SAP";
         break;
      case BTS_DEBUG_BT_STACK_CAT_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getDebugTraceFilterBit2String(BTSDebugTraceFilterBit value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_DEBUG_TRACE_FILTER_HCI_CMD:
         result = "HCI_CMD";
         break;
      case BTS_DEBUG_TRACE_FILTER_ACL:
         result = "ACL";
         break;
      case BTS_DEBUG_TRACE_FILTER_SCO:
         result = "SCO";
         break;
      case BTS_DEBUG_TRACE_FILTER_HCI_EVT:
         result = "HCI_EVT";
         break;
      case BTS_DEBUG_TRACE_FILTER_L2CAP:
         result = "L2CAP";
         break;
      case BTS_DEBUG_TRACE_FILTER_RFCOMM_SABM:
         result = "RFCOMM_SABM";
         break;
      case BTS_DEBUG_TRACE_FILTER_RFCOMM_UIH:
         result = "RFCOMM_UIH";
         break;
      case BTS_DEBUG_TRACE_FILTER_AVDTP:
         result = "AVDTP";
         break;
      case BTS_DEBUG_TRACE_FILTER_AVCTP:
         result = "AVCTP";
         break;
      case BTS_DEBUG_TRACE_FILTER_BNEP:
         result = "BNEP";
         break;
      case BTS_DEBUG_TRACE_FILTER_AV:
         result = "AV";
         break;
      case BTS_DEBUG_TRACE_FILTER_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getDebugTraceDirection2String(BTSDebugTraceDirection value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_DEBUG_TRACE_DIRECTION_RECEIVE:
         result = "RECEIVE";
         break;
      case BTS_DEBUG_TRACE_DIRECTION_SEND:
         result = "SEND";
         break;
      case BTS_DEBUG_TRACE_DIRECTION_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getDebugTraceCategory2String(BTSDebugTraceCategory value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_DEBUG_TRACE_CAT_GAP_APP:
         result = "GAP_APP";
         break;
      case BTS_DEBUG_TRACE_CAT_CM_DM:
         result = "CM_DM";
         break;
      case BTS_DEBUG_TRACE_CAT_SPP_APP:
         result = "SPP_APP";
         break;
      case BTS_DEBUG_TRACE_CAT_HFP:
         result = "HFP";
         break;
      case BTS_DEBUG_TRACE_CAT_AVP:
         result = "AVP";
         break;
      case BTS_DEBUG_TRACE_CAT_AVP_RESERVED:
         result = "AVP_RESERVED";
         break;
      case BTS_DEBUG_TRACE_CAT_PBDL_HFP:
         result = "PBDL_HFP";
         break;
      case BTS_DEBUG_TRACE_CAT_PBDL_SPP:
         result = "PBDL_SPP";
         break;
      case BTS_DEBUG_TRACE_CAT_PBDL_PBAP:
         result = "PBDL_PBAP";
         break;
      case BTS_DEBUG_TRACE_CAT_PBDL_SYNCML:
         result = "PBDL_SYNCML";
         break;
      case BTS_DEBUG_TRACE_CAT_MSG_HFP:
         result = "MSG_HFP";
         break;
      case BTS_DEBUG_TRACE_CAT_MSG_MAP:
         result = "MSG_MAP";
         break;
      case BTS_DEBUG_TRACE_CAT_MSG_SPP:
         result = "MSG_SPP";
         break;
      case BTS_DEBUG_TRACE_CAT_DUN_APP:
         result = "DUN_APP";
         break;
      case BTS_DEBUG_TRACE_CAT_OPPS:
         result = "OPPS";
         break;
      case BTS_DEBUG_TRACE_CAT_OPPC:
         result = "OPPC";
         break;
      case BTS_DEBUG_TRACE_CAT_BIPR:
         result = "BIPR";
         break;
      case BTS_DEBUG_TRACE_CAT_BIPI:
         result = "BIPI";
         break;
      case BTS_DEBUG_TRACE_CAT_PAN_APP:
         result = "PAN_APP";
         break;
      case BTS_DEBUG_TRACE_CAT_DI_APP:
         result = "DI_APP";
         break;
      case BTS_DEBUG_TRACE_CAT_HS:
         result = "HS";
         break;
      case BTS_DEBUG_TRACE_CAT_MISC:
         result = "MISC";
         break;
      case BTS_DEBUG_TRACE_CAT_SAP_APP:
         result = "SAP_APP";
         break;
      case BTS_DEBUG_TRACE_CAT_HCI:
         result = "HCI";
         break;
      case BTS_DEBUG_TRACE_CAT_L2CAP:
         result = "L2CAP";
         break;
      case BTS_DEBUG_TRACE_CAT_RFCOMM:
         result = "RFCOMM";
         break;
      case BTS_DEBUG_TRACE_CAT_OBEX:
         result = "OBEX";
         break;
      case BTS_DEBUG_TRACE_CAT_SDP:
         result = "SDP";
         break;
      case BTS_DEBUG_TRACE_CAT_GAP_STACK:
         result = "GAP_STACK";
         break;
      case BTS_DEBUG_TRACE_CAT_SPP_STACK:
         result = "SPP_STACK";
         break;
      case BTS_DEBUG_TRACE_CAT_BTMNG:
         result = "BTMNG";
         break;
      case BTS_DEBUG_TRACE_CAT_SEC:
         result = "SEC";
         break;
      case BTS_DEBUG_TRACE_CAT_AVRCP:
         result = "AVRCP";
         break;
      case BTS_DEBUG_TRACE_CAT_A2DP:
         result = "A2DP";
         break;
      case BTS_DEBUG_TRACE_CAT_DUN_STACK:
         result = "DUN_STACK";
         break;
      case BTS_DEBUG_TRACE_CAT_OPP:
         result = "OPP";
         break;
      case BTS_DEBUG_TRACE_CAT_HANDSFREE:
         result = "HANDSFREE";
         break;
      case BTS_DEBUG_TRACE_CAT_BIP:
         result = "BIP";
         break;
      case BTS_DEBUG_TRACE_CAT_PBAP:
         result = "PBAP";
         break;
      case BTS_DEBUG_TRACE_CAT_3GPP:
         result = "3GPP";
         break;
      case BTS_DEBUG_TRACE_CAT_SYNCML:
         result = "SYNCML";
         break;
      case BTS_DEBUG_TRACE_CAT_MAP:
         result = "MAP";
         break;
      case BTS_DEBUG_TRACE_CAT_BNEP:
         result = "BNEP";
         break;
      case BTS_DEBUG_TRACE_CAT_PAN_STACK:
         result = "PAN_STACK";
         break;
      case BTS_DEBUG_TRACE_CAT_DI_STACK:
         result = "DI_STACK";
         break;
      case BTS_DEBUG_TRACE_CAT_A2MP:
         result = "A2MP";
         break;
      case BTS_DEBUG_TRACE_CAT_LAYER_SPP_TRANS:
         result = "LAYER_SPP_TRANS";
         break;
      case BTS_DEBUG_TRACE_CAT_BTCOMMON:
         result = "BTCOMMON";
         break;
      case BTS_DEBUG_TRACE_CAT_SAP_STACK:
         result = "SAP_STACK";
         break;
      case BTS_DEBUG_TRACE_CAT_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getDunFlowControl2String(BTSDunFlowControl value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_DUN_FLOW_CONTROL_GO:
         result = "GO";
         break;
      case BTS_DUN_FLOW_CONTROL_STOP:
         result = "STOP";
         break;
      case BTS_DUN_FLOW_CONTROL_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getSppFlowControl2String(BTSSppFlowControl value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_SPP_FLOW_CONTROL_GO:
         result = "GO";
         break;
      case BTS_SPP_FLOW_CONTROL_STOP:
         result = "STOP";
         break;
      case BTS_SPP_FLOW_CONTROL_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getTransferStatus2String(BTSTransferStatus value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_TRANSFER_STATUS_QUEUED:
         result = "QUEUED";
         break;
      case BTS_TRANSFER_STATUS_ACTIVE:
         result = "ACTIVE";
         break;
      case BTS_TRANSFER_STATUS_COMPLETE:
         result = "COMPLETE";
         break;
      case BTS_TRANSFER_STATUS_ERROR:
         result = "ERROR";
         break;
      case BTS_TRANSFER_STATUS_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getGenDbusServiceInterface2String(BTSGenDbusServiceInterface value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_GEN_DBUS_SERVICE_OBJECT_MANAGER_SYSTEM:
         result = "OBJECT_MANAGER_SYSTEM";
         break;
      case BTS_GEN_DBUS_SERVICE_OBJECT_MANAGER_SESSION:
         result = "OBJECT_MANAGER_SESSION";
         break;
      case BTS_GEN_DBUS_SERVICE_INTROSPECTABLE:
         result = "INTROSPECTABLE";
         break;
      case BTS_GEN_DBUS_SERVICE_PROPERTIES_GET_ALL:
         result = "PROPERTIES_GET_ALL";
         break;
      case BTS_GEN_DBUS_SERVICE_GEN_INITIALIZATION:
         result = "GEN_INITIALIZATION";
         break;
      case BTS_GEN_DBUS_SERVICE_HLI_INITIALIZATION:
         result = "HLI_INITIALIZATION";
         break;
      case BTS_GEN_DBUS_SERVICE_ADAPTER:
         result = "ADAPTER";
         break;
      case BTS_GEN_DBUS_SERVICE_AGENT:
         result = "AGENT";
         break;
      case BTS_GEN_DBUS_SERVICE_AGENT_MANAGER:
         result = "AGENT_MANAGER";
         break;
      case BTS_GEN_DBUS_SERVICE_DEVICE:
         result = "DEVICE";
         break;
      case BTS_GEN_DBUS_SERVICE_DM:
         result = "DM";
         break;
      case BTS_GEN_DBUS_SERVICE_SERVICE:
         result = "SERVICE";
         break;
      case BTS_GEN_DBUS_SERVICE_TRACE:
         result = "TRACE";
         break;
      case BTS_GEN_DBUS_SERVICE_GENIVI_TRACE:
         result = "GENIVI_TRACE";
         break;
      case BTS_GEN_DBUS_SERVICE_DID:
         result = "DID";
         break;
      case BTS_GEN_DBUS_SERVICE_SPP:
         result = "SPP";
         break;
      case BTS_GEN_DBUS_SERVICE_OBEX_CLIENT:
         result = "OBEX_CLIENT";
         break;
      case BTS_GEN_DBUS_SERVICE_SERIAL:
         result = "SERIAL";
         break;
      case BTS_GEN_DBUS_SERVICE_CONNMAN_MANAGER:
         result = "CONNMAN_MANAGER";
         break;
      case BTS_GEN_DBUS_SERVICE_CONNMAN_TECHNOLOGY:
         result = "CONNMAN_TECHNOLOGY";
         break;
      case BTS_GEN_DBUS_SERVICE_CONNMAN_SERVICE:
         result = "CONNMAN_SERVICE";
         break;
      case BTS_GEN_DBUS_SERVICE_HFP_HANDSFREE:
         result = "HFP_HANDSFREE";
         break;
      case BTS_GEN_DBUS_SERVICE_HFP_MANAGER:
         result = "HFP_MANAGER";
         break;
      case BTS_GEN_DBUS_SERVICE_HFP_MODEM:
         result = "HFP_MODEM";
         break;
      case BTS_GEN_DBUS_SERVICE_BLE_OBJECT_MANAGER_SYSTEM:
         result = "BLE_OBJECT_MANAGER_SYSTEM";
         break;
      case BTS_GEN_DBUS_SERVICE_BLE_PROPERTIES_GET_ALL:
         result = "BLE_PROPERTIES_GET_ALL";
         break;
      case BTS_GEN_DBUS_SERVICE_BLE_GEN_INITIALIZATION:
         result = "BLE_GEN_INITIALIZATION";
         break;
      case BTS_GEN_DBUS_SERVICE_BLE_HLI_INITIALIZATION:
         result = "BLE_HLI_INITIALIZATION";
         break;
      case BTS_GEN_DBUS_SERVICE_BLE_ADAPTER:
         result = "BLE_ADAPTER";
         break;
      case BTS_GEN_DBUS_SERVICE_BLE_DEVICE:
         result = "BLE_DEVICE";
         break;
      case BTS_GEN_DBUS_SERVICE_BLE_SEAMLESS_PAIRING:
         result = "BLE_SEAMLESS_PAIRING";
         break;
      case BTS_GEN_DBUS_SERVICE_DISABLED_BT_STACK_COMM:
         result = "DISABLED_BT_STACK_COMM";
         break;
      case BTS_GEN_DBUS_SERVICE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getEvoConfigIdEnum2String(BTSEvoConfigIdEnum value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_EVO_CONFIG_ID_inquiry_item:
         result = "inquiry_item";
         break;
      case BTS_EVO_CONFIG_ID_page_timeout:
         result = "page_timeout";
         break;
      case BTS_EVO_CONFIG_ID_page_timeout_2nd:
         result = "page_timeout_2nd";
         break;
      case BTS_EVO_CONFIG_ID_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getServiceFunctionBit2String(BTSServiceFunctionBit value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_SRV_FUNC_SPP:
         result = "SPP";
         break;
      case BTS_SRV_FUNC_HFP:
         result = "HFP";
         break;
      case BTS_SRV_FUNC_AVP:
         result = "AVP";
         break;
      case BTS_SRV_FUNC_A2DP:
         result = "A2DP";
         break;
      case BTS_SRV_FUNC_AVRCP:
         result = "AVRCP";
         break;
      case BTS_SRV_FUNC_PIM:
         result = "PIM";
         break;
      case BTS_SRV_FUNC_PIM_HFP:
         result = "PIM_HFP";
         break;
      case BTS_SRV_FUNC_PIM_SPP:
         result = "PIM_SPP";
         break;
      case BTS_SRV_FUNC_PIM_PBAP:
         result = "PIM_PBAP";
         break;
      case BTS_SRV_FUNC_PIM_SYNCML:
         result = "PIM_SYNCML";
         break;
      case BTS_SRV_FUNC_MSG:
         result = "MSG";
         break;
      case BTS_SRV_FUNC_MSG_HFP:
         result = "MSG_HFP";
         break;
      case BTS_SRV_FUNC_MSG_MAP:
         result = "MSG_MAP";
         break;
      case BTS_SRV_FUNC_MSG_SPP:
         result = "MSG_SPP";
         break;
      case BTS_SRV_FUNC_DUN:
         result = "DUN";
         break;
      case BTS_SRV_FUNC_OPPS:
         result = "OPPS";
         break;
      case BTS_SRV_FUNC_OPPC:
         result = "OPPC";
         break;
      case BTS_SRV_FUNC_BIPR:
         result = "BIPR";
         break;
      case BTS_SRV_FUNC_BIPI:
         result = "BIPI";
         break;
      case BTS_SRV_FUNC_PANU:
         result = "PANU";
         break;
      case BTS_SRV_FUNC_DID:
         result = "DID";
         break;
      case BTS_SRV_FUNC_SAP:
         result = "SAP";
         break;
      case BTS_SRV_FUNC_CTN:
         result = "CTN";
         break;
      case BTS_SRV_FUNC_CTN1:
         result = "CTN1";
         break;
      case BTS_SRV_FUNC_CTN2:
         result = "CTN2";
         break;
      case BTS_SRV_FUNC_SYNCML:
         result = "SYNCML";
         break;
      case BTS_SRV_FUNC_AVP_COVERART:
         result = "AVP_COVERART";
         break;
      case BTS_SRV_FUNC_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getTestMode2String(BTSTestMode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_TEST_MODE_REMOTE_LOOPBACK:
         result = "REMOTE_LOOPBACK";
         break;
      case BTS_TEST_MODE_READ_LINK_QUALITY:
         result = "READ_LINK_QUALITY";
         break;
      case BTS_TEST_MODE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getBLEDeviceAddressType2String(BTSBLEDeviceAddressType value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_BLE_DEV_ADDRESS_TYPE_PUBLIC:
         result = "PUBLIC";
         break;
      case BTS_BLE_DEV_ADDRESS_TYPE_RANDOM:
         result = "RANDOM";
         break;
      case BTS_BLE_DEV_ADDRESS_TYPE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getBLEDiscoverableMode2String(BTSBLEDiscoverableMode value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_BLE_DISCOVERABLE_MODE_GENERAL:
         result = "GENERAL";
         break;
      case BTS_BLE_DISCOVERABLE_MODE_LIMITED:
         result = "LIMITED";
         break;
      case BTS_BLE_DISCOVERABLE_MODE_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

const char* getBLEStatus2String(BTSBLEStatus value)
{
   const char* result = "<Unknown>";

   switch(value)
   {
      case BTS_BLE_STATUS_SUCCESS:
         result = "SUCCESS";
         break;
      case BTS_BLE_STATUS_TIMEOUT:
         result = "TIMEOUT";
         break;
      case BTS_BLE_STATUS_NO_RESPONSE:
         result = "NO_RESPONSE";
         break;
      case BTS_BLE_STATUS_UNKNOWN:
         result = "UNKNOWN";
         break;
      case BTS_BLE_STATUS_LAST:
         result = "LAST";
         break;
      default:
         break;
   }

   return result;
}

} //genivi
} //btstackif
