/**
 * @file EvolutionGeniviStackTypes.cpp
 *
 * @par SW-Component
 * Types
 *
 * @brief Basic types for Evolution Genivi stack.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Definitions of all internal types for Evolution Genivi stack.
 */

#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

BTSEvolutionVersion::BTSEvolutionVersion()
{
   appCode = 0;
   geniviVersion = 0;
   evolutionVersion = 0;
}

BTSEvolutionVersion::BTSEvolutionVersion(IN const BTSEvolutionVersion& ref)
{
   appCode = ref.appCode;
   geniviVersion = ref.geniviVersion;
   evolutionVersion = ref.evolutionVersion;
}

BTSEvolutionVersion& BTSEvolutionVersion::operator=(IN const BTSEvolutionVersion& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   appCode = ref.appCode;
   geniviVersion = ref.geniviVersion;
   evolutionVersion = ref.evolutionVersion;

   return *this;
}

bool BTSEvolutionVersion::operator==(IN const BTSEvolutionVersion& ref) const
{
   bool result = true;

   result = (true == result) && (appCode == ref.appCode);
   result = (true == result) && (geniviVersion == ref.geniviVersion);
   result = (true == result) && (evolutionVersion == ref.evolutionVersion);

   return result;
}

bool BTSEvolutionVersion::operator!=(IN const BTSEvolutionVersion& ref) const
{
   return !(operator==(ref));
}

BTSEvolutionVersion::~BTSEvolutionVersion()
{
}

//------------------------------------------------------------------------------

// +++add: class implementation here if needed

} //genivi
} //btstackif
