/**
 * @file EvolutionGeniviUtils.h
 *
 * @par SW-Component
 * Utilities
 *
 * @brief Utilities for Evolution Genivi stack.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Utilities class.
 */

#ifndef _EVOLUTION_GENIVI_UTILS_H_
#define _EVOLUTION_GENIVI_UTILS_H_

#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

void convertBdAddress2InternalValue(OUT ::std::string& stringOutput, IN const ::std::string& stringInput);
void convertBdAddress2ExternalValue(OUT ::std::string& stringOutput, IN const ::std::string& stringInput);
BTSStatusCode convertStatusCode2InternalValue(IN const unsigned char code);
BTSStatusCode convertPairingStatusCode2InternalValue(IN const unsigned char code);
void convertAgentCapability2String(OUT ::std::string& stringOutput, IN const BTSAgentCapability capability); // TODO: check for moving to ccdbusif but then enum must also be moved
BTSServiceState convertServiceState2InternalValue(IN const ::ccdbusif::evolution::ServiceState value);
BTSProtocolId convertUuid2Protocol(IN const ::ccdbusif::evolution::UUID value);
BTSSupportedServicesBit convertUuid2SupportedService(::std::string& convertedUuid, const ::std::string& receivedUuid);
void convertUuid2InternalValue(OUT ::std::string& stringOutput, IN const ::std::string& stringInput);
void convertUuid2ExternalValue(OUT ::std::string& stringOutput, IN const ::std::string& stringInput);
BTSBtApplDisconnectReason convertBtApplDisconnectReason2InternalValue(IN const unsigned char reason);
void convertStringBinary2String(OUT ::std::string& stringOutput, IN const ::std::vector< unsigned char >& binaryInput);
BTSIpcCommonErrorCode convertErrorCode2InternalValue(IN const ::ccdbusif::evolution::ErrorCode error);
BTSIpcCommonErrorCode convertErrorCode2InternalValue(IN const ::std::string& errorName, IN const ::std::string& errorMessage);
BTSRequestResult convertPairingStatus2Result(IN const BTSStatusCode code);
BTSRequestResult convertPairingCommonErrorCode2Result(IN const BTSIpcCommonErrorCode errorCode);
BTSRequestResult convertStatus2Result(IN const BTSStatusCode code);
BTSProtocolId convertServiceFunction2Protocol(IN const BTSServiceFunction& serviceFunction);
BTSInternalDisconnectReason convertDisconnectReason2Internal(IN const BTSBtApplDisconnectReason reason);

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_UTILS_H_
