/**
 * @file EvolutionGeniviStackOpcodes.h
 *
 * @par SW-Component
 * Types
 *
 * @brief Internal opcodes.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Definitions of internal opcodes.
 */

#ifndef _EVOLUTION_GENIVI_STACK_OPCODES_H_
#define _EVOLUTION_GENIVI_STACK_OPCODES_H_

#include "BtStackIfTypes.h"

namespace btstackif {
namespace genivi {

/**
 * Type definition for opcodes of messages from BtStackIf to IPC.
 */
enum BTSGenBts2IpcOpcode
{
   Bts2IpcOC_None = 0, /**< none */

   // connection management block
   Bts2IpcOC_ConnectionBlockStart = (BTS_FB_CONNECTION << 12),
   // -------------------------------------------------------------------------
   Bts2IpcOC_GetManagedObjectsConnection,
   Bts2IpcOC_GetAllPropertiesConnection,
   Bts2IpcOC_GetIntrospectionConnection,
   Bts2IpcOC_ReleaseRes,
   Bts2IpcOC_RequestPinCodeRes,
   Bts2IpcOC_DisplayPinCodeRes,
   Bts2IpcOC_RequestPasskeyRes,
   Bts2IpcOC_RequestConfirmationRes,
   Bts2IpcOC_CancelRes,
   Bts2IpcOC_CancelRequestRes,
   Bts2IpcOC_AuthorizeServiceRes,
   Bts2IpcOC_RequestAuthorizationRes,
   Bts2IpcOC_RequestLinkkeyRes,
   Bts2IpcOC_DisplayPasskeyRes,
   Bts2IpcOC_StartDiscovery,
   Bts2IpcOC_StopDiscovery,
   Bts2IpcOC_RemoveDevice,
   Bts2IpcOC_CreateDevice,
   Bts2IpcOC_SendHCICmd,
   Bts2IpcOC_GetAdapterAddress,
   Bts2IpcOC_GetAdapterClass,
   Bts2IpcOC_GetAdapterAlias,
   Bts2IpcOC_SetAdapterAlias,
   Bts2IpcOC_GetAdapterPowered,
   Bts2IpcOC_SetAdapterPowered,
   Bts2IpcOC_GetAdapterDiscoverable,
   Bts2IpcOC_SetAdapterDiscoverable,
   Bts2IpcOC_GetAdapterDiscoverabletimeout,
   Bts2IpcOC_SetAdapterDiscoverabletimeout,
   Bts2IpcOC_GetAdapterPairable,
   Bts2IpcOC_SetAdapterPairable,
   Bts2IpcOC_GetAdapterPairabletimeout,
   Bts2IpcOC_SetAdapterPairabletimeout,
   Bts2IpcOC_GetAdapterDiscovering,
   Bts2IpcOC_GetAdapterUuids,
   Bts2IpcOC_SetAdapterUuids,
   Bts2IpcOC_GetAdapterWbsMode,
   Bts2IpcOC_SetAdapterWbsMode,
   Bts2IpcOC_GetAdapterConnectable,
   Bts2IpcOC_SetAdapterConnectable,
   Bts2IpcOC_GetAdapterHcimode,
   Bts2IpcOC_SetAdapterHcimode,
   Bts2IpcOC_GetAdapterVersion,
   Bts2IpcOC_GetAdapterTraceLevel,
   Bts2IpcOC_SetAdapterTraceLevel,
   Bts2IpcOC_GetAdapterTraceCategory,
   Bts2IpcOC_SetAdapterTraceCategory,
   Bts2IpcOC_GetAdapterAvailableSppServers,
   Bts2IpcOC_SetAdapterAvailableSppServers,
   Bts2IpcOC_RegisterAgent,
   Bts2IpcOC_UnregisterAgent,
   Bts2IpcOC_RequestDefaultAgent,
   Bts2IpcOC_DeviceConnect,
   Bts2IpcOC_DeviceDisconnect,
   Bts2IpcOC_Pair,
   Bts2IpcOC_CancelPairing,
   Bts2IpcOC_DiscoverServices,
   Bts2IpcOC_CancelDiscovery,
   Bts2IpcOC_GetDeviceAddress,
   Bts2IpcOC_GetDeviceClass,
   Bts2IpcOC_GetDeviceIcon,
   Bts2IpcOC_GetDeviceUuids,
   Bts2IpcOC_GetDevicePaired,
   Bts2IpcOC_GetDeviceConnected,
   Bts2IpcOC_GetDeviceTrusted,
   Bts2IpcOC_SetDeviceTrusted,
   Bts2IpcOC_GetDeviceBlocked,
   Bts2IpcOC_SetDeviceBlocked,
   Bts2IpcOC_GetDeviceAlias,
   Bts2IpcOC_SetDeviceAlias,
   Bts2IpcOC_GetDeviceAdapter,
   Bts2IpcOC_GetDeviceModalias,
   Bts2IpcOC_GetDeviceRssi,
   Bts2IpcOC_GetDeviceVendorId,
   Bts2IpcOC_GetDeviceVendorIdSource,
   Bts2IpcOC_GetDeviceProductId,
   Bts2IpcOC_GetDeviceMapInfo,
   Bts2IpcOC_GetDeviceConnectedService,
   Bts2IpcOC_GetDeviceVersion,
   Bts2IpcOC_GetDevicePbapInfo,
   Bts2IpcOC_GetDeviceMode,
   Bts2IpcOC_GetDeviceRole,
   Bts2IpcOC_GetDeviceEnableAvpPause,
   Bts2IpcOC_SetDeviceEnableAvpPause,
   Bts2IpcOC_BtApplDeviceConnectReq,
   Bts2IpcOC_BtApplDeviceDisconnectReq,
   Bts2IpcOC_BtApplCancelConnectReq,
   Bts2IpcOC_BtApplGetHwVersionReq,
   Bts2IpcOC_BtApplSetConfigurationReq,
   Bts2IpcOC_BtApplReadConfigurationReq,
   Bts2IpcOC_BtApplTestModeReq,
   Bts2IpcOC_BtApplTestModeLinkQualityReq,
   Bts2IpcOC_Connect,
   Bts2IpcOC_Disconnect,
   Bts2IpcOC_GetServiceRemoteUuid,
   Bts2IpcOC_GetServiceState,
   Bts2IpcOC_GetServiceDevice,
   Bts2IpcOC_GetServiceVersion,
   Bts2IpcOC_DebugTraceConfig,
   Bts2IpcOC_ProtocolTraceConfig,
   Bts2IpcOC_BtApplDidSetReq,
   Bts2IpcOC_GetDunDeviceFilePath,
   Bts2IpcOC_BtApplSppSetUuidReq,
   Bts2IpcOC_CreateSession,
   Bts2IpcOC_RemoveSession,
   Bts2IpcOC_CancelSession,
   Bts2IpcOC_GetConnManManagerProperties,
   Bts2IpcOC_GetConnManTechnologies,
   Bts2IpcOC_GetConnManServices,
   Bts2IpcOC_GetConnManServiceProperties,
   Bts2IpcOC_ConnManServiceConnect,
   Bts2IpcOC_ConnManServiceDisconnect,
   Bts2IpcOC_CreateLeDevice,
   Bts2IpcOC_RemoveLeDevice,
   Bts2IpcOC_GetLeAdapterAddressType,
   Bts2IpcOC_GetLeAdapterAddress,
   Bts2IpcOC_GetLeAdapterAlias,
   Bts2IpcOC_SetLeAdapterAlias,
   Bts2IpcOC_GetLeAdapterAdvertisingTimeout,
   Bts2IpcOC_SetLeAdapterAdvertisingTimeout,
   Bts2IpcOC_GetLeAdapterDiscoverableMode,
   Bts2IpcOC_SetLeAdapterDiscoverableMode,
   Bts2IpcOC_GetLeAdapterAdvertisingData,
   Bts2IpcOC_SetLeAdapterAdvertisingData,
   Bts2IpcOC_GetLeAdapterAdvertiseEnable,
   Bts2IpcOC_SetLeAdapterAdvertiseEnable,
   Bts2IpcOC_LeDeviceDisconnect,
   Bts2IpcOC_GetLeDeviceAddressType,
   Bts2IpcOC_GetLeDeviceAddress,
   Bts2IpcOC_GetLeDeviceConnected,
   Bts2IpcOC_SendSeamlessPairingErrorCode,
   Bts2IpcOC_SeamlessPairingAllowAccess,
   Bts2IpcOC_GetSeamlessPairingPairingData,
   Bts2IpcOC_SetSeamlessPairingPairingData,
   // -------------------------------------------------------------------------
   Bts2IpcOC_ConnectionBlockEnd,

   // phonecall block
   Bts2IpcOC_TelephonyBlockStart = (BTS_FB_TELEPHONY << 12),
   // -------------------------------------------------------------------------
   Bts2IpcOC_GetManagedObjectsTelephony,
   Bts2IpcOC_GetAllPropertiesTelephony,
   Bts2IpcOC_GetIntrospectionTelephony,
   Bts2IpcOC_GetHandsfreeProperties,
   Bts2IpcOC_GetModems,
   Bts2IpcOC_GetModemProperties,
   // -------------------------------------------------------------------------
   Bts2IpcOC_TelephonyBlockEnd,

   // phonebook block
   Bts2IpcOC_PhonebookBlockStart = (BTS_FB_PHONEBOOK << 12),
   // -------------------------------------------------------------------------
   Bts2IpcOC_GetManagedObjectsPhonebook,
   Bts2IpcOC_GetAllPropertiesPhonebook,
   Bts2IpcOC_GetIntrospectionPhonebook,
   Bts2IpcOC_GetPimSessionSource,
   Bts2IpcOC_GetPimSessionDestination,
   Bts2IpcOC_GetPimSessionChannel,
   Bts2IpcOC_GetPimSessionTarget,
   Bts2IpcOC_PimTransferCancel,
   Bts2IpcOC_GetPimTransferStatus,
   Bts2IpcOC_GetPimTransferSession,
   Bts2IpcOC_GetPimTransferName,
   Bts2IpcOC_GetPimTransferType,
   Bts2IpcOC_GetPimTransferTime,
   Bts2IpcOC_GetPimTransferSize,
   Bts2IpcOC_GetPimTransferTransferred,
   Bts2IpcOC_GetPimTransferFilename,
   // -------------------------------------------------------------------------
   Bts2IpcOC_PhonebookBlockEnd,

   // messaging block
   Bts2IpcOC_MessagingBlockStart = (BTS_FB_MESSAGING << 12),
   // -------------------------------------------------------------------------
   Bts2IpcOC_GetManagedObjectsMessaging,
   Bts2IpcOC_GetAllPropertiesMessaging,
   Bts2IpcOC_GetIntrospectionMessaging,
   Bts2IpcOC_GetMsgSessionSource,
   Bts2IpcOC_GetMsgSessionDestination,
   Bts2IpcOC_GetMsgSessionChannel,
   Bts2IpcOC_GetMsgSessionTarget,
   Bts2IpcOC_MsgTransferCancel,
   Bts2IpcOC_GetMsgTransferStatus,
   Bts2IpcOC_GetMsgTransferSession,
   Bts2IpcOC_GetMsgTransferName,
   Bts2IpcOC_GetMsgTransferType,
   Bts2IpcOC_GetMsgTransferTime,
   Bts2IpcOC_GetMsgTransferSize,
   Bts2IpcOC_GetMsgTransferTransferred,
   Bts2IpcOC_GetMsgTransferFilename,
   // -------------------------------------------------------------------------
   Bts2IpcOC_MessagingBlockEnd,

   // media player block
   Bts2IpcOC_MediaPlayerBlockStart = (BTS_FB_MEDIAPLAYER << 12),
   // -------------------------------------------------------------------------
   Bts2IpcOC_GetManagedObjectsMediaPlayer,
   Bts2IpcOC_GetAllPropertiesMediaPlayer,
   Bts2IpcOC_GetIntrospectionMediaPlayer,
   // -------------------------------------------------------------------------
   Bts2IpcOC_MediaPlayerBlockEnd,

   // -------------------------------------------------------------------------
   Bts2IpcOC_Last /**< end marker, must be the last one */
};

/**
 * Type definition for opcodes of messages from IPC to BtStackIf.
 */
enum BTSGenIpc2BtsOpcode
{
   Ipc2BtsOC_None = 0, /**< none */

   // connection management block
   Ipc2BtsOC_ConnectionBlockStart = (1 << 11) | (BTS_FB_CONNECTION << 12),
   // -------------------------------------------------------------------------
   Ipc2BtsOC_ServiceAvailabilityConnection,
   Ipc2BtsOC_GetAllPropertiesConnection,
   Ipc2BtsOC_AddDeviceObjectPathMapping,
   Ipc2BtsOC_DelDeviceObjectPathMapping,
   Ipc2BtsOC_AddProtocolObjectPathMapping,
   Ipc2BtsOC_DelProtocolObjectPathMapping,
   Ipc2BtsOC_AddSerialObjectPathMapping,
   Ipc2BtsOC_DelSerialObjectPathMapping,
   Ipc2BtsOC_Release,
   Ipc2BtsOC_RequestPinCode,
   Ipc2BtsOC_DisplayPinCode,
   Ipc2BtsOC_RequestPasskey,
   Ipc2BtsOC_RequestConfirmation,
   Ipc2BtsOC_Cancel,
   Ipc2BtsOC_CancelRequest,
   Ipc2BtsOC_AuthorizeService,
   Ipc2BtsOC_RequestAuthorization,
   Ipc2BtsOC_RequestLinkkey,
   Ipc2BtsOC_DisplayPasskey,
   Ipc2BtsOC_StartDiscoveryResult,
   Ipc2BtsOC_StopDiscoveryResult,
   Ipc2BtsOC_RemoveDeviceResult,
   Ipc2BtsOC_CreateDeviceResult,
   Ipc2BtsOC_SendHCICmdResult,
   Ipc2BtsOC_AdapterInitialization,
   Ipc2BtsOC_DeviceCreated,
   Ipc2BtsOC_DeviceRemoved,
   Ipc2BtsOC_BtStackLog,
   Ipc2BtsOC_HCIEvent,
   Ipc2BtsOC_DeviceFound,
   Ipc2BtsOC_AdapterAddressUpdate,
   Ipc2BtsOC_AdapterClassUpdate,
   Ipc2BtsOC_AdapterAliasUpdate,
   Ipc2BtsOC_AdapterPoweredUpdate,
   Ipc2BtsOC_AdapterDiscoverableUpdate,
   Ipc2BtsOC_AdapterDiscoverabletimeoutUpdate,
   Ipc2BtsOC_AdapterPairableUpdate,
   Ipc2BtsOC_AdapterPairabletimeoutUpdate,
   Ipc2BtsOC_AdapterDiscoveringUpdate,
   Ipc2BtsOC_AdapterUuidsUpdate,
   Ipc2BtsOC_AdapterWbsModeUpdate,
   Ipc2BtsOC_AdapterConnectableUpdate,
   Ipc2BtsOC_AdapterHcimodeUpdate,
   Ipc2BtsOC_AdapterVersionUpdate,
   Ipc2BtsOC_AdapterTraceLevelUpdate,
   Ipc2BtsOC_AdapterTraceCategoryUpdate,
   Ipc2BtsOC_AdapterAvailableSppServersUpdate,
   Ipc2BtsOC_RegisterAgentResult,
   Ipc2BtsOC_UnregisterAgentResult,
   Ipc2BtsOC_RequestDefaultAgentResult,
   Ipc2BtsOC_DeviceConnectResult,
   Ipc2BtsOC_DeviceDisconnectResult,
   Ipc2BtsOC_PairResult,
   Ipc2BtsOC_CancelPairingResult,
   Ipc2BtsOC_DiscoverServicesResult,
   Ipc2BtsOC_CancelDiscoveryResult,
   Ipc2BtsOC_ReportLinkkey,
   Ipc2BtsOC_IncomingPairingComp,
   Ipc2BtsOC_SDPProcessReport,
   Ipc2BtsOC_DeviceAddressUpdate,
   Ipc2BtsOC_DeviceClassUpdate,
   Ipc2BtsOC_DeviceIconUpdate,
   Ipc2BtsOC_DeviceUuidsUpdate,
   Ipc2BtsOC_DevicePairedUpdate,
   Ipc2BtsOC_DeviceConnectedUpdate,
   Ipc2BtsOC_DeviceTrustedUpdate,
   Ipc2BtsOC_DeviceBlockedUpdate,
   Ipc2BtsOC_DeviceAliasUpdate,
   Ipc2BtsOC_DeviceAdapterUpdate,
   Ipc2BtsOC_DeviceModaliasUpdate,
   Ipc2BtsOC_DeviceRssiUpdate,
   Ipc2BtsOC_DeviceVendorIdUpdate,
   Ipc2BtsOC_DeviceVendorIdSourceUpdate,
   Ipc2BtsOC_DeviceProductIdUpdate,
   Ipc2BtsOC_DeviceMapInfoUpdate,
   Ipc2BtsOC_DeviceConnectedServiceUpdate,
   Ipc2BtsOC_DeviceVersionUpdate,
   Ipc2BtsOC_DevicePbapInfoUpdate,
   Ipc2BtsOC_DeviceModeUpdate,
   Ipc2BtsOC_DeviceRoleUpdate,
   Ipc2BtsOC_DeviceEnableAvpPauseUpdate,
   Ipc2BtsOC_BtApplDeviceConnectReqResult,
   Ipc2BtsOC_BtApplDeviceDisconnectReqResult,
   Ipc2BtsOC_BtApplCancelConnectReqResult,
   Ipc2BtsOC_BtApplGetHwVersionReqResult,
   Ipc2BtsOC_BtApplSetConfigurationReqResult,
   Ipc2BtsOC_BtApplReadConfigurationReqResult,
   Ipc2BtsOC_BtApplTestModeReqResult,
   Ipc2BtsOC_BtApplTestModeLinkQualityReqResult,
   Ipc2BtsOC_BtApplDeviceConnectCfm,
   Ipc2BtsOC_BtApplDeviceConnectInd,
   Ipc2BtsOC_BtApplDeviceDisconnectCfm,
   Ipc2BtsOC_BtApplDeviceDisconnectInd,
   Ipc2BtsOC_BtApplDeviceDisconnectCompInd,
   Ipc2BtsOC_BtApplDeviceConnectCompInd,
   Ipc2BtsOC_BtApplCancelConnectCfm,
   Ipc2BtsOC_BtApplStatusNotificationInd,
   Ipc2BtsOC_BtApplGetHwVersionCfm,
   Ipc2BtsOC_BtApplSetConfigurationCfm,
   Ipc2BtsOC_BtApplReadConfigurationCfm,
   Ipc2BtsOC_BtApplTestModeCfm,
   Ipc2BtsOC_BtApplTestModeCompInd,
   Ipc2BtsOC_BtApplTestModeLinkQualityCfm,
   Ipc2BtsOC_ConnectResult,
   Ipc2BtsOC_DisconnectResult,
   Ipc2BtsOC_ServiceRemoteUuidUpdate,
   Ipc2BtsOC_ServiceStateUpdate,
   Ipc2BtsOC_ServiceDeviceUpdate,
   Ipc2BtsOC_ServiceVersionUpdate,
   Ipc2BtsOC_DebugTraceConfigResult,
   Ipc2BtsOC_ProtocolTraceConfigResult,
   Ipc2BtsOC_ReportDebugTrace,
   Ipc2BtsOC_ReportProtocolTrace,
   Ipc2BtsOC_FatalError,
   Ipc2BtsOC_GeneralError,
   Ipc2BtsOC_ReportGeniviDebugTrace,
   Ipc2BtsOC_GeniviFatalError,
   Ipc2BtsOC_BtApplDidSetReqResult,
   Ipc2BtsOC_BtApplDidSetCfm,
   Ipc2BtsOC_DunDeviceFilePathUpdate,
   Ipc2BtsOC_BtApplSppSetUuidReqResult,
   Ipc2BtsOC_BtApplSppSetUuidCfm,
   Ipc2BtsOC_BtApplSppVirtualDeviceInd,
   Ipc2BtsOC_CreateSessionResult,
   Ipc2BtsOC_RemoveSessionResult,
   Ipc2BtsOC_CancelSessionResult,
   Ipc2BtsOC_SessionCreated,
   Ipc2BtsOC_SessionRemoved,
   Ipc2BtsOC_AddTechnologyObjectPath,
   Ipc2BtsOC_DelTechnologyObjectPath,
   Ipc2BtsOC_AddNetworkObjectPathMapping,
   Ipc2BtsOC_DelNetworkObjectPathMapping,
   Ipc2BtsOC_GetConnManManagerPropertiesResult,
   Ipc2BtsOC_GetConnManTechnologiesResult,
   Ipc2BtsOC_GetConnManServicesResult,
   Ipc2BtsOC_ConnManTechnologyAdded,
   Ipc2BtsOC_ConnManTechnologyRemoved,
   Ipc2BtsOC_ConnManServicesChanged,
   Ipc2BtsOC_ConnManServicesRemoved,
   Ipc2BtsOC_GetConnManServicePropertiesResult,
   Ipc2BtsOC_ConnManServiceConnectResult,
   Ipc2BtsOC_ConnManServiceDisconnectResult,
   Ipc2BtsOC_ConnManServiceStateUpdate,
   Ipc2BtsOC_ConnManServiceInterfaceUpdate,
   Ipc2BtsOC_SerialDeviceFilePath,
   Ipc2BtsOC_CharacterDeviceAddedRemoved,
   Ipc2BtsOC_CreateLeDeviceResult,
   Ipc2BtsOC_RemoveLeDeviceResult,
   Ipc2BtsOC_LeAdapterInitialization,
   Ipc2BtsOC_LeDeviceCreated,
   Ipc2BtsOC_LeDeviceRemoved,
   Ipc2BtsOC_LeAdapterAddressTypeUpdate,
   Ipc2BtsOC_LeAdapterAddressUpdate,
   Ipc2BtsOC_LeAdapterAliasUpdate,
   Ipc2BtsOC_LeAdapterAdvertisingTimeoutUpdate,
   Ipc2BtsOC_LeAdapterDiscoverableModeUpdate,
   Ipc2BtsOC_LeAdapterAdvertisingDataUpdate,
   Ipc2BtsOC_LeAdapterAdvertiseEnableUpdate,
   Ipc2BtsOC_AddLeDeviceObjectPathMapping,
   Ipc2BtsOC_DelLeDeviceObjectPathMapping,
   Ipc2BtsOC_LeDeviceDisconnectResult,
   Ipc2BtsOC_LeDisconnectionComp,
   Ipc2BtsOC_LeDeviceAddressTypeUpdate,
   Ipc2BtsOC_LeDeviceAddressUpdate,
   Ipc2BtsOC_LeDeviceConnectedUpdate,
   Ipc2BtsOC_SendSeamlessPairingErrorCodeResult,
   Ipc2BtsOC_SeamlessPairingAllowAccessResult,
   Ipc2BtsOC_SeamlessPairingErrorCodeReceived,
   Ipc2BtsOC_SeamlessPairingAccessRequest,
   Ipc2BtsOC_SeamlessPairingPairingDataUpdate,
   // -------------------------------------------------------------------------
   Ipc2BtsOC_ConnectionBlockEnd,

   // phonecall block
   Ipc2BtsOC_TelephonyBlockStart = (1 << 11) | (BTS_FB_TELEPHONY << 12),
   // -------------------------------------------------------------------------
   Ipc2BtsOC_ServiceAvailabilityTelephony,
   Ipc2BtsOC_AddHfpInterfaceObjectPathMapping,
   Ipc2BtsOC_DelHfpInterfaceObjectPathMapping,
   Ipc2BtsOC_GetHandsfreeProperties,
   Ipc2BtsOC_GetHandsfreePropertiesExt,
   Ipc2BtsOC_HandsfreeFeaturesUpdate,
   Ipc2BtsOC_HandsfreeInbandRingingUpdate,
   Ipc2BtsOC_GetModems,
   Ipc2BtsOC_GetModemsExt,
   Ipc2BtsOC_ModemAdded,
   Ipc2BtsOC_ModemAddedExt,
   Ipc2BtsOC_ModemRemoved,
   Ipc2BtsOC_GetModemProperties,
   Ipc2BtsOC_GetModemPropertiesExt,
   Ipc2BtsOC_ModemInterfacesUpdate,
   // -------------------------------------------------------------------------
   Ipc2BtsOC_TelephonyBlockEnd,

   // phonebook block
   Ipc2BtsOC_PhonebookBlockStart = (1 << 11) | (BTS_FB_PHONEBOOK << 12),
   // -------------------------------------------------------------------------
   Ipc2BtsOC_ServiceAvailabilityPhonebook,
   Ipc2BtsOC_PimSessionSourceUpdate,
   Ipc2BtsOC_PimSessionDestinationUpdate,
   Ipc2BtsOC_PimSessionChannelUpdate,
   Ipc2BtsOC_PimSessionTargetUpdate,
   Ipc2BtsOC_PimTransferCancelResult,
   Ipc2BtsOC_PimTransferStatusUpdate,
   Ipc2BtsOC_PimTransferSessionUpdate,
   Ipc2BtsOC_PimTransferNameUpdate,
   Ipc2BtsOC_PimTransferTypeUpdate,
   Ipc2BtsOC_PimTransferTimeUpdate,
   Ipc2BtsOC_PimTransferSizeUpdate,
   Ipc2BtsOC_PimTransferTransferredUpdate,
   Ipc2BtsOC_PimTransferFilenameUpdate,
   // -------------------------------------------------------------------------
   Ipc2BtsOC_PhonebookBlockEnd,

   // messaging block
   Ipc2BtsOC_MessagingBlockStart = (1 << 11) | (BTS_FB_MESSAGING << 12),
   // -------------------------------------------------------------------------
   Ipc2BtsOC_ServiceAvailabilityMessaging,
   Ipc2BtsOC_MsgSessionSourceUpdate,
   Ipc2BtsOC_MsgSessionDestinationUpdate,
   Ipc2BtsOC_MsgSessionChannelUpdate,
   Ipc2BtsOC_MsgSessionTargetUpdate,
   Ipc2BtsOC_MsgTransferCancelResult,
   Ipc2BtsOC_MsgTransferStatusUpdate,
   Ipc2BtsOC_MsgTransferSessionUpdate,
   Ipc2BtsOC_MsgTransferNameUpdate,
   Ipc2BtsOC_MsgTransferTypeUpdate,
   Ipc2BtsOC_MsgTransferTimeUpdate,
   Ipc2BtsOC_MsgTransferSizeUpdate,
   Ipc2BtsOC_MsgTransferTransferredUpdate,
   Ipc2BtsOC_MsgTransferFilenameUpdate,
   // -------------------------------------------------------------------------
   Ipc2BtsOC_MessagingBlockEnd,

   // media player block
   Ipc2BtsOC_MediaPlayerBlockStart = (1 << 11) | (BTS_FB_MEDIAPLAYER << 12),
   // -------------------------------------------------------------------------
   Ipc2BtsOC_ServiceAvailabilityMediaPlayer,
   // -------------------------------------------------------------------------
   Ipc2BtsOC_MediaPlayerBlockEnd,

   // -------------------------------------------------------------------------
   Ipc2BtsOC_Last /**< end marker, must be the last one */
};

} //genivi
} //btstackif

#endif //_EVOLUTION_GENIVI_STACK_OPCODES_H_
