/**
 * @file Bts2Ipc_Messaging_GEN.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to IPC messages for function block BTS_FB_MESSAGING.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_MESSAGING.
 */

#include "Bts2Ipc_Messaging_GEN.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

Bts2Ipc_GetManagedObjectsMessaging::Bts2Ipc_GetManagedObjectsMessaging()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetManagedObjectsMessaging))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetManagedObjectsMessaging::Bts2Ipc_GetManagedObjectsMessaging(IN const Bts2Ipc_GetManagedObjectsMessaging& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Bts2Ipc_GetManagedObjectsMessaging& Bts2Ipc_GetManagedObjectsMessaging::operator=(IN const Bts2Ipc_GetManagedObjectsMessaging& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetManagedObjectsMessaging::~Bts2Ipc_GetManagedObjectsMessaging()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetManagedObjectsMessaging::clone(void) const
{
   return new Bts2Ipc_GetManagedObjectsMessaging(*this);
}

Bts2Ipc_GetAllPropertiesMessaging::Bts2Ipc_GetAllPropertiesMessaging()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetAllPropertiesMessaging))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   // _interface: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetAllPropertiesMessaging::Bts2Ipc_GetAllPropertiesMessaging(IN const Bts2Ipc_GetAllPropertiesMessaging& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
   _interface = ref._interface;
}

Bts2Ipc_GetAllPropertiesMessaging& Bts2Ipc_GetAllPropertiesMessaging::operator=(IN const Bts2Ipc_GetAllPropertiesMessaging& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
   _interface = ref._interface;

   return *this;
}

Bts2Ipc_GetAllPropertiesMessaging::~Bts2Ipc_GetAllPropertiesMessaging()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAllPropertiesMessaging::clone(void) const
{
   return new Bts2Ipc_GetAllPropertiesMessaging(*this);
}

Bts2Ipc_GetIntrospectionMessaging::Bts2Ipc_GetIntrospectionMessaging()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetIntrospectionMessaging))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetIntrospectionMessaging::Bts2Ipc_GetIntrospectionMessaging(IN const Bts2Ipc_GetIntrospectionMessaging& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Bts2Ipc_GetIntrospectionMessaging& Bts2Ipc_GetIntrospectionMessaging::operator=(IN const Bts2Ipc_GetIntrospectionMessaging& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetIntrospectionMessaging::~Bts2Ipc_GetIntrospectionMessaging()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetIntrospectionMessaging::clone(void) const
{
   return new Bts2Ipc_GetIntrospectionMessaging(*this);
}

Bts2Ipc_GetMsgSessionSource::Bts2Ipc_GetMsgSessionSource()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetMsgSessionSource))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetMsgSessionSource::Bts2Ipc_GetMsgSessionSource(IN const Bts2Ipc_GetMsgSessionSource& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetMsgSessionSource& Bts2Ipc_GetMsgSessionSource::operator=(IN const Bts2Ipc_GetMsgSessionSource& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetMsgSessionSource::~Bts2Ipc_GetMsgSessionSource()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetMsgSessionSource::clone(void) const
{
   return new Bts2Ipc_GetMsgSessionSource(*this);
}

Bts2Ipc_GetMsgSessionDestination::Bts2Ipc_GetMsgSessionDestination()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetMsgSessionDestination))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetMsgSessionDestination::Bts2Ipc_GetMsgSessionDestination(IN const Bts2Ipc_GetMsgSessionDestination& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetMsgSessionDestination& Bts2Ipc_GetMsgSessionDestination::operator=(IN const Bts2Ipc_GetMsgSessionDestination& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetMsgSessionDestination::~Bts2Ipc_GetMsgSessionDestination()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetMsgSessionDestination::clone(void) const
{
   return new Bts2Ipc_GetMsgSessionDestination(*this);
}

Bts2Ipc_GetMsgSessionChannel::Bts2Ipc_GetMsgSessionChannel()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetMsgSessionChannel))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetMsgSessionChannel::Bts2Ipc_GetMsgSessionChannel(IN const Bts2Ipc_GetMsgSessionChannel& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetMsgSessionChannel& Bts2Ipc_GetMsgSessionChannel::operator=(IN const Bts2Ipc_GetMsgSessionChannel& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetMsgSessionChannel::~Bts2Ipc_GetMsgSessionChannel()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetMsgSessionChannel::clone(void) const
{
   return new Bts2Ipc_GetMsgSessionChannel(*this);
}

Bts2Ipc_GetMsgSessionTarget::Bts2Ipc_GetMsgSessionTarget()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetMsgSessionTarget))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetMsgSessionTarget::Bts2Ipc_GetMsgSessionTarget(IN const Bts2Ipc_GetMsgSessionTarget& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetMsgSessionTarget& Bts2Ipc_GetMsgSessionTarget::operator=(IN const Bts2Ipc_GetMsgSessionTarget& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetMsgSessionTarget::~Bts2Ipc_GetMsgSessionTarget()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetMsgSessionTarget::clone(void) const
{
   return new Bts2Ipc_GetMsgSessionTarget(*this);
}

Bts2Ipc_MsgTransferCancel::Bts2Ipc_MsgTransferCancel()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_MsgTransferCancel))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_MsgTransferCancel::Bts2Ipc_MsgTransferCancel(IN const Bts2Ipc_MsgTransferCancel& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_MsgTransferCancel& Bts2Ipc_MsgTransferCancel::operator=(IN const Bts2Ipc_MsgTransferCancel& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_MsgTransferCancel::~Bts2Ipc_MsgTransferCancel()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_MsgTransferCancel::clone(void) const
{
   return new Bts2Ipc_MsgTransferCancel(*this);
}

Bts2Ipc_GetMsgTransferStatus::Bts2Ipc_GetMsgTransferStatus()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetMsgTransferStatus))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetMsgTransferStatus::Bts2Ipc_GetMsgTransferStatus(IN const Bts2Ipc_GetMsgTransferStatus& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetMsgTransferStatus& Bts2Ipc_GetMsgTransferStatus::operator=(IN const Bts2Ipc_GetMsgTransferStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetMsgTransferStatus::~Bts2Ipc_GetMsgTransferStatus()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetMsgTransferStatus::clone(void) const
{
   return new Bts2Ipc_GetMsgTransferStatus(*this);
}

Bts2Ipc_GetMsgTransferSession::Bts2Ipc_GetMsgTransferSession()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetMsgTransferSession))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetMsgTransferSession::Bts2Ipc_GetMsgTransferSession(IN const Bts2Ipc_GetMsgTransferSession& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetMsgTransferSession& Bts2Ipc_GetMsgTransferSession::operator=(IN const Bts2Ipc_GetMsgTransferSession& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetMsgTransferSession::~Bts2Ipc_GetMsgTransferSession()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetMsgTransferSession::clone(void) const
{
   return new Bts2Ipc_GetMsgTransferSession(*this);
}

Bts2Ipc_GetMsgTransferName::Bts2Ipc_GetMsgTransferName()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetMsgTransferName))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetMsgTransferName::Bts2Ipc_GetMsgTransferName(IN const Bts2Ipc_GetMsgTransferName& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetMsgTransferName& Bts2Ipc_GetMsgTransferName::operator=(IN const Bts2Ipc_GetMsgTransferName& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetMsgTransferName::~Bts2Ipc_GetMsgTransferName()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetMsgTransferName::clone(void) const
{
   return new Bts2Ipc_GetMsgTransferName(*this);
}

Bts2Ipc_GetMsgTransferType::Bts2Ipc_GetMsgTransferType()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetMsgTransferType))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetMsgTransferType::Bts2Ipc_GetMsgTransferType(IN const Bts2Ipc_GetMsgTransferType& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetMsgTransferType& Bts2Ipc_GetMsgTransferType::operator=(IN const Bts2Ipc_GetMsgTransferType& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetMsgTransferType::~Bts2Ipc_GetMsgTransferType()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetMsgTransferType::clone(void) const
{
   return new Bts2Ipc_GetMsgTransferType(*this);
}

Bts2Ipc_GetMsgTransferTime::Bts2Ipc_GetMsgTransferTime()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetMsgTransferTime))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetMsgTransferTime::Bts2Ipc_GetMsgTransferTime(IN const Bts2Ipc_GetMsgTransferTime& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetMsgTransferTime& Bts2Ipc_GetMsgTransferTime::operator=(IN const Bts2Ipc_GetMsgTransferTime& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetMsgTransferTime::~Bts2Ipc_GetMsgTransferTime()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetMsgTransferTime::clone(void) const
{
   return new Bts2Ipc_GetMsgTransferTime(*this);
}

Bts2Ipc_GetMsgTransferSize::Bts2Ipc_GetMsgTransferSize()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetMsgTransferSize))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetMsgTransferSize::Bts2Ipc_GetMsgTransferSize(IN const Bts2Ipc_GetMsgTransferSize& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetMsgTransferSize& Bts2Ipc_GetMsgTransferSize::operator=(IN const Bts2Ipc_GetMsgTransferSize& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetMsgTransferSize::~Bts2Ipc_GetMsgTransferSize()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetMsgTransferSize::clone(void) const
{
   return new Bts2Ipc_GetMsgTransferSize(*this);
}

Bts2Ipc_GetMsgTransferTransferred::Bts2Ipc_GetMsgTransferTransferred()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetMsgTransferTransferred))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetMsgTransferTransferred::Bts2Ipc_GetMsgTransferTransferred(IN const Bts2Ipc_GetMsgTransferTransferred& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetMsgTransferTransferred& Bts2Ipc_GetMsgTransferTransferred::operator=(IN const Bts2Ipc_GetMsgTransferTransferred& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetMsgTransferTransferred::~Bts2Ipc_GetMsgTransferTransferred()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetMsgTransferTransferred::clone(void) const
{
   return new Bts2Ipc_GetMsgTransferTransferred(*this);
}

Bts2Ipc_GetMsgTransferFilename::Bts2Ipc_GetMsgTransferFilename()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MESSAGING), (BTSCommonEnumClass)(Bts2IpcOC_GetMsgTransferFilename))
{
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MESSAGING);
}

Bts2Ipc_GetMsgTransferFilename::Bts2Ipc_GetMsgTransferFilename(IN const Bts2Ipc_GetMsgTransferFilename& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _objPath = ref._objPath;
}

Bts2Ipc_GetMsgTransferFilename& Bts2Ipc_GetMsgTransferFilename::operator=(IN const Bts2Ipc_GetMsgTransferFilename& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetMsgTransferFilename::~Bts2Ipc_GetMsgTransferFilename()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetMsgTransferFilename::clone(void) const
{
   return new Bts2Ipc_GetMsgTransferFilename(*this);
}

} //genivi
} //btstackif
