/**
 * @file Bts2Ipc_MediaPlayer_GEN.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to IPC messages for function block BTS_FB_MEDIAPLAYER.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_MEDIAPLAYER.
 */

#include "Bts2Ipc_MediaPlayer_GEN.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

Bts2Ipc_GetManagedObjectsMediaPlayer::Bts2Ipc_GetManagedObjectsMediaPlayer()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MEDIAPLAYER), (BTSCommonEnumClass)(Bts2IpcOC_GetManagedObjectsMediaPlayer))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MEDIAPLAYER);
}

Bts2Ipc_GetManagedObjectsMediaPlayer::Bts2Ipc_GetManagedObjectsMediaPlayer(IN const Bts2Ipc_GetManagedObjectsMediaPlayer& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Bts2Ipc_GetManagedObjectsMediaPlayer& Bts2Ipc_GetManagedObjectsMediaPlayer::operator=(IN const Bts2Ipc_GetManagedObjectsMediaPlayer& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetManagedObjectsMediaPlayer::~Bts2Ipc_GetManagedObjectsMediaPlayer()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetManagedObjectsMediaPlayer::clone(void) const
{
   return new Bts2Ipc_GetManagedObjectsMediaPlayer(*this);
}

Bts2Ipc_GetAllPropertiesMediaPlayer::Bts2Ipc_GetAllPropertiesMediaPlayer()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MEDIAPLAYER), (BTSCommonEnumClass)(Bts2IpcOC_GetAllPropertiesMediaPlayer))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   // _interface: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MEDIAPLAYER);
}

Bts2Ipc_GetAllPropertiesMediaPlayer::Bts2Ipc_GetAllPropertiesMediaPlayer(IN const Bts2Ipc_GetAllPropertiesMediaPlayer& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
   _interface = ref._interface;
}

Bts2Ipc_GetAllPropertiesMediaPlayer& Bts2Ipc_GetAllPropertiesMediaPlayer::operator=(IN const Bts2Ipc_GetAllPropertiesMediaPlayer& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
   _interface = ref._interface;

   return *this;
}

Bts2Ipc_GetAllPropertiesMediaPlayer::~Bts2Ipc_GetAllPropertiesMediaPlayer()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAllPropertiesMediaPlayer::clone(void) const
{
   return new Bts2Ipc_GetAllPropertiesMediaPlayer(*this);
}

Bts2Ipc_GetIntrospectionMediaPlayer::Bts2Ipc_GetIntrospectionMediaPlayer()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_MEDIAPLAYER), (BTSCommonEnumClass)(Bts2IpcOC_GetIntrospectionMediaPlayer))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_MEDIAPLAYER);
}

Bts2Ipc_GetIntrospectionMediaPlayer::Bts2Ipc_GetIntrospectionMediaPlayer(IN const Bts2Ipc_GetIntrospectionMediaPlayer& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Bts2Ipc_GetIntrospectionMediaPlayer& Bts2Ipc_GetIntrospectionMediaPlayer::operator=(IN const Bts2Ipc_GetIntrospectionMediaPlayer& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetIntrospectionMediaPlayer::~Bts2Ipc_GetIntrospectionMediaPlayer()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetIntrospectionMediaPlayer::clone(void) const
{
   return new Bts2Ipc_GetIntrospectionMediaPlayer(*this);
}

} //genivi
} //btstackif
