/**
 * @file Bts2Ipc_Connection_GEN.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to IPC messages for function block BTS_FB_CONNECTION.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_CONNECTION.
 */

#include "Bts2Ipc_Connection_GEN.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

Bts2Ipc_GetManagedObjectsConnection::Bts2Ipc_GetManagedObjectsConnection()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetManagedObjectsConnection))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetManagedObjectsConnection::Bts2Ipc_GetManagedObjectsConnection(IN const Bts2Ipc_GetManagedObjectsConnection& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Bts2Ipc_GetManagedObjectsConnection& Bts2Ipc_GetManagedObjectsConnection::operator=(IN const Bts2Ipc_GetManagedObjectsConnection& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetManagedObjectsConnection::~Bts2Ipc_GetManagedObjectsConnection()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetManagedObjectsConnection::clone(void) const
{
   return new Bts2Ipc_GetManagedObjectsConnection(*this);
}

Bts2Ipc_GetAllPropertiesConnection::Bts2Ipc_GetAllPropertiesConnection()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAllPropertiesConnection))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   _interface = ::ccdbusif::evolution::IF_UNKNOWN;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAllPropertiesConnection::Bts2Ipc_GetAllPropertiesConnection(IN const Bts2Ipc_GetAllPropertiesConnection& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
   _interface = ref._interface;
}

Bts2Ipc_GetAllPropertiesConnection& Bts2Ipc_GetAllPropertiesConnection::operator=(IN const Bts2Ipc_GetAllPropertiesConnection& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
   _interface = ref._interface;

   return *this;
}

Bts2Ipc_GetAllPropertiesConnection::~Bts2Ipc_GetAllPropertiesConnection()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAllPropertiesConnection::clone(void) const
{
   return new Bts2Ipc_GetAllPropertiesConnection(*this);
}

Bts2Ipc_GetIntrospectionConnection::Bts2Ipc_GetIntrospectionConnection()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetIntrospectionConnection))
{
   _busType = 0;
   // _busName: init is done by member constructor
   // _objPath: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetIntrospectionConnection::Bts2Ipc_GetIntrospectionConnection(IN const Bts2Ipc_GetIntrospectionConnection& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;
}

Bts2Ipc_GetIntrospectionConnection& Bts2Ipc_GetIntrospectionConnection::operator=(IN const Bts2Ipc_GetIntrospectionConnection& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _busType = ref._busType;
   _busName = ref._busName;
   _objPath = ref._objPath;

   return *this;
}

Bts2Ipc_GetIntrospectionConnection::~Bts2Ipc_GetIntrospectionConnection()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetIntrospectionConnection::clone(void) const
{
   return new Bts2Ipc_GetIntrospectionConnection(*this);
}

Bts2Ipc_ReleaseRes::Bts2Ipc_ReleaseRes()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_ReleaseRes))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_ReleaseRes::Bts2Ipc_ReleaseRes(IN const Bts2Ipc_ReleaseRes& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_ReleaseRes& Bts2Ipc_ReleaseRes::operator=(IN const Bts2Ipc_ReleaseRes& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_ReleaseRes::~Bts2Ipc_ReleaseRes()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_ReleaseRes::clone(void) const
{
   return new Bts2Ipc_ReleaseRes(*this);
}

Bts2Ipc_RequestPinCodeRes::Bts2Ipc_RequestPinCodeRes()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_RequestPinCodeRes))
{
   // _pinCode: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_RequestPinCodeRes::Bts2Ipc_RequestPinCodeRes(IN const Bts2Ipc_RequestPinCodeRes& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _pinCode = ref._pinCode;
}

Bts2Ipc_RequestPinCodeRes& Bts2Ipc_RequestPinCodeRes::operator=(IN const Bts2Ipc_RequestPinCodeRes& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _pinCode = ref._pinCode;

   return *this;
}

Bts2Ipc_RequestPinCodeRes::~Bts2Ipc_RequestPinCodeRes()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_RequestPinCodeRes::clone(void) const
{
   return new Bts2Ipc_RequestPinCodeRes(*this);
}

Bts2Ipc_DisplayPinCodeRes::Bts2Ipc_DisplayPinCodeRes()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_DisplayPinCodeRes))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_DisplayPinCodeRes::Bts2Ipc_DisplayPinCodeRes(IN const Bts2Ipc_DisplayPinCodeRes& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_DisplayPinCodeRes& Bts2Ipc_DisplayPinCodeRes::operator=(IN const Bts2Ipc_DisplayPinCodeRes& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_DisplayPinCodeRes::~Bts2Ipc_DisplayPinCodeRes()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_DisplayPinCodeRes::clone(void) const
{
   return new Bts2Ipc_DisplayPinCodeRes(*this);
}

Bts2Ipc_RequestPasskeyRes::Bts2Ipc_RequestPasskeyRes()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_RequestPasskeyRes))
{
   // _passkey: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_RequestPasskeyRes::Bts2Ipc_RequestPasskeyRes(IN const Bts2Ipc_RequestPasskeyRes& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _passkey = ref._passkey;
}

Bts2Ipc_RequestPasskeyRes& Bts2Ipc_RequestPasskeyRes::operator=(IN const Bts2Ipc_RequestPasskeyRes& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _passkey = ref._passkey;

   return *this;
}

Bts2Ipc_RequestPasskeyRes::~Bts2Ipc_RequestPasskeyRes()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_RequestPasskeyRes::clone(void) const
{
   return new Bts2Ipc_RequestPasskeyRes(*this);
}

Bts2Ipc_RequestConfirmationRes::Bts2Ipc_RequestConfirmationRes()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_RequestConfirmationRes))
{
   _accept = BTS_CONFIRM_LAST;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_RequestConfirmationRes::Bts2Ipc_RequestConfirmationRes(IN const Bts2Ipc_RequestConfirmationRes& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _accept = ref._accept;
}

Bts2Ipc_RequestConfirmationRes& Bts2Ipc_RequestConfirmationRes::operator=(IN const Bts2Ipc_RequestConfirmationRes& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _accept = ref._accept;

   return *this;
}

Bts2Ipc_RequestConfirmationRes::~Bts2Ipc_RequestConfirmationRes()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_RequestConfirmationRes::clone(void) const
{
   return new Bts2Ipc_RequestConfirmationRes(*this);
}

Bts2Ipc_CancelRes::Bts2Ipc_CancelRes()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_CancelRes))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_CancelRes::Bts2Ipc_CancelRes(IN const Bts2Ipc_CancelRes& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_CancelRes& Bts2Ipc_CancelRes::operator=(IN const Bts2Ipc_CancelRes& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_CancelRes::~Bts2Ipc_CancelRes()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_CancelRes::clone(void) const
{
   return new Bts2Ipc_CancelRes(*this);
}

Bts2Ipc_CancelRequestRes::Bts2Ipc_CancelRequestRes()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_CancelRequestRes))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_CancelRequestRes::Bts2Ipc_CancelRequestRes(IN const Bts2Ipc_CancelRequestRes& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_CancelRequestRes& Bts2Ipc_CancelRequestRes::operator=(IN const Bts2Ipc_CancelRequestRes& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_CancelRequestRes::~Bts2Ipc_CancelRequestRes()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_CancelRequestRes::clone(void) const
{
   return new Bts2Ipc_CancelRequestRes(*this);
}

Bts2Ipc_AuthorizeServiceRes::Bts2Ipc_AuthorizeServiceRes()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_AuthorizeServiceRes))
{
   _accept = BTS_CONFIRM_LAST;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_AuthorizeServiceRes::Bts2Ipc_AuthorizeServiceRes(IN const Bts2Ipc_AuthorizeServiceRes& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _accept = ref._accept;
}

Bts2Ipc_AuthorizeServiceRes& Bts2Ipc_AuthorizeServiceRes::operator=(IN const Bts2Ipc_AuthorizeServiceRes& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _accept = ref._accept;

   return *this;
}

Bts2Ipc_AuthorizeServiceRes::~Bts2Ipc_AuthorizeServiceRes()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_AuthorizeServiceRes::clone(void) const
{
   return new Bts2Ipc_AuthorizeServiceRes(*this);
}

Bts2Ipc_RequestAuthorizationRes::Bts2Ipc_RequestAuthorizationRes()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_RequestAuthorizationRes))
{
   _accept = BTS_CONFIRM_LAST;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_RequestAuthorizationRes::Bts2Ipc_RequestAuthorizationRes(IN const Bts2Ipc_RequestAuthorizationRes& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _accept = ref._accept;
}

Bts2Ipc_RequestAuthorizationRes& Bts2Ipc_RequestAuthorizationRes::operator=(IN const Bts2Ipc_RequestAuthorizationRes& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _accept = ref._accept;

   return *this;
}

Bts2Ipc_RequestAuthorizationRes::~Bts2Ipc_RequestAuthorizationRes()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_RequestAuthorizationRes::clone(void) const
{
   return new Bts2Ipc_RequestAuthorizationRes(*this);
}

Bts2Ipc_RequestLinkkeyRes::Bts2Ipc_RequestLinkkeyRes()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_RequestLinkkeyRes))
{
   // _linkKey: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_RequestLinkkeyRes::Bts2Ipc_RequestLinkkeyRes(IN const Bts2Ipc_RequestLinkkeyRes& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _linkKey = ref._linkKey;
}

Bts2Ipc_RequestLinkkeyRes& Bts2Ipc_RequestLinkkeyRes::operator=(IN const Bts2Ipc_RequestLinkkeyRes& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _linkKey = ref._linkKey;

   return *this;
}

Bts2Ipc_RequestLinkkeyRes::~Bts2Ipc_RequestLinkkeyRes()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_RequestLinkkeyRes::clone(void) const
{
   return new Bts2Ipc_RequestLinkkeyRes(*this);
}

Bts2Ipc_DisplayPasskeyRes::Bts2Ipc_DisplayPasskeyRes()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_DisplayPasskeyRes))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_DisplayPasskeyRes::Bts2Ipc_DisplayPasskeyRes(IN const Bts2Ipc_DisplayPasskeyRes& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_DisplayPasskeyRes& Bts2Ipc_DisplayPasskeyRes::operator=(IN const Bts2Ipc_DisplayPasskeyRes& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_DisplayPasskeyRes::~Bts2Ipc_DisplayPasskeyRes()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_DisplayPasskeyRes::clone(void) const
{
   return new Bts2Ipc_DisplayPasskeyRes(*this);
}

Bts2Ipc_StartDiscovery::Bts2Ipc_StartDiscovery()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_StartDiscovery))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_StartDiscovery::Bts2Ipc_StartDiscovery(IN const Bts2Ipc_StartDiscovery& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_StartDiscovery& Bts2Ipc_StartDiscovery::operator=(IN const Bts2Ipc_StartDiscovery& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_StartDiscovery::~Bts2Ipc_StartDiscovery()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_StartDiscovery::clone(void) const
{
   return new Bts2Ipc_StartDiscovery(*this);
}

Bts2Ipc_StopDiscovery::Bts2Ipc_StopDiscovery()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_StopDiscovery))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_StopDiscovery::Bts2Ipc_StopDiscovery(IN const Bts2Ipc_StopDiscovery& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_StopDiscovery& Bts2Ipc_StopDiscovery::operator=(IN const Bts2Ipc_StopDiscovery& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_StopDiscovery::~Bts2Ipc_StopDiscovery()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_StopDiscovery::clone(void) const
{
   return new Bts2Ipc_StopDiscovery(*this);
}

Bts2Ipc_RemoveDevice::Bts2Ipc_RemoveDevice()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_RemoveDevice))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_RemoveDevice::Bts2Ipc_RemoveDevice(IN const Bts2Ipc_RemoveDevice& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_RemoveDevice& Bts2Ipc_RemoveDevice::operator=(IN const Bts2Ipc_RemoveDevice& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_RemoveDevice::~Bts2Ipc_RemoveDevice()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_RemoveDevice::clone(void) const
{
   return new Bts2Ipc_RemoveDevice(*this);
}

Bts2Ipc_CreateDevice::Bts2Ipc_CreateDevice()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_CreateDevice))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_CreateDevice::Bts2Ipc_CreateDevice(IN const Bts2Ipc_CreateDevice& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_CreateDevice& Bts2Ipc_CreateDevice::operator=(IN const Bts2Ipc_CreateDevice& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_CreateDevice::~Bts2Ipc_CreateDevice()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_CreateDevice::clone(void) const
{
   return new Bts2Ipc_CreateDevice(*this);
}

Bts2Ipc_SendHCICmd::Bts2Ipc_SendHCICmd()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SendHCICmd))
{
   _length = 0;
   // _data: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SendHCICmd::Bts2Ipc_SendHCICmd(IN const Bts2Ipc_SendHCICmd& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _length = ref._length;
   _data = ref._data;
}

Bts2Ipc_SendHCICmd& Bts2Ipc_SendHCICmd::operator=(IN const Bts2Ipc_SendHCICmd& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _length = ref._length;
   _data = ref._data;

   return *this;
}

Bts2Ipc_SendHCICmd::~Bts2Ipc_SendHCICmd()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SendHCICmd::clone(void) const
{
   return new Bts2Ipc_SendHCICmd(*this);
}

Bts2Ipc_GetAdapterAddress::Bts2Ipc_GetAdapterAddress()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterAddress))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterAddress::Bts2Ipc_GetAdapterAddress(IN const Bts2Ipc_GetAdapterAddress& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterAddress& Bts2Ipc_GetAdapterAddress::operator=(IN const Bts2Ipc_GetAdapterAddress& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterAddress::~Bts2Ipc_GetAdapterAddress()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterAddress::clone(void) const
{
   return new Bts2Ipc_GetAdapterAddress(*this);
}

Bts2Ipc_GetAdapterClass::Bts2Ipc_GetAdapterClass()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterClass))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterClass::Bts2Ipc_GetAdapterClass(IN const Bts2Ipc_GetAdapterClass& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterClass& Bts2Ipc_GetAdapterClass::operator=(IN const Bts2Ipc_GetAdapterClass& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterClass::~Bts2Ipc_GetAdapterClass()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterClass::clone(void) const
{
   return new Bts2Ipc_GetAdapterClass(*this);
}

Bts2Ipc_GetAdapterAlias::Bts2Ipc_GetAdapterAlias()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterAlias))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterAlias::Bts2Ipc_GetAdapterAlias(IN const Bts2Ipc_GetAdapterAlias& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterAlias& Bts2Ipc_GetAdapterAlias::operator=(IN const Bts2Ipc_GetAdapterAlias& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterAlias::~Bts2Ipc_GetAdapterAlias()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterAlias::clone(void) const
{
   return new Bts2Ipc_GetAdapterAlias(*this);
}

Bts2Ipc_SetAdapterAlias::Bts2Ipc_SetAdapterAlias()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetAdapterAlias))
{
   // _alias: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetAdapterAlias::Bts2Ipc_SetAdapterAlias(IN const Bts2Ipc_SetAdapterAlias& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _alias = ref._alias;
}

Bts2Ipc_SetAdapterAlias& Bts2Ipc_SetAdapterAlias::operator=(IN const Bts2Ipc_SetAdapterAlias& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _alias = ref._alias;

   return *this;
}

Bts2Ipc_SetAdapterAlias::~Bts2Ipc_SetAdapterAlias()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetAdapterAlias::clone(void) const
{
   return new Bts2Ipc_SetAdapterAlias(*this);
}

Bts2Ipc_GetAdapterPowered::Bts2Ipc_GetAdapterPowered()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterPowered))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterPowered::Bts2Ipc_GetAdapterPowered(IN const Bts2Ipc_GetAdapterPowered& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterPowered& Bts2Ipc_GetAdapterPowered::operator=(IN const Bts2Ipc_GetAdapterPowered& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterPowered::~Bts2Ipc_GetAdapterPowered()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterPowered::clone(void) const
{
   return new Bts2Ipc_GetAdapterPowered(*this);
}

Bts2Ipc_SetAdapterPowered::Bts2Ipc_SetAdapterPowered()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetAdapterPowered))
{
   _powered = false;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetAdapterPowered::Bts2Ipc_SetAdapterPowered(IN const Bts2Ipc_SetAdapterPowered& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _powered = ref._powered;
}

Bts2Ipc_SetAdapterPowered& Bts2Ipc_SetAdapterPowered::operator=(IN const Bts2Ipc_SetAdapterPowered& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _powered = ref._powered;

   return *this;
}

Bts2Ipc_SetAdapterPowered::~Bts2Ipc_SetAdapterPowered()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetAdapterPowered::clone(void) const
{
   return new Bts2Ipc_SetAdapterPowered(*this);
}

Bts2Ipc_GetAdapterDiscoverable::Bts2Ipc_GetAdapterDiscoverable()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterDiscoverable))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterDiscoverable::Bts2Ipc_GetAdapterDiscoverable(IN const Bts2Ipc_GetAdapterDiscoverable& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterDiscoverable& Bts2Ipc_GetAdapterDiscoverable::operator=(IN const Bts2Ipc_GetAdapterDiscoverable& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterDiscoverable::~Bts2Ipc_GetAdapterDiscoverable()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterDiscoverable::clone(void) const
{
   return new Bts2Ipc_GetAdapterDiscoverable(*this);
}

Bts2Ipc_SetAdapterDiscoverable::Bts2Ipc_SetAdapterDiscoverable()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetAdapterDiscoverable))
{
   _discoverable = false;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetAdapterDiscoverable::Bts2Ipc_SetAdapterDiscoverable(IN const Bts2Ipc_SetAdapterDiscoverable& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _discoverable = ref._discoverable;
}

Bts2Ipc_SetAdapterDiscoverable& Bts2Ipc_SetAdapterDiscoverable::operator=(IN const Bts2Ipc_SetAdapterDiscoverable& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _discoverable = ref._discoverable;

   return *this;
}

Bts2Ipc_SetAdapterDiscoverable::~Bts2Ipc_SetAdapterDiscoverable()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetAdapterDiscoverable::clone(void) const
{
   return new Bts2Ipc_SetAdapterDiscoverable(*this);
}

Bts2Ipc_GetAdapterDiscoverabletimeout::Bts2Ipc_GetAdapterDiscoverabletimeout()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterDiscoverabletimeout))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterDiscoverabletimeout::Bts2Ipc_GetAdapterDiscoverabletimeout(IN const Bts2Ipc_GetAdapterDiscoverabletimeout& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterDiscoverabletimeout& Bts2Ipc_GetAdapterDiscoverabletimeout::operator=(IN const Bts2Ipc_GetAdapterDiscoverabletimeout& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterDiscoverabletimeout::~Bts2Ipc_GetAdapterDiscoverabletimeout()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterDiscoverabletimeout::clone(void) const
{
   return new Bts2Ipc_GetAdapterDiscoverabletimeout(*this);
}

Bts2Ipc_SetAdapterDiscoverabletimeout::Bts2Ipc_SetAdapterDiscoverabletimeout()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetAdapterDiscoverabletimeout))
{
   _discoverableTimeout = 0;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetAdapterDiscoverabletimeout::Bts2Ipc_SetAdapterDiscoverabletimeout(IN const Bts2Ipc_SetAdapterDiscoverabletimeout& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _discoverableTimeout = ref._discoverableTimeout;
}

Bts2Ipc_SetAdapterDiscoverabletimeout& Bts2Ipc_SetAdapterDiscoverabletimeout::operator=(IN const Bts2Ipc_SetAdapterDiscoverabletimeout& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _discoverableTimeout = ref._discoverableTimeout;

   return *this;
}

Bts2Ipc_SetAdapterDiscoverabletimeout::~Bts2Ipc_SetAdapterDiscoverabletimeout()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetAdapterDiscoverabletimeout::clone(void) const
{
   return new Bts2Ipc_SetAdapterDiscoverabletimeout(*this);
}

Bts2Ipc_GetAdapterPairable::Bts2Ipc_GetAdapterPairable()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterPairable))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterPairable::Bts2Ipc_GetAdapterPairable(IN const Bts2Ipc_GetAdapterPairable& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterPairable& Bts2Ipc_GetAdapterPairable::operator=(IN const Bts2Ipc_GetAdapterPairable& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterPairable::~Bts2Ipc_GetAdapterPairable()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterPairable::clone(void) const
{
   return new Bts2Ipc_GetAdapterPairable(*this);
}

Bts2Ipc_SetAdapterPairable::Bts2Ipc_SetAdapterPairable()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetAdapterPairable))
{
   _pairable = false;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetAdapterPairable::Bts2Ipc_SetAdapterPairable(IN const Bts2Ipc_SetAdapterPairable& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _pairable = ref._pairable;
}

Bts2Ipc_SetAdapterPairable& Bts2Ipc_SetAdapterPairable::operator=(IN const Bts2Ipc_SetAdapterPairable& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _pairable = ref._pairable;

   return *this;
}

Bts2Ipc_SetAdapterPairable::~Bts2Ipc_SetAdapterPairable()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetAdapterPairable::clone(void) const
{
   return new Bts2Ipc_SetAdapterPairable(*this);
}

Bts2Ipc_GetAdapterPairabletimeout::Bts2Ipc_GetAdapterPairabletimeout()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterPairabletimeout))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterPairabletimeout::Bts2Ipc_GetAdapterPairabletimeout(IN const Bts2Ipc_GetAdapterPairabletimeout& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterPairabletimeout& Bts2Ipc_GetAdapterPairabletimeout::operator=(IN const Bts2Ipc_GetAdapterPairabletimeout& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterPairabletimeout::~Bts2Ipc_GetAdapterPairabletimeout()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterPairabletimeout::clone(void) const
{
   return new Bts2Ipc_GetAdapterPairabletimeout(*this);
}

Bts2Ipc_SetAdapterPairabletimeout::Bts2Ipc_SetAdapterPairabletimeout()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetAdapterPairabletimeout))
{
   _pairableTimeout = 0;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetAdapterPairabletimeout::Bts2Ipc_SetAdapterPairabletimeout(IN const Bts2Ipc_SetAdapterPairabletimeout& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _pairableTimeout = ref._pairableTimeout;
}

Bts2Ipc_SetAdapterPairabletimeout& Bts2Ipc_SetAdapterPairabletimeout::operator=(IN const Bts2Ipc_SetAdapterPairabletimeout& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _pairableTimeout = ref._pairableTimeout;

   return *this;
}

Bts2Ipc_SetAdapterPairabletimeout::~Bts2Ipc_SetAdapterPairabletimeout()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetAdapterPairabletimeout::clone(void) const
{
   return new Bts2Ipc_SetAdapterPairabletimeout(*this);
}

Bts2Ipc_GetAdapterDiscovering::Bts2Ipc_GetAdapterDiscovering()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterDiscovering))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterDiscovering::Bts2Ipc_GetAdapterDiscovering(IN const Bts2Ipc_GetAdapterDiscovering& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterDiscovering& Bts2Ipc_GetAdapterDiscovering::operator=(IN const Bts2Ipc_GetAdapterDiscovering& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterDiscovering::~Bts2Ipc_GetAdapterDiscovering()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterDiscovering::clone(void) const
{
   return new Bts2Ipc_GetAdapterDiscovering(*this);
}

Bts2Ipc_GetAdapterUuids::Bts2Ipc_GetAdapterUuids()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterUuids))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterUuids::Bts2Ipc_GetAdapterUuids(IN const Bts2Ipc_GetAdapterUuids& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterUuids& Bts2Ipc_GetAdapterUuids::operator=(IN const Bts2Ipc_GetAdapterUuids& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterUuids::~Bts2Ipc_GetAdapterUuids()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterUuids::clone(void) const
{
   return new Bts2Ipc_GetAdapterUuids(*this);
}

Bts2Ipc_SetAdapterUuids::Bts2Ipc_SetAdapterUuids()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetAdapterUuids))
{
   // _uuids is empty per default
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetAdapterUuids::Bts2Ipc_SetAdapterUuids(IN const Bts2Ipc_SetAdapterUuids& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _uuids = ref._uuids;
}

Bts2Ipc_SetAdapterUuids& Bts2Ipc_SetAdapterUuids::operator=(IN const Bts2Ipc_SetAdapterUuids& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _uuids = ref._uuids;

   return *this;
}

Bts2Ipc_SetAdapterUuids::~Bts2Ipc_SetAdapterUuids()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetAdapterUuids::clone(void) const
{
   return new Bts2Ipc_SetAdapterUuids(*this);
}

Bts2Ipc_GetAdapterWbsMode::Bts2Ipc_GetAdapterWbsMode()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterWbsMode))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterWbsMode::Bts2Ipc_GetAdapterWbsMode(IN const Bts2Ipc_GetAdapterWbsMode& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterWbsMode& Bts2Ipc_GetAdapterWbsMode::operator=(IN const Bts2Ipc_GetAdapterWbsMode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterWbsMode::~Bts2Ipc_GetAdapterWbsMode()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterWbsMode::clone(void) const
{
   return new Bts2Ipc_GetAdapterWbsMode(*this);
}

Bts2Ipc_SetAdapterWbsMode::Bts2Ipc_SetAdapterWbsMode()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetAdapterWbsMode))
{
   _wbsMode = false;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetAdapterWbsMode::Bts2Ipc_SetAdapterWbsMode(IN const Bts2Ipc_SetAdapterWbsMode& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _wbsMode = ref._wbsMode;
}

Bts2Ipc_SetAdapterWbsMode& Bts2Ipc_SetAdapterWbsMode::operator=(IN const Bts2Ipc_SetAdapterWbsMode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _wbsMode = ref._wbsMode;

   return *this;
}

Bts2Ipc_SetAdapterWbsMode::~Bts2Ipc_SetAdapterWbsMode()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetAdapterWbsMode::clone(void) const
{
   return new Bts2Ipc_SetAdapterWbsMode(*this);
}

Bts2Ipc_GetAdapterConnectable::Bts2Ipc_GetAdapterConnectable()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterConnectable))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterConnectable::Bts2Ipc_GetAdapterConnectable(IN const Bts2Ipc_GetAdapterConnectable& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterConnectable& Bts2Ipc_GetAdapterConnectable::operator=(IN const Bts2Ipc_GetAdapterConnectable& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterConnectable::~Bts2Ipc_GetAdapterConnectable()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterConnectable::clone(void) const
{
   return new Bts2Ipc_GetAdapterConnectable(*this);
}

Bts2Ipc_SetAdapterConnectable::Bts2Ipc_SetAdapterConnectable()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetAdapterConnectable))
{
   _connectable = false;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetAdapterConnectable::Bts2Ipc_SetAdapterConnectable(IN const Bts2Ipc_SetAdapterConnectable& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _connectable = ref._connectable;
}

Bts2Ipc_SetAdapterConnectable& Bts2Ipc_SetAdapterConnectable::operator=(IN const Bts2Ipc_SetAdapterConnectable& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _connectable = ref._connectable;

   return *this;
}

Bts2Ipc_SetAdapterConnectable::~Bts2Ipc_SetAdapterConnectable()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetAdapterConnectable::clone(void) const
{
   return new Bts2Ipc_SetAdapterConnectable(*this);
}

Bts2Ipc_GetAdapterHcimode::Bts2Ipc_GetAdapterHcimode()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterHcimode))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterHcimode::Bts2Ipc_GetAdapterHcimode(IN const Bts2Ipc_GetAdapterHcimode& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterHcimode& Bts2Ipc_GetAdapterHcimode::operator=(IN const Bts2Ipc_GetAdapterHcimode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterHcimode::~Bts2Ipc_GetAdapterHcimode()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterHcimode::clone(void) const
{
   return new Bts2Ipc_GetAdapterHcimode(*this);
}

Bts2Ipc_SetAdapterHcimode::Bts2Ipc_SetAdapterHcimode()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetAdapterHcimode))
{
   _hciMode = false;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetAdapterHcimode::Bts2Ipc_SetAdapterHcimode(IN const Bts2Ipc_SetAdapterHcimode& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _hciMode = ref._hciMode;
}

Bts2Ipc_SetAdapterHcimode& Bts2Ipc_SetAdapterHcimode::operator=(IN const Bts2Ipc_SetAdapterHcimode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _hciMode = ref._hciMode;

   return *this;
}

Bts2Ipc_SetAdapterHcimode::~Bts2Ipc_SetAdapterHcimode()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetAdapterHcimode::clone(void) const
{
   return new Bts2Ipc_SetAdapterHcimode(*this);
}

Bts2Ipc_GetAdapterVersion::Bts2Ipc_GetAdapterVersion()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterVersion))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterVersion::Bts2Ipc_GetAdapterVersion(IN const Bts2Ipc_GetAdapterVersion& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterVersion& Bts2Ipc_GetAdapterVersion::operator=(IN const Bts2Ipc_GetAdapterVersion& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterVersion::~Bts2Ipc_GetAdapterVersion()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterVersion::clone(void) const
{
   return new Bts2Ipc_GetAdapterVersion(*this);
}

Bts2Ipc_GetAdapterTraceLevel::Bts2Ipc_GetAdapterTraceLevel()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterTraceLevel))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterTraceLevel::Bts2Ipc_GetAdapterTraceLevel(IN const Bts2Ipc_GetAdapterTraceLevel& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterTraceLevel& Bts2Ipc_GetAdapterTraceLevel::operator=(IN const Bts2Ipc_GetAdapterTraceLevel& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterTraceLevel::~Bts2Ipc_GetAdapterTraceLevel()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterTraceLevel::clone(void) const
{
   return new Bts2Ipc_GetAdapterTraceLevel(*this);
}

Bts2Ipc_SetAdapterTraceLevel::Bts2Ipc_SetAdapterTraceLevel()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetAdapterTraceLevel))
{
   // _traceLevel: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetAdapterTraceLevel::Bts2Ipc_SetAdapterTraceLevel(IN const Bts2Ipc_SetAdapterTraceLevel& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _traceLevel = ref._traceLevel;
}

Bts2Ipc_SetAdapterTraceLevel& Bts2Ipc_SetAdapterTraceLevel::operator=(IN const Bts2Ipc_SetAdapterTraceLevel& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _traceLevel = ref._traceLevel;

   return *this;
}

Bts2Ipc_SetAdapterTraceLevel::~Bts2Ipc_SetAdapterTraceLevel()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetAdapterTraceLevel::clone(void) const
{
   return new Bts2Ipc_SetAdapterTraceLevel(*this);
}

Bts2Ipc_GetAdapterTraceCategory::Bts2Ipc_GetAdapterTraceCategory()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterTraceCategory))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterTraceCategory::Bts2Ipc_GetAdapterTraceCategory(IN const Bts2Ipc_GetAdapterTraceCategory& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterTraceCategory& Bts2Ipc_GetAdapterTraceCategory::operator=(IN const Bts2Ipc_GetAdapterTraceCategory& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterTraceCategory::~Bts2Ipc_GetAdapterTraceCategory()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterTraceCategory::clone(void) const
{
   return new Bts2Ipc_GetAdapterTraceCategory(*this);
}

Bts2Ipc_SetAdapterTraceCategory::Bts2Ipc_SetAdapterTraceCategory()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetAdapterTraceCategory))
{
   // _traceCategory: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetAdapterTraceCategory::Bts2Ipc_SetAdapterTraceCategory(IN const Bts2Ipc_SetAdapterTraceCategory& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _traceCategory = ref._traceCategory;
}

Bts2Ipc_SetAdapterTraceCategory& Bts2Ipc_SetAdapterTraceCategory::operator=(IN const Bts2Ipc_SetAdapterTraceCategory& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _traceCategory = ref._traceCategory;

   return *this;
}

Bts2Ipc_SetAdapterTraceCategory::~Bts2Ipc_SetAdapterTraceCategory()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetAdapterTraceCategory::clone(void) const
{
   return new Bts2Ipc_SetAdapterTraceCategory(*this);
}

Bts2Ipc_GetAdapterAvailableSppServers::Bts2Ipc_GetAdapterAvailableSppServers()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetAdapterAvailableSppServers))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetAdapterAvailableSppServers::Bts2Ipc_GetAdapterAvailableSppServers(IN const Bts2Ipc_GetAdapterAvailableSppServers& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetAdapterAvailableSppServers& Bts2Ipc_GetAdapterAvailableSppServers::operator=(IN const Bts2Ipc_GetAdapterAvailableSppServers& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetAdapterAvailableSppServers::~Bts2Ipc_GetAdapterAvailableSppServers()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetAdapterAvailableSppServers::clone(void) const
{
   return new Bts2Ipc_GetAdapterAvailableSppServers(*this);
}

Bts2Ipc_SetAdapterAvailableSppServers::Bts2Ipc_SetAdapterAvailableSppServers()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetAdapterAvailableSppServers))
{
   // _availableSppServers is empty per default
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetAdapterAvailableSppServers::Bts2Ipc_SetAdapterAvailableSppServers(IN const Bts2Ipc_SetAdapterAvailableSppServers& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _availableSppServers = ref._availableSppServers;
}

Bts2Ipc_SetAdapterAvailableSppServers& Bts2Ipc_SetAdapterAvailableSppServers::operator=(IN const Bts2Ipc_SetAdapterAvailableSppServers& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _availableSppServers = ref._availableSppServers;

   return *this;
}

Bts2Ipc_SetAdapterAvailableSppServers::~Bts2Ipc_SetAdapterAvailableSppServers()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetAdapterAvailableSppServers::clone(void) const
{
   return new Bts2Ipc_SetAdapterAvailableSppServers(*this);
}

Bts2Ipc_RegisterAgent::Bts2Ipc_RegisterAgent()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_RegisterAgent))
{
   // _agent: init is done by member constructor
   _capability = BTS_AGENT_CAPABILITY_LAST;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_RegisterAgent::Bts2Ipc_RegisterAgent(IN const Bts2Ipc_RegisterAgent& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _agent = ref._agent;
   _capability = ref._capability;
}

Bts2Ipc_RegisterAgent& Bts2Ipc_RegisterAgent::operator=(IN const Bts2Ipc_RegisterAgent& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _agent = ref._agent;
   _capability = ref._capability;

   return *this;
}

Bts2Ipc_RegisterAgent::~Bts2Ipc_RegisterAgent()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_RegisterAgent::clone(void) const
{
   return new Bts2Ipc_RegisterAgent(*this);
}

Bts2Ipc_UnregisterAgent::Bts2Ipc_UnregisterAgent()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_UnregisterAgent))
{
   // _agent: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_UnregisterAgent::Bts2Ipc_UnregisterAgent(IN const Bts2Ipc_UnregisterAgent& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _agent = ref._agent;
}

Bts2Ipc_UnregisterAgent& Bts2Ipc_UnregisterAgent::operator=(IN const Bts2Ipc_UnregisterAgent& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _agent = ref._agent;

   return *this;
}

Bts2Ipc_UnregisterAgent::~Bts2Ipc_UnregisterAgent()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_UnregisterAgent::clone(void) const
{
   return new Bts2Ipc_UnregisterAgent(*this);
}

Bts2Ipc_RequestDefaultAgent::Bts2Ipc_RequestDefaultAgent()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_RequestDefaultAgent))
{
   // _agent: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_RequestDefaultAgent::Bts2Ipc_RequestDefaultAgent(IN const Bts2Ipc_RequestDefaultAgent& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _agent = ref._agent;
}

Bts2Ipc_RequestDefaultAgent& Bts2Ipc_RequestDefaultAgent::operator=(IN const Bts2Ipc_RequestDefaultAgent& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _agent = ref._agent;

   return *this;
}

Bts2Ipc_RequestDefaultAgent::~Bts2Ipc_RequestDefaultAgent()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_RequestDefaultAgent::clone(void) const
{
   return new Bts2Ipc_RequestDefaultAgent(*this);
}

Bts2Ipc_DeviceConnect::Bts2Ipc_DeviceConnect()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_DeviceConnect))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_DeviceConnect::Bts2Ipc_DeviceConnect(IN const Bts2Ipc_DeviceConnect& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_DeviceConnect& Bts2Ipc_DeviceConnect::operator=(IN const Bts2Ipc_DeviceConnect& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_DeviceConnect::~Bts2Ipc_DeviceConnect()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_DeviceConnect::clone(void) const
{
   return new Bts2Ipc_DeviceConnect(*this);
}

Bts2Ipc_DeviceDisconnect::Bts2Ipc_DeviceDisconnect()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_DeviceDisconnect))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_DeviceDisconnect::Bts2Ipc_DeviceDisconnect(IN const Bts2Ipc_DeviceDisconnect& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_DeviceDisconnect& Bts2Ipc_DeviceDisconnect::operator=(IN const Bts2Ipc_DeviceDisconnect& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_DeviceDisconnect::~Bts2Ipc_DeviceDisconnect()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_DeviceDisconnect::clone(void) const
{
   return new Bts2Ipc_DeviceDisconnect(*this);
}

Bts2Ipc_Pair::Bts2Ipc_Pair()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_Pair))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_Pair::Bts2Ipc_Pair(IN const Bts2Ipc_Pair& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_Pair& Bts2Ipc_Pair::operator=(IN const Bts2Ipc_Pair& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_Pair::~Bts2Ipc_Pair()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_Pair::clone(void) const
{
   return new Bts2Ipc_Pair(*this);
}

Bts2Ipc_CancelPairing::Bts2Ipc_CancelPairing()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_CancelPairing))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_CancelPairing::Bts2Ipc_CancelPairing(IN const Bts2Ipc_CancelPairing& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_CancelPairing& Bts2Ipc_CancelPairing::operator=(IN const Bts2Ipc_CancelPairing& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_CancelPairing::~Bts2Ipc_CancelPairing()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_CancelPairing::clone(void) const
{
   return new Bts2Ipc_CancelPairing(*this);
}

Bts2Ipc_DiscoverServices::Bts2Ipc_DiscoverServices()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_DiscoverServices))
{
   _searchType = BTS_SEARCH_LAST;
   // _uuid: init is done by member constructor
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_DiscoverServices::Bts2Ipc_DiscoverServices(IN const Bts2Ipc_DiscoverServices& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _searchType = ref._searchType;
   _uuid = ref._uuid;
   _device = ref._device;
}

Bts2Ipc_DiscoverServices& Bts2Ipc_DiscoverServices::operator=(IN const Bts2Ipc_DiscoverServices& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _searchType = ref._searchType;
   _uuid = ref._uuid;
   _device = ref._device;

   return *this;
}

Bts2Ipc_DiscoverServices::~Bts2Ipc_DiscoverServices()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_DiscoverServices::clone(void) const
{
   return new Bts2Ipc_DiscoverServices(*this);
}

Bts2Ipc_CancelDiscovery::Bts2Ipc_CancelDiscovery()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_CancelDiscovery))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_CancelDiscovery::Bts2Ipc_CancelDiscovery(IN const Bts2Ipc_CancelDiscovery& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_CancelDiscovery& Bts2Ipc_CancelDiscovery::operator=(IN const Bts2Ipc_CancelDiscovery& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_CancelDiscovery::~Bts2Ipc_CancelDiscovery()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_CancelDiscovery::clone(void) const
{
   return new Bts2Ipc_CancelDiscovery(*this);
}

Bts2Ipc_GetDeviceAddress::Bts2Ipc_GetDeviceAddress()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceAddress))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceAddress::Bts2Ipc_GetDeviceAddress(IN const Bts2Ipc_GetDeviceAddress& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceAddress& Bts2Ipc_GetDeviceAddress::operator=(IN const Bts2Ipc_GetDeviceAddress& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceAddress::~Bts2Ipc_GetDeviceAddress()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceAddress::clone(void) const
{
   return new Bts2Ipc_GetDeviceAddress(*this);
}

Bts2Ipc_GetDeviceClass::Bts2Ipc_GetDeviceClass()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceClass))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceClass::Bts2Ipc_GetDeviceClass(IN const Bts2Ipc_GetDeviceClass& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceClass& Bts2Ipc_GetDeviceClass::operator=(IN const Bts2Ipc_GetDeviceClass& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceClass::~Bts2Ipc_GetDeviceClass()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceClass::clone(void) const
{
   return new Bts2Ipc_GetDeviceClass(*this);
}

Bts2Ipc_GetDeviceIcon::Bts2Ipc_GetDeviceIcon()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceIcon))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceIcon::Bts2Ipc_GetDeviceIcon(IN const Bts2Ipc_GetDeviceIcon& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceIcon& Bts2Ipc_GetDeviceIcon::operator=(IN const Bts2Ipc_GetDeviceIcon& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceIcon::~Bts2Ipc_GetDeviceIcon()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceIcon::clone(void) const
{
   return new Bts2Ipc_GetDeviceIcon(*this);
}

Bts2Ipc_GetDeviceUuids::Bts2Ipc_GetDeviceUuids()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceUuids))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceUuids::Bts2Ipc_GetDeviceUuids(IN const Bts2Ipc_GetDeviceUuids& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceUuids& Bts2Ipc_GetDeviceUuids::operator=(IN const Bts2Ipc_GetDeviceUuids& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceUuids::~Bts2Ipc_GetDeviceUuids()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceUuids::clone(void) const
{
   return new Bts2Ipc_GetDeviceUuids(*this);
}

Bts2Ipc_GetDevicePaired::Bts2Ipc_GetDevicePaired()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDevicePaired))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDevicePaired::Bts2Ipc_GetDevicePaired(IN const Bts2Ipc_GetDevicePaired& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDevicePaired& Bts2Ipc_GetDevicePaired::operator=(IN const Bts2Ipc_GetDevicePaired& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDevicePaired::~Bts2Ipc_GetDevicePaired()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDevicePaired::clone(void) const
{
   return new Bts2Ipc_GetDevicePaired(*this);
}

Bts2Ipc_GetDeviceConnected::Bts2Ipc_GetDeviceConnected()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceConnected))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceConnected::Bts2Ipc_GetDeviceConnected(IN const Bts2Ipc_GetDeviceConnected& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceConnected& Bts2Ipc_GetDeviceConnected::operator=(IN const Bts2Ipc_GetDeviceConnected& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceConnected::~Bts2Ipc_GetDeviceConnected()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceConnected::clone(void) const
{
   return new Bts2Ipc_GetDeviceConnected(*this);
}

Bts2Ipc_GetDeviceTrusted::Bts2Ipc_GetDeviceTrusted()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceTrusted))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceTrusted::Bts2Ipc_GetDeviceTrusted(IN const Bts2Ipc_GetDeviceTrusted& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceTrusted& Bts2Ipc_GetDeviceTrusted::operator=(IN const Bts2Ipc_GetDeviceTrusted& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceTrusted::~Bts2Ipc_GetDeviceTrusted()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceTrusted::clone(void) const
{
   return new Bts2Ipc_GetDeviceTrusted(*this);
}

Bts2Ipc_SetDeviceTrusted::Bts2Ipc_SetDeviceTrusted()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetDeviceTrusted))
{
   _trusted = false;
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetDeviceTrusted::Bts2Ipc_SetDeviceTrusted(IN const Bts2Ipc_SetDeviceTrusted& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _trusted = ref._trusted;
   _device = ref._device;
}

Bts2Ipc_SetDeviceTrusted& Bts2Ipc_SetDeviceTrusted::operator=(IN const Bts2Ipc_SetDeviceTrusted& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _trusted = ref._trusted;
   _device = ref._device;

   return *this;
}

Bts2Ipc_SetDeviceTrusted::~Bts2Ipc_SetDeviceTrusted()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetDeviceTrusted::clone(void) const
{
   return new Bts2Ipc_SetDeviceTrusted(*this);
}

Bts2Ipc_GetDeviceBlocked::Bts2Ipc_GetDeviceBlocked()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceBlocked))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceBlocked::Bts2Ipc_GetDeviceBlocked(IN const Bts2Ipc_GetDeviceBlocked& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceBlocked& Bts2Ipc_GetDeviceBlocked::operator=(IN const Bts2Ipc_GetDeviceBlocked& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceBlocked::~Bts2Ipc_GetDeviceBlocked()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceBlocked::clone(void) const
{
   return new Bts2Ipc_GetDeviceBlocked(*this);
}

Bts2Ipc_SetDeviceBlocked::Bts2Ipc_SetDeviceBlocked()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetDeviceBlocked))
{
   _blocked = false;
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetDeviceBlocked::Bts2Ipc_SetDeviceBlocked(IN const Bts2Ipc_SetDeviceBlocked& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _blocked = ref._blocked;
   _device = ref._device;
}

Bts2Ipc_SetDeviceBlocked& Bts2Ipc_SetDeviceBlocked::operator=(IN const Bts2Ipc_SetDeviceBlocked& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _blocked = ref._blocked;
   _device = ref._device;

   return *this;
}

Bts2Ipc_SetDeviceBlocked::~Bts2Ipc_SetDeviceBlocked()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetDeviceBlocked::clone(void) const
{
   return new Bts2Ipc_SetDeviceBlocked(*this);
}

Bts2Ipc_GetDeviceAlias::Bts2Ipc_GetDeviceAlias()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceAlias))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceAlias::Bts2Ipc_GetDeviceAlias(IN const Bts2Ipc_GetDeviceAlias& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceAlias& Bts2Ipc_GetDeviceAlias::operator=(IN const Bts2Ipc_GetDeviceAlias& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceAlias::~Bts2Ipc_GetDeviceAlias()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceAlias::clone(void) const
{
   return new Bts2Ipc_GetDeviceAlias(*this);
}

Bts2Ipc_SetDeviceAlias::Bts2Ipc_SetDeviceAlias()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetDeviceAlias))
{
   // _device: init is done by member constructor
   // _alias: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetDeviceAlias::Bts2Ipc_SetDeviceAlias(IN const Bts2Ipc_SetDeviceAlias& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
   _alias = ref._alias;
}

Bts2Ipc_SetDeviceAlias& Bts2Ipc_SetDeviceAlias::operator=(IN const Bts2Ipc_SetDeviceAlias& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;
   _alias = ref._alias;

   return *this;
}

Bts2Ipc_SetDeviceAlias::~Bts2Ipc_SetDeviceAlias()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetDeviceAlias::clone(void) const
{
   return new Bts2Ipc_SetDeviceAlias(*this);
}

Bts2Ipc_GetDeviceAdapter::Bts2Ipc_GetDeviceAdapter()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceAdapter))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceAdapter::Bts2Ipc_GetDeviceAdapter(IN const Bts2Ipc_GetDeviceAdapter& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceAdapter& Bts2Ipc_GetDeviceAdapter::operator=(IN const Bts2Ipc_GetDeviceAdapter& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceAdapter::~Bts2Ipc_GetDeviceAdapter()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceAdapter::clone(void) const
{
   return new Bts2Ipc_GetDeviceAdapter(*this);
}

Bts2Ipc_GetDeviceModalias::Bts2Ipc_GetDeviceModalias()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceModalias))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceModalias::Bts2Ipc_GetDeviceModalias(IN const Bts2Ipc_GetDeviceModalias& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceModalias& Bts2Ipc_GetDeviceModalias::operator=(IN const Bts2Ipc_GetDeviceModalias& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceModalias::~Bts2Ipc_GetDeviceModalias()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceModalias::clone(void) const
{
   return new Bts2Ipc_GetDeviceModalias(*this);
}

Bts2Ipc_GetDeviceRssi::Bts2Ipc_GetDeviceRssi()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceRssi))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceRssi::Bts2Ipc_GetDeviceRssi(IN const Bts2Ipc_GetDeviceRssi& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceRssi& Bts2Ipc_GetDeviceRssi::operator=(IN const Bts2Ipc_GetDeviceRssi& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceRssi::~Bts2Ipc_GetDeviceRssi()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceRssi::clone(void) const
{
   return new Bts2Ipc_GetDeviceRssi(*this);
}

Bts2Ipc_GetDeviceVendorId::Bts2Ipc_GetDeviceVendorId()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceVendorId))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceVendorId::Bts2Ipc_GetDeviceVendorId(IN const Bts2Ipc_GetDeviceVendorId& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceVendorId& Bts2Ipc_GetDeviceVendorId::operator=(IN const Bts2Ipc_GetDeviceVendorId& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceVendorId::~Bts2Ipc_GetDeviceVendorId()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceVendorId::clone(void) const
{
   return new Bts2Ipc_GetDeviceVendorId(*this);
}

Bts2Ipc_GetDeviceVendorIdSource::Bts2Ipc_GetDeviceVendorIdSource()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceVendorIdSource))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceVendorIdSource::Bts2Ipc_GetDeviceVendorIdSource(IN const Bts2Ipc_GetDeviceVendorIdSource& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceVendorIdSource& Bts2Ipc_GetDeviceVendorIdSource::operator=(IN const Bts2Ipc_GetDeviceVendorIdSource& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceVendorIdSource::~Bts2Ipc_GetDeviceVendorIdSource()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceVendorIdSource::clone(void) const
{
   return new Bts2Ipc_GetDeviceVendorIdSource(*this);
}

Bts2Ipc_GetDeviceProductId::Bts2Ipc_GetDeviceProductId()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceProductId))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceProductId::Bts2Ipc_GetDeviceProductId(IN const Bts2Ipc_GetDeviceProductId& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceProductId& Bts2Ipc_GetDeviceProductId::operator=(IN const Bts2Ipc_GetDeviceProductId& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceProductId::~Bts2Ipc_GetDeviceProductId()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceProductId::clone(void) const
{
   return new Bts2Ipc_GetDeviceProductId(*this);
}

Bts2Ipc_GetDeviceMapInfo::Bts2Ipc_GetDeviceMapInfo()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceMapInfo))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceMapInfo::Bts2Ipc_GetDeviceMapInfo(IN const Bts2Ipc_GetDeviceMapInfo& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceMapInfo& Bts2Ipc_GetDeviceMapInfo::operator=(IN const Bts2Ipc_GetDeviceMapInfo& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceMapInfo::~Bts2Ipc_GetDeviceMapInfo()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceMapInfo::clone(void) const
{
   return new Bts2Ipc_GetDeviceMapInfo(*this);
}

Bts2Ipc_GetDeviceConnectedService::Bts2Ipc_GetDeviceConnectedService()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceConnectedService))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceConnectedService::Bts2Ipc_GetDeviceConnectedService(IN const Bts2Ipc_GetDeviceConnectedService& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceConnectedService& Bts2Ipc_GetDeviceConnectedService::operator=(IN const Bts2Ipc_GetDeviceConnectedService& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceConnectedService::~Bts2Ipc_GetDeviceConnectedService()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceConnectedService::clone(void) const
{
   return new Bts2Ipc_GetDeviceConnectedService(*this);
}

Bts2Ipc_GetDeviceVersion::Bts2Ipc_GetDeviceVersion()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceVersion))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceVersion::Bts2Ipc_GetDeviceVersion(IN const Bts2Ipc_GetDeviceVersion& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceVersion& Bts2Ipc_GetDeviceVersion::operator=(IN const Bts2Ipc_GetDeviceVersion& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceVersion::~Bts2Ipc_GetDeviceVersion()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceVersion::clone(void) const
{
   return new Bts2Ipc_GetDeviceVersion(*this);
}

Bts2Ipc_GetDevicePbapInfo::Bts2Ipc_GetDevicePbapInfo()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDevicePbapInfo))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDevicePbapInfo::Bts2Ipc_GetDevicePbapInfo(IN const Bts2Ipc_GetDevicePbapInfo& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDevicePbapInfo& Bts2Ipc_GetDevicePbapInfo::operator=(IN const Bts2Ipc_GetDevicePbapInfo& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDevicePbapInfo::~Bts2Ipc_GetDevicePbapInfo()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDevicePbapInfo::clone(void) const
{
   return new Bts2Ipc_GetDevicePbapInfo(*this);
}

Bts2Ipc_GetDeviceMode::Bts2Ipc_GetDeviceMode()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceMode))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceMode::Bts2Ipc_GetDeviceMode(IN const Bts2Ipc_GetDeviceMode& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceMode& Bts2Ipc_GetDeviceMode::operator=(IN const Bts2Ipc_GetDeviceMode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceMode::~Bts2Ipc_GetDeviceMode()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceMode::clone(void) const
{
   return new Bts2Ipc_GetDeviceMode(*this);
}

Bts2Ipc_GetDeviceRole::Bts2Ipc_GetDeviceRole()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceRole))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceRole::Bts2Ipc_GetDeviceRole(IN const Bts2Ipc_GetDeviceRole& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceRole& Bts2Ipc_GetDeviceRole::operator=(IN const Bts2Ipc_GetDeviceRole& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceRole::~Bts2Ipc_GetDeviceRole()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceRole::clone(void) const
{
   return new Bts2Ipc_GetDeviceRole(*this);
}

Bts2Ipc_GetDeviceEnableAvpPause::Bts2Ipc_GetDeviceEnableAvpPause()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDeviceEnableAvpPause))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDeviceEnableAvpPause::Bts2Ipc_GetDeviceEnableAvpPause(IN const Bts2Ipc_GetDeviceEnableAvpPause& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetDeviceEnableAvpPause& Bts2Ipc_GetDeviceEnableAvpPause::operator=(IN const Bts2Ipc_GetDeviceEnableAvpPause& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetDeviceEnableAvpPause::~Bts2Ipc_GetDeviceEnableAvpPause()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDeviceEnableAvpPause::clone(void) const
{
   return new Bts2Ipc_GetDeviceEnableAvpPause(*this);
}

Bts2Ipc_SetDeviceEnableAvpPause::Bts2Ipc_SetDeviceEnableAvpPause()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetDeviceEnableAvpPause))
{
   _enableAvpPause = false;
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetDeviceEnableAvpPause::Bts2Ipc_SetDeviceEnableAvpPause(IN const Bts2Ipc_SetDeviceEnableAvpPause& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _enableAvpPause = ref._enableAvpPause;
   _device = ref._device;
}

Bts2Ipc_SetDeviceEnableAvpPause& Bts2Ipc_SetDeviceEnableAvpPause::operator=(IN const Bts2Ipc_SetDeviceEnableAvpPause& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _enableAvpPause = ref._enableAvpPause;
   _device = ref._device;

   return *this;
}

Bts2Ipc_SetDeviceEnableAvpPause::~Bts2Ipc_SetDeviceEnableAvpPause()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetDeviceEnableAvpPause::clone(void) const
{
   return new Bts2Ipc_SetDeviceEnableAvpPause(*this);
}

Bts2Ipc_BtApplDeviceConnectReq::Bts2Ipc_BtApplDeviceConnectReq()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_BtApplDeviceConnectReq))
{
   // _serviceFunction: init is done by member constructor
   _instance = 0;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_BtApplDeviceConnectReq::Bts2Ipc_BtApplDeviceConnectReq(IN const Bts2Ipc_BtApplDeviceConnectReq& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _serviceFunction = ref._serviceFunction;
   _instance = ref._instance;
}

Bts2Ipc_BtApplDeviceConnectReq& Bts2Ipc_BtApplDeviceConnectReq::operator=(IN const Bts2Ipc_BtApplDeviceConnectReq& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _serviceFunction = ref._serviceFunction;
   _instance = ref._instance;

   return *this;
}

Bts2Ipc_BtApplDeviceConnectReq::~Bts2Ipc_BtApplDeviceConnectReq()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_BtApplDeviceConnectReq::clone(void) const
{
   return new Bts2Ipc_BtApplDeviceConnectReq(*this);
}

Bts2Ipc_BtApplDeviceDisconnectReq::Bts2Ipc_BtApplDeviceDisconnectReq()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_BtApplDeviceDisconnectReq))
{
   // _serviceFunction: init is done by member constructor
   _instance = 0;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_BtApplDeviceDisconnectReq::Bts2Ipc_BtApplDeviceDisconnectReq(IN const Bts2Ipc_BtApplDeviceDisconnectReq& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _serviceFunction = ref._serviceFunction;
   _instance = ref._instance;
}

Bts2Ipc_BtApplDeviceDisconnectReq& Bts2Ipc_BtApplDeviceDisconnectReq::operator=(IN const Bts2Ipc_BtApplDeviceDisconnectReq& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _serviceFunction = ref._serviceFunction;
   _instance = ref._instance;

   return *this;
}

Bts2Ipc_BtApplDeviceDisconnectReq::~Bts2Ipc_BtApplDeviceDisconnectReq()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_BtApplDeviceDisconnectReq::clone(void) const
{
   return new Bts2Ipc_BtApplDeviceDisconnectReq(*this);
}

Bts2Ipc_BtApplCancelConnectReq::Bts2Ipc_BtApplCancelConnectReq()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_BtApplCancelConnectReq))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_BtApplCancelConnectReq::Bts2Ipc_BtApplCancelConnectReq(IN const Bts2Ipc_BtApplCancelConnectReq& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_BtApplCancelConnectReq& Bts2Ipc_BtApplCancelConnectReq::operator=(IN const Bts2Ipc_BtApplCancelConnectReq& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_BtApplCancelConnectReq::~Bts2Ipc_BtApplCancelConnectReq()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_BtApplCancelConnectReq::clone(void) const
{
   return new Bts2Ipc_BtApplCancelConnectReq(*this);
}

Bts2Ipc_BtApplGetHwVersionReq::Bts2Ipc_BtApplGetHwVersionReq()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_BtApplGetHwVersionReq))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_BtApplGetHwVersionReq::Bts2Ipc_BtApplGetHwVersionReq(IN const Bts2Ipc_BtApplGetHwVersionReq& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_BtApplGetHwVersionReq& Bts2Ipc_BtApplGetHwVersionReq::operator=(IN const Bts2Ipc_BtApplGetHwVersionReq& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_BtApplGetHwVersionReq::~Bts2Ipc_BtApplGetHwVersionReq()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_BtApplGetHwVersionReq::clone(void) const
{
   return new Bts2Ipc_BtApplGetHwVersionReq(*this);
}

Bts2Ipc_BtApplSetConfigurationReq::Bts2Ipc_BtApplSetConfigurationReq()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_BtApplSetConfigurationReq))
{
   _instance = 0;
   _configId = BTS_EVO_CONFIG_ID_LAST;
   // _data: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_BtApplSetConfigurationReq::Bts2Ipc_BtApplSetConfigurationReq(IN const Bts2Ipc_BtApplSetConfigurationReq& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _instance = ref._instance;
   _configId = ref._configId;
   _data = ref._data;
}

Bts2Ipc_BtApplSetConfigurationReq& Bts2Ipc_BtApplSetConfigurationReq::operator=(IN const Bts2Ipc_BtApplSetConfigurationReq& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _instance = ref._instance;
   _configId = ref._configId;
   _data = ref._data;

   return *this;
}

Bts2Ipc_BtApplSetConfigurationReq::~Bts2Ipc_BtApplSetConfigurationReq()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_BtApplSetConfigurationReq::clone(void) const
{
   return new Bts2Ipc_BtApplSetConfigurationReq(*this);
}

Bts2Ipc_BtApplReadConfigurationReq::Bts2Ipc_BtApplReadConfigurationReq()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_BtApplReadConfigurationReq))
{
   _instance = 0;
   _configId = BTS_EVO_CONFIG_ID_LAST;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_BtApplReadConfigurationReq::Bts2Ipc_BtApplReadConfigurationReq(IN const Bts2Ipc_BtApplReadConfigurationReq& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _instance = ref._instance;
   _configId = ref._configId;
}

Bts2Ipc_BtApplReadConfigurationReq& Bts2Ipc_BtApplReadConfigurationReq::operator=(IN const Bts2Ipc_BtApplReadConfigurationReq& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _instance = ref._instance;
   _configId = ref._configId;

   return *this;
}

Bts2Ipc_BtApplReadConfigurationReq::~Bts2Ipc_BtApplReadConfigurationReq()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_BtApplReadConfigurationReq::clone(void) const
{
   return new Bts2Ipc_BtApplReadConfigurationReq(*this);
}

Bts2Ipc_BtApplTestModeReq::Bts2Ipc_BtApplTestModeReq()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_BtApplTestModeReq))
{
   _enable = false;
   _mode = BTS_TEST_MODE_LAST;
   _role = BTS_BT_LAST;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_BtApplTestModeReq::Bts2Ipc_BtApplTestModeReq(IN const Bts2Ipc_BtApplTestModeReq& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _enable = ref._enable;
   _mode = ref._mode;
   _role = ref._role;
}

Bts2Ipc_BtApplTestModeReq& Bts2Ipc_BtApplTestModeReq::operator=(IN const Bts2Ipc_BtApplTestModeReq& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _enable = ref._enable;
   _mode = ref._mode;
   _role = ref._role;

   return *this;
}

Bts2Ipc_BtApplTestModeReq::~Bts2Ipc_BtApplTestModeReq()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_BtApplTestModeReq::clone(void) const
{
   return new Bts2Ipc_BtApplTestModeReq(*this);
}

Bts2Ipc_BtApplTestModeLinkQualityReq::Bts2Ipc_BtApplTestModeLinkQualityReq()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_BtApplTestModeLinkQualityReq))
{
   _mode = BTS_TEST_MODE_LAST;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_BtApplTestModeLinkQualityReq::Bts2Ipc_BtApplTestModeLinkQualityReq(IN const Bts2Ipc_BtApplTestModeLinkQualityReq& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _mode = ref._mode;
}

Bts2Ipc_BtApplTestModeLinkQualityReq& Bts2Ipc_BtApplTestModeLinkQualityReq::operator=(IN const Bts2Ipc_BtApplTestModeLinkQualityReq& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _mode = ref._mode;

   return *this;
}

Bts2Ipc_BtApplTestModeLinkQualityReq::~Bts2Ipc_BtApplTestModeLinkQualityReq()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_BtApplTestModeLinkQualityReq::clone(void) const
{
   return new Bts2Ipc_BtApplTestModeLinkQualityReq(*this);
}

Bts2Ipc_Connect::Bts2Ipc_Connect()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_Connect))
{
   _protocol = BTS_PROTO_LAST;
   // _uuid: init is done by member constructor
   // _service: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_Connect::Bts2Ipc_Connect(IN const Bts2Ipc_Connect& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _service = ref._service;
}

Bts2Ipc_Connect& Bts2Ipc_Connect::operator=(IN const Bts2Ipc_Connect& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _service = ref._service;

   return *this;
}

Bts2Ipc_Connect::~Bts2Ipc_Connect()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_Connect::clone(void) const
{
   return new Bts2Ipc_Connect(*this);
}

Bts2Ipc_Disconnect::Bts2Ipc_Disconnect()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_Disconnect))
{
   _protocol = BTS_PROTO_LAST;
   // _uuid: init is done by member constructor
   // _service: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_Disconnect::Bts2Ipc_Disconnect(IN const Bts2Ipc_Disconnect& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _service = ref._service;
}

Bts2Ipc_Disconnect& Bts2Ipc_Disconnect::operator=(IN const Bts2Ipc_Disconnect& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _service = ref._service;

   return *this;
}

Bts2Ipc_Disconnect::~Bts2Ipc_Disconnect()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_Disconnect::clone(void) const
{
   return new Bts2Ipc_Disconnect(*this);
}

Bts2Ipc_GetServiceRemoteUuid::Bts2Ipc_GetServiceRemoteUuid()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetServiceRemoteUuid))
{
   _protocol = BTS_PROTO_LAST;
   // _uuid: init is done by member constructor
   // _service: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetServiceRemoteUuid::Bts2Ipc_GetServiceRemoteUuid(IN const Bts2Ipc_GetServiceRemoteUuid& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _service = ref._service;
}

Bts2Ipc_GetServiceRemoteUuid& Bts2Ipc_GetServiceRemoteUuid::operator=(IN const Bts2Ipc_GetServiceRemoteUuid& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _service = ref._service;

   return *this;
}

Bts2Ipc_GetServiceRemoteUuid::~Bts2Ipc_GetServiceRemoteUuid()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetServiceRemoteUuid::clone(void) const
{
   return new Bts2Ipc_GetServiceRemoteUuid(*this);
}

Bts2Ipc_GetServiceState::Bts2Ipc_GetServiceState()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetServiceState))
{
   _protocol = BTS_PROTO_LAST;
   // _uuid: init is done by member constructor
   // _service: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetServiceState::Bts2Ipc_GetServiceState(IN const Bts2Ipc_GetServiceState& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _service = ref._service;
}

Bts2Ipc_GetServiceState& Bts2Ipc_GetServiceState::operator=(IN const Bts2Ipc_GetServiceState& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _service = ref._service;

   return *this;
}

Bts2Ipc_GetServiceState::~Bts2Ipc_GetServiceState()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetServiceState::clone(void) const
{
   return new Bts2Ipc_GetServiceState(*this);
}

Bts2Ipc_GetServiceDevice::Bts2Ipc_GetServiceDevice()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetServiceDevice))
{
   _protocol = BTS_PROTO_LAST;
   // _uuid: init is done by member constructor
   // _service: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetServiceDevice::Bts2Ipc_GetServiceDevice(IN const Bts2Ipc_GetServiceDevice& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _service = ref._service;
}

Bts2Ipc_GetServiceDevice& Bts2Ipc_GetServiceDevice::operator=(IN const Bts2Ipc_GetServiceDevice& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _service = ref._service;

   return *this;
}

Bts2Ipc_GetServiceDevice::~Bts2Ipc_GetServiceDevice()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetServiceDevice::clone(void) const
{
   return new Bts2Ipc_GetServiceDevice(*this);
}

Bts2Ipc_GetServiceVersion::Bts2Ipc_GetServiceVersion()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetServiceVersion))
{
   _protocol = BTS_PROTO_LAST;
   // _uuid: init is done by member constructor
   // _service: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetServiceVersion::Bts2Ipc_GetServiceVersion(IN const Bts2Ipc_GetServiceVersion& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _service = ref._service;
}

Bts2Ipc_GetServiceVersion& Bts2Ipc_GetServiceVersion::operator=(IN const Bts2Ipc_GetServiceVersion& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _protocol = ref._protocol;
   _uuid = ref._uuid;
   _service = ref._service;

   return *this;
}

Bts2Ipc_GetServiceVersion::~Bts2Ipc_GetServiceVersion()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetServiceVersion::clone(void) const
{
   return new Bts2Ipc_GetServiceVersion(*this);
}

Bts2Ipc_DebugTraceConfig::Bts2Ipc_DebugTraceConfig()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_DebugTraceConfig))
{
   _traceLevel = 0;
   _currentTime = 0;
   _traceMode = BTS_DEBUG_TRACE_MODE_LAST;
   _category1 = 0;
   _category2 = 0;
   _category3 = 0;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_DebugTraceConfig::Bts2Ipc_DebugTraceConfig(IN const Bts2Ipc_DebugTraceConfig& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _traceLevel = ref._traceLevel;
   _currentTime = ref._currentTime;
   _traceMode = ref._traceMode;
   _category1 = ref._category1;
   _category2 = ref._category2;
   _category3 = ref._category3;
}

Bts2Ipc_DebugTraceConfig& Bts2Ipc_DebugTraceConfig::operator=(IN const Bts2Ipc_DebugTraceConfig& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _traceLevel = ref._traceLevel;
   _currentTime = ref._currentTime;
   _traceMode = ref._traceMode;
   _category1 = ref._category1;
   _category2 = ref._category2;
   _category3 = ref._category3;

   return *this;
}

Bts2Ipc_DebugTraceConfig::~Bts2Ipc_DebugTraceConfig()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_DebugTraceConfig::clone(void) const
{
   return new Bts2Ipc_DebugTraceConfig(*this);
}

Bts2Ipc_ProtocolTraceConfig::Bts2Ipc_ProtocolTraceConfig()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_ProtocolTraceConfig))
{
   _traceFilter = 0;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_ProtocolTraceConfig::Bts2Ipc_ProtocolTraceConfig(IN const Bts2Ipc_ProtocolTraceConfig& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _traceFilter = ref._traceFilter;
}

Bts2Ipc_ProtocolTraceConfig& Bts2Ipc_ProtocolTraceConfig::operator=(IN const Bts2Ipc_ProtocolTraceConfig& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _traceFilter = ref._traceFilter;

   return *this;
}

Bts2Ipc_ProtocolTraceConfig::~Bts2Ipc_ProtocolTraceConfig()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_ProtocolTraceConfig::clone(void) const
{
   return new Bts2Ipc_ProtocolTraceConfig(*this);
}

Bts2Ipc_BtApplDidSetReq::Bts2Ipc_BtApplDidSetReq()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_BtApplDidSetReq))
{
   // _serviceRecord: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_BtApplDidSetReq::Bts2Ipc_BtApplDidSetReq(IN const Bts2Ipc_BtApplDidSetReq& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _serviceRecord = ref._serviceRecord;
}

Bts2Ipc_BtApplDidSetReq& Bts2Ipc_BtApplDidSetReq::operator=(IN const Bts2Ipc_BtApplDidSetReq& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _serviceRecord = ref._serviceRecord;

   return *this;
}

Bts2Ipc_BtApplDidSetReq::~Bts2Ipc_BtApplDidSetReq()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_BtApplDidSetReq::clone(void) const
{
   return new Bts2Ipc_BtApplDidSetReq(*this);
}

Bts2Ipc_GetDunDeviceFilePath::Bts2Ipc_GetDunDeviceFilePath()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetDunDeviceFilePath))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetDunDeviceFilePath::Bts2Ipc_GetDunDeviceFilePath(IN const Bts2Ipc_GetDunDeviceFilePath& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetDunDeviceFilePath& Bts2Ipc_GetDunDeviceFilePath::operator=(IN const Bts2Ipc_GetDunDeviceFilePath& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetDunDeviceFilePath::~Bts2Ipc_GetDunDeviceFilePath()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetDunDeviceFilePath::clone(void) const
{
   return new Bts2Ipc_GetDunDeviceFilePath(*this);
}

Bts2Ipc_BtApplSppSetUuidReq::Bts2Ipc_BtApplSppSetUuidReq()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_BtApplSppSetUuidReq))
{
   _instance = 0;
   // _outgoingUuid: init is done by member constructor
   // _incomingUuid: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_BtApplSppSetUuidReq::Bts2Ipc_BtApplSppSetUuidReq(IN const Bts2Ipc_BtApplSppSetUuidReq& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _instance = ref._instance;
   _outgoingUuid = ref._outgoingUuid;
   _incomingUuid = ref._incomingUuid;
}

Bts2Ipc_BtApplSppSetUuidReq& Bts2Ipc_BtApplSppSetUuidReq::operator=(IN const Bts2Ipc_BtApplSppSetUuidReq& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _instance = ref._instance;
   _outgoingUuid = ref._outgoingUuid;
   _incomingUuid = ref._incomingUuid;

   return *this;
}

Bts2Ipc_BtApplSppSetUuidReq::~Bts2Ipc_BtApplSppSetUuidReq()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_BtApplSppSetUuidReq::clone(void) const
{
   return new Bts2Ipc_BtApplSppSetUuidReq(*this);
}

Bts2Ipc_CreateSession::Bts2Ipc_CreateSession()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_CreateSession))
{
   // _sourceAddress: init is done by member constructor
   _protocolId = BTS_PROTO_LAST;
   _channel = 0;
   _instanceId = 0;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_CreateSession::Bts2Ipc_CreateSession(IN const Bts2Ipc_CreateSession& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _sourceAddress = ref._sourceAddress;
   _protocolId = ref._protocolId;
   _channel = ref._channel;
   _instanceId = ref._instanceId;
}

Bts2Ipc_CreateSession& Bts2Ipc_CreateSession::operator=(IN const Bts2Ipc_CreateSession& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _sourceAddress = ref._sourceAddress;
   _protocolId = ref._protocolId;
   _channel = ref._channel;
   _instanceId = ref._instanceId;

   return *this;
}

Bts2Ipc_CreateSession::~Bts2Ipc_CreateSession()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_CreateSession::clone(void) const
{
   return new Bts2Ipc_CreateSession(*this);
}

Bts2Ipc_RemoveSession::Bts2Ipc_RemoveSession()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_RemoveSession))
{
   _protocolId = BTS_PROTO_LAST;
   _instanceId = 0;
   // _session: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_RemoveSession::Bts2Ipc_RemoveSession(IN const Bts2Ipc_RemoveSession& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _protocolId = ref._protocolId;
   _instanceId = ref._instanceId;
   _session = ref._session;
}

Bts2Ipc_RemoveSession& Bts2Ipc_RemoveSession::operator=(IN const Bts2Ipc_RemoveSession& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _protocolId = ref._protocolId;
   _instanceId = ref._instanceId;
   _session = ref._session;

   return *this;
}

Bts2Ipc_RemoveSession::~Bts2Ipc_RemoveSession()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_RemoveSession::clone(void) const
{
   return new Bts2Ipc_RemoveSession(*this);
}

Bts2Ipc_CancelSession::Bts2Ipc_CancelSession()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_CancelSession))
{
   // _sourceAddress: init is done by member constructor
   _protocolId = BTS_PROTO_LAST;
   _channel = 0;
   _instanceId = 0;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_CancelSession::Bts2Ipc_CancelSession(IN const Bts2Ipc_CancelSession& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _sourceAddress = ref._sourceAddress;
   _protocolId = ref._protocolId;
   _channel = ref._channel;
   _instanceId = ref._instanceId;
}

Bts2Ipc_CancelSession& Bts2Ipc_CancelSession::operator=(IN const Bts2Ipc_CancelSession& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _sourceAddress = ref._sourceAddress;
   _protocolId = ref._protocolId;
   _channel = ref._channel;
   _instanceId = ref._instanceId;

   return *this;
}

Bts2Ipc_CancelSession::~Bts2Ipc_CancelSession()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_CancelSession::clone(void) const
{
   return new Bts2Ipc_CancelSession(*this);
}

Bts2Ipc_GetConnManManagerProperties::Bts2Ipc_GetConnManManagerProperties()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetConnManManagerProperties))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetConnManManagerProperties::Bts2Ipc_GetConnManManagerProperties(IN const Bts2Ipc_GetConnManManagerProperties& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetConnManManagerProperties& Bts2Ipc_GetConnManManagerProperties::operator=(IN const Bts2Ipc_GetConnManManagerProperties& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetConnManManagerProperties::~Bts2Ipc_GetConnManManagerProperties()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetConnManManagerProperties::clone(void) const
{
   return new Bts2Ipc_GetConnManManagerProperties(*this);
}

Bts2Ipc_GetConnManTechnologies::Bts2Ipc_GetConnManTechnologies()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetConnManTechnologies))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetConnManTechnologies::Bts2Ipc_GetConnManTechnologies(IN const Bts2Ipc_GetConnManTechnologies& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetConnManTechnologies& Bts2Ipc_GetConnManTechnologies::operator=(IN const Bts2Ipc_GetConnManTechnologies& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetConnManTechnologies::~Bts2Ipc_GetConnManTechnologies()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetConnManTechnologies::clone(void) const
{
   return new Bts2Ipc_GetConnManTechnologies(*this);
}

Bts2Ipc_GetConnManServices::Bts2Ipc_GetConnManServices()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetConnManServices))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetConnManServices::Bts2Ipc_GetConnManServices(IN const Bts2Ipc_GetConnManServices& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetConnManServices& Bts2Ipc_GetConnManServices::operator=(IN const Bts2Ipc_GetConnManServices& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetConnManServices::~Bts2Ipc_GetConnManServices()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetConnManServices::clone(void) const
{
   return new Bts2Ipc_GetConnManServices(*this);
}

Bts2Ipc_GetConnManServiceProperties::Bts2Ipc_GetConnManServiceProperties()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetConnManServiceProperties))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetConnManServiceProperties::Bts2Ipc_GetConnManServiceProperties(IN const Bts2Ipc_GetConnManServiceProperties& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetConnManServiceProperties& Bts2Ipc_GetConnManServiceProperties::operator=(IN const Bts2Ipc_GetConnManServiceProperties& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetConnManServiceProperties::~Bts2Ipc_GetConnManServiceProperties()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetConnManServiceProperties::clone(void) const
{
   return new Bts2Ipc_GetConnManServiceProperties(*this);
}

Bts2Ipc_ConnManServiceConnect::Bts2Ipc_ConnManServiceConnect()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_ConnManServiceConnect))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_ConnManServiceConnect::Bts2Ipc_ConnManServiceConnect(IN const Bts2Ipc_ConnManServiceConnect& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_ConnManServiceConnect& Bts2Ipc_ConnManServiceConnect::operator=(IN const Bts2Ipc_ConnManServiceConnect& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_ConnManServiceConnect::~Bts2Ipc_ConnManServiceConnect()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_ConnManServiceConnect::clone(void) const
{
   return new Bts2Ipc_ConnManServiceConnect(*this);
}

Bts2Ipc_ConnManServiceDisconnect::Bts2Ipc_ConnManServiceDisconnect()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_ConnManServiceDisconnect))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_ConnManServiceDisconnect::Bts2Ipc_ConnManServiceDisconnect(IN const Bts2Ipc_ConnManServiceDisconnect& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_ConnManServiceDisconnect& Bts2Ipc_ConnManServiceDisconnect::operator=(IN const Bts2Ipc_ConnManServiceDisconnect& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_ConnManServiceDisconnect::~Bts2Ipc_ConnManServiceDisconnect()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_ConnManServiceDisconnect::clone(void) const
{
   return new Bts2Ipc_ConnManServiceDisconnect(*this);
}

Bts2Ipc_CreateLeDevice::Bts2Ipc_CreateLeDevice()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_CreateLeDevice))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_CreateLeDevice::Bts2Ipc_CreateLeDevice(IN const Bts2Ipc_CreateLeDevice& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_CreateLeDevice& Bts2Ipc_CreateLeDevice::operator=(IN const Bts2Ipc_CreateLeDevice& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_CreateLeDevice::~Bts2Ipc_CreateLeDevice()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_CreateLeDevice::clone(void) const
{
   return new Bts2Ipc_CreateLeDevice(*this);
}

Bts2Ipc_RemoveLeDevice::Bts2Ipc_RemoveLeDevice()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_RemoveLeDevice))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_RemoveLeDevice::Bts2Ipc_RemoveLeDevice(IN const Bts2Ipc_RemoveLeDevice& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_RemoveLeDevice& Bts2Ipc_RemoveLeDevice::operator=(IN const Bts2Ipc_RemoveLeDevice& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_RemoveLeDevice::~Bts2Ipc_RemoveLeDevice()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_RemoveLeDevice::clone(void) const
{
   return new Bts2Ipc_RemoveLeDevice(*this);
}

Bts2Ipc_GetLeAdapterAddressType::Bts2Ipc_GetLeAdapterAddressType()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetLeAdapterAddressType))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetLeAdapterAddressType::Bts2Ipc_GetLeAdapterAddressType(IN const Bts2Ipc_GetLeAdapterAddressType& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetLeAdapterAddressType& Bts2Ipc_GetLeAdapterAddressType::operator=(IN const Bts2Ipc_GetLeAdapterAddressType& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetLeAdapterAddressType::~Bts2Ipc_GetLeAdapterAddressType()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetLeAdapterAddressType::clone(void) const
{
   return new Bts2Ipc_GetLeAdapterAddressType(*this);
}

Bts2Ipc_GetLeAdapterAddress::Bts2Ipc_GetLeAdapterAddress()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetLeAdapterAddress))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetLeAdapterAddress::Bts2Ipc_GetLeAdapterAddress(IN const Bts2Ipc_GetLeAdapterAddress& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetLeAdapterAddress& Bts2Ipc_GetLeAdapterAddress::operator=(IN const Bts2Ipc_GetLeAdapterAddress& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetLeAdapterAddress::~Bts2Ipc_GetLeAdapterAddress()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetLeAdapterAddress::clone(void) const
{
   return new Bts2Ipc_GetLeAdapterAddress(*this);
}

Bts2Ipc_GetLeAdapterAlias::Bts2Ipc_GetLeAdapterAlias()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetLeAdapterAlias))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetLeAdapterAlias::Bts2Ipc_GetLeAdapterAlias(IN const Bts2Ipc_GetLeAdapterAlias& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetLeAdapterAlias& Bts2Ipc_GetLeAdapterAlias::operator=(IN const Bts2Ipc_GetLeAdapterAlias& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetLeAdapterAlias::~Bts2Ipc_GetLeAdapterAlias()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetLeAdapterAlias::clone(void) const
{
   return new Bts2Ipc_GetLeAdapterAlias(*this);
}

Bts2Ipc_SetLeAdapterAlias::Bts2Ipc_SetLeAdapterAlias()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetLeAdapterAlias))
{
   // _alias: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetLeAdapterAlias::Bts2Ipc_SetLeAdapterAlias(IN const Bts2Ipc_SetLeAdapterAlias& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _alias = ref._alias;
}

Bts2Ipc_SetLeAdapterAlias& Bts2Ipc_SetLeAdapterAlias::operator=(IN const Bts2Ipc_SetLeAdapterAlias& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _alias = ref._alias;

   return *this;
}

Bts2Ipc_SetLeAdapterAlias::~Bts2Ipc_SetLeAdapterAlias()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetLeAdapterAlias::clone(void) const
{
   return new Bts2Ipc_SetLeAdapterAlias(*this);
}

Bts2Ipc_GetLeAdapterAdvertisingTimeout::Bts2Ipc_GetLeAdapterAdvertisingTimeout()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetLeAdapterAdvertisingTimeout))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetLeAdapterAdvertisingTimeout::Bts2Ipc_GetLeAdapterAdvertisingTimeout(IN const Bts2Ipc_GetLeAdapterAdvertisingTimeout& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetLeAdapterAdvertisingTimeout& Bts2Ipc_GetLeAdapterAdvertisingTimeout::operator=(IN const Bts2Ipc_GetLeAdapterAdvertisingTimeout& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetLeAdapterAdvertisingTimeout::~Bts2Ipc_GetLeAdapterAdvertisingTimeout()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetLeAdapterAdvertisingTimeout::clone(void) const
{
   return new Bts2Ipc_GetLeAdapterAdvertisingTimeout(*this);
}

Bts2Ipc_SetLeAdapterAdvertisingTimeout::Bts2Ipc_SetLeAdapterAdvertisingTimeout()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetLeAdapterAdvertisingTimeout))
{
   _advertisingTimeout = 0;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetLeAdapterAdvertisingTimeout::Bts2Ipc_SetLeAdapterAdvertisingTimeout(IN const Bts2Ipc_SetLeAdapterAdvertisingTimeout& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _advertisingTimeout = ref._advertisingTimeout;
}

Bts2Ipc_SetLeAdapterAdvertisingTimeout& Bts2Ipc_SetLeAdapterAdvertisingTimeout::operator=(IN const Bts2Ipc_SetLeAdapterAdvertisingTimeout& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _advertisingTimeout = ref._advertisingTimeout;

   return *this;
}

Bts2Ipc_SetLeAdapterAdvertisingTimeout::~Bts2Ipc_SetLeAdapterAdvertisingTimeout()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetLeAdapterAdvertisingTimeout::clone(void) const
{
   return new Bts2Ipc_SetLeAdapterAdvertisingTimeout(*this);
}

Bts2Ipc_GetLeAdapterDiscoverableMode::Bts2Ipc_GetLeAdapterDiscoverableMode()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetLeAdapterDiscoverableMode))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetLeAdapterDiscoverableMode::Bts2Ipc_GetLeAdapterDiscoverableMode(IN const Bts2Ipc_GetLeAdapterDiscoverableMode& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetLeAdapterDiscoverableMode& Bts2Ipc_GetLeAdapterDiscoverableMode::operator=(IN const Bts2Ipc_GetLeAdapterDiscoverableMode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetLeAdapterDiscoverableMode::~Bts2Ipc_GetLeAdapterDiscoverableMode()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetLeAdapterDiscoverableMode::clone(void) const
{
   return new Bts2Ipc_GetLeAdapterDiscoverableMode(*this);
}

Bts2Ipc_SetLeAdapterDiscoverableMode::Bts2Ipc_SetLeAdapterDiscoverableMode()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetLeAdapterDiscoverableMode))
{
   _discoverableMode = BTS_BLE_DISCOVERABLE_MODE_LAST;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetLeAdapterDiscoverableMode::Bts2Ipc_SetLeAdapterDiscoverableMode(IN const Bts2Ipc_SetLeAdapterDiscoverableMode& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _discoverableMode = ref._discoverableMode;
}

Bts2Ipc_SetLeAdapterDiscoverableMode& Bts2Ipc_SetLeAdapterDiscoverableMode::operator=(IN const Bts2Ipc_SetLeAdapterDiscoverableMode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _discoverableMode = ref._discoverableMode;

   return *this;
}

Bts2Ipc_SetLeAdapterDiscoverableMode::~Bts2Ipc_SetLeAdapterDiscoverableMode()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetLeAdapterDiscoverableMode::clone(void) const
{
   return new Bts2Ipc_SetLeAdapterDiscoverableMode(*this);
}

Bts2Ipc_GetLeAdapterAdvertisingData::Bts2Ipc_GetLeAdapterAdvertisingData()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetLeAdapterAdvertisingData))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetLeAdapterAdvertisingData::Bts2Ipc_GetLeAdapterAdvertisingData(IN const Bts2Ipc_GetLeAdapterAdvertisingData& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetLeAdapterAdvertisingData& Bts2Ipc_GetLeAdapterAdvertisingData::operator=(IN const Bts2Ipc_GetLeAdapterAdvertisingData& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetLeAdapterAdvertisingData::~Bts2Ipc_GetLeAdapterAdvertisingData()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetLeAdapterAdvertisingData::clone(void) const
{
   return new Bts2Ipc_GetLeAdapterAdvertisingData(*this);
}

Bts2Ipc_SetLeAdapterAdvertisingData::Bts2Ipc_SetLeAdapterAdvertisingData()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetLeAdapterAdvertisingData))
{
   // _advertisingData: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetLeAdapterAdvertisingData::Bts2Ipc_SetLeAdapterAdvertisingData(IN const Bts2Ipc_SetLeAdapterAdvertisingData& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _advertisingData = ref._advertisingData;
}

Bts2Ipc_SetLeAdapterAdvertisingData& Bts2Ipc_SetLeAdapterAdvertisingData::operator=(IN const Bts2Ipc_SetLeAdapterAdvertisingData& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _advertisingData = ref._advertisingData;

   return *this;
}

Bts2Ipc_SetLeAdapterAdvertisingData::~Bts2Ipc_SetLeAdapterAdvertisingData()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetLeAdapterAdvertisingData::clone(void) const
{
   return new Bts2Ipc_SetLeAdapterAdvertisingData(*this);
}

Bts2Ipc_GetLeAdapterAdvertiseEnable::Bts2Ipc_GetLeAdapterAdvertiseEnable()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetLeAdapterAdvertiseEnable))
{
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetLeAdapterAdvertiseEnable::Bts2Ipc_GetLeAdapterAdvertiseEnable(IN const Bts2Ipc_GetLeAdapterAdvertiseEnable& ref)
: Bts2Ipc_BaseMessage(ref)
{
}

Bts2Ipc_GetLeAdapterAdvertiseEnable& Bts2Ipc_GetLeAdapterAdvertiseEnable::operator=(IN const Bts2Ipc_GetLeAdapterAdvertiseEnable& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   return *this;
}

Bts2Ipc_GetLeAdapterAdvertiseEnable::~Bts2Ipc_GetLeAdapterAdvertiseEnable()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetLeAdapterAdvertiseEnable::clone(void) const
{
   return new Bts2Ipc_GetLeAdapterAdvertiseEnable(*this);
}

Bts2Ipc_SetLeAdapterAdvertiseEnable::Bts2Ipc_SetLeAdapterAdvertiseEnable()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetLeAdapterAdvertiseEnable))
{
   _advertiseEnable = false;
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetLeAdapterAdvertiseEnable::Bts2Ipc_SetLeAdapterAdvertiseEnable(IN const Bts2Ipc_SetLeAdapterAdvertiseEnable& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _advertiseEnable = ref._advertiseEnable;
}

Bts2Ipc_SetLeAdapterAdvertiseEnable& Bts2Ipc_SetLeAdapterAdvertiseEnable::operator=(IN const Bts2Ipc_SetLeAdapterAdvertiseEnable& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _advertiseEnable = ref._advertiseEnable;

   return *this;
}

Bts2Ipc_SetLeAdapterAdvertiseEnable::~Bts2Ipc_SetLeAdapterAdvertiseEnable()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetLeAdapterAdvertiseEnable::clone(void) const
{
   return new Bts2Ipc_SetLeAdapterAdvertiseEnable(*this);
}

Bts2Ipc_LeDeviceDisconnect::Bts2Ipc_LeDeviceDisconnect()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_LeDeviceDisconnect))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_LeDeviceDisconnect::Bts2Ipc_LeDeviceDisconnect(IN const Bts2Ipc_LeDeviceDisconnect& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_LeDeviceDisconnect& Bts2Ipc_LeDeviceDisconnect::operator=(IN const Bts2Ipc_LeDeviceDisconnect& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_LeDeviceDisconnect::~Bts2Ipc_LeDeviceDisconnect()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_LeDeviceDisconnect::clone(void) const
{
   return new Bts2Ipc_LeDeviceDisconnect(*this);
}

Bts2Ipc_GetLeDeviceAddressType::Bts2Ipc_GetLeDeviceAddressType()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetLeDeviceAddressType))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetLeDeviceAddressType::Bts2Ipc_GetLeDeviceAddressType(IN const Bts2Ipc_GetLeDeviceAddressType& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetLeDeviceAddressType& Bts2Ipc_GetLeDeviceAddressType::operator=(IN const Bts2Ipc_GetLeDeviceAddressType& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetLeDeviceAddressType::~Bts2Ipc_GetLeDeviceAddressType()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetLeDeviceAddressType::clone(void) const
{
   return new Bts2Ipc_GetLeDeviceAddressType(*this);
}

Bts2Ipc_GetLeDeviceAddress::Bts2Ipc_GetLeDeviceAddress()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetLeDeviceAddress))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetLeDeviceAddress::Bts2Ipc_GetLeDeviceAddress(IN const Bts2Ipc_GetLeDeviceAddress& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetLeDeviceAddress& Bts2Ipc_GetLeDeviceAddress::operator=(IN const Bts2Ipc_GetLeDeviceAddress& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetLeDeviceAddress::~Bts2Ipc_GetLeDeviceAddress()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetLeDeviceAddress::clone(void) const
{
   return new Bts2Ipc_GetLeDeviceAddress(*this);
}

Bts2Ipc_GetLeDeviceConnected::Bts2Ipc_GetLeDeviceConnected()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetLeDeviceConnected))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetLeDeviceConnected::Bts2Ipc_GetLeDeviceConnected(IN const Bts2Ipc_GetLeDeviceConnected& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetLeDeviceConnected& Bts2Ipc_GetLeDeviceConnected::operator=(IN const Bts2Ipc_GetLeDeviceConnected& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetLeDeviceConnected::~Bts2Ipc_GetLeDeviceConnected()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetLeDeviceConnected::clone(void) const
{
   return new Bts2Ipc_GetLeDeviceConnected(*this);
}

Bts2Ipc_SendSeamlessPairingErrorCode::Bts2Ipc_SendSeamlessPairingErrorCode()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SendSeamlessPairingErrorCode))
{
   // _errorCode: init is done by member constructor
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SendSeamlessPairingErrorCode::Bts2Ipc_SendSeamlessPairingErrorCode(IN const Bts2Ipc_SendSeamlessPairingErrorCode& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _errorCode = ref._errorCode;
   _device = ref._device;
}

Bts2Ipc_SendSeamlessPairingErrorCode& Bts2Ipc_SendSeamlessPairingErrorCode::operator=(IN const Bts2Ipc_SendSeamlessPairingErrorCode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _errorCode = ref._errorCode;
   _device = ref._device;

   return *this;
}

Bts2Ipc_SendSeamlessPairingErrorCode::~Bts2Ipc_SendSeamlessPairingErrorCode()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SendSeamlessPairingErrorCode::clone(void) const
{
   return new Bts2Ipc_SendSeamlessPairingErrorCode(*this);
}

Bts2Ipc_SeamlessPairingAllowAccess::Bts2Ipc_SeamlessPairingAllowAccess()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SeamlessPairingAllowAccess))
{
   _accept = false;
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SeamlessPairingAllowAccess::Bts2Ipc_SeamlessPairingAllowAccess(IN const Bts2Ipc_SeamlessPairingAllowAccess& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _accept = ref._accept;
   _device = ref._device;
}

Bts2Ipc_SeamlessPairingAllowAccess& Bts2Ipc_SeamlessPairingAllowAccess::operator=(IN const Bts2Ipc_SeamlessPairingAllowAccess& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _accept = ref._accept;
   _device = ref._device;

   return *this;
}

Bts2Ipc_SeamlessPairingAllowAccess::~Bts2Ipc_SeamlessPairingAllowAccess()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SeamlessPairingAllowAccess::clone(void) const
{
   return new Bts2Ipc_SeamlessPairingAllowAccess(*this);
}

Bts2Ipc_GetSeamlessPairingPairingData::Bts2Ipc_GetSeamlessPairingPairingData()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_GetSeamlessPairingPairingData))
{
   // _device: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_GetSeamlessPairingPairingData::Bts2Ipc_GetSeamlessPairingPairingData(IN const Bts2Ipc_GetSeamlessPairingPairingData& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
}

Bts2Ipc_GetSeamlessPairingPairingData& Bts2Ipc_GetSeamlessPairingPairingData::operator=(IN const Bts2Ipc_GetSeamlessPairingPairingData& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;

   return *this;
}

Bts2Ipc_GetSeamlessPairingPairingData::~Bts2Ipc_GetSeamlessPairingPairingData()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_GetSeamlessPairingPairingData::clone(void) const
{
   return new Bts2Ipc_GetSeamlessPairingPairingData(*this);
}

Bts2Ipc_SetSeamlessPairingPairingData::Bts2Ipc_SetSeamlessPairingPairingData()
: Bts2Ipc_BaseMessage((BTSCommonEnumClass)(BTS_FB_CONNECTION), (BTSCommonEnumClass)(Bts2IpcOC_SetSeamlessPairingPairingData))
{
   // _device: init is done by member constructor
   // _pairingData: init is done by member constructor
   setBtsSourceFunctionBlock(BTS_FB_CONNECTION);
}

Bts2Ipc_SetSeamlessPairingPairingData::Bts2Ipc_SetSeamlessPairingPairingData(IN const Bts2Ipc_SetSeamlessPairingPairingData& ref)
: Bts2Ipc_BaseMessage(ref)
{
   _device = ref._device;
   _pairingData = ref._pairingData;
}

Bts2Ipc_SetSeamlessPairingPairingData& Bts2Ipc_SetSeamlessPairingPairingData::operator=(IN const Bts2Ipc_SetSeamlessPairingPairingData& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   Bts2Ipc_BaseMessage::operator=(ref);

   _device = ref._device;
   _pairingData = ref._pairingData;

   return *this;
}

Bts2Ipc_SetSeamlessPairingPairingData::~Bts2Ipc_SetSeamlessPairingPairingData()
{
}

Bts2Ipc_BaseMessage* Bts2Ipc_SetSeamlessPairingPairingData::clone(void) const
{
   return new Bts2Ipc_SetSeamlessPairingPairingData(*this);
}

} //genivi
} //btstackif
