/**
 * @file Bts2Ipc_MessageWrapper_GEN.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief Wrapper for BtStackIf to IPC messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wrapper for BtStackIf to IPC messages.
 * The only reason for this file is to solve following lint warnings:
 * Warning 429: prio2: Custodial pointer 'ptrMessage' ...
 */

#ifndef _BTS_2_IPC_MESSAGE_WRAPPER_GENIVI_H_
#define _BTS_2_IPC_MESSAGE_WRAPPER_GENIVI_H_

#include "Bts2Ipc_Connection_GEN.h"
#include "Bts2Ipc_Telephony_GEN.h"
#include "Bts2Ipc_Phonebook_GEN.h"
#include "Bts2Ipc_Messaging_GEN.h"
#include "Bts2Ipc_MediaPlayer_GEN.h"

namespace btstackif {
namespace genivi {

inline Bts2Ipc_GetManagedObjectsConnection* ptrNew_Bts2Ipc_GetManagedObjectsConnection(void) { return new Bts2Ipc_GetManagedObjectsConnection(); }
inline Bts2Ipc_GetAllPropertiesConnection* ptrNew_Bts2Ipc_GetAllPropertiesConnection(void) { return new Bts2Ipc_GetAllPropertiesConnection(); }
inline Bts2Ipc_GetIntrospectionConnection* ptrNew_Bts2Ipc_GetIntrospectionConnection(void) { return new Bts2Ipc_GetIntrospectionConnection(); }
inline Bts2Ipc_ReleaseRes* ptrNew_Bts2Ipc_ReleaseRes(void) { return new Bts2Ipc_ReleaseRes(); }
inline Bts2Ipc_RequestPinCodeRes* ptrNew_Bts2Ipc_RequestPinCodeRes(void) { return new Bts2Ipc_RequestPinCodeRes(); }
inline Bts2Ipc_DisplayPinCodeRes* ptrNew_Bts2Ipc_DisplayPinCodeRes(void) { return new Bts2Ipc_DisplayPinCodeRes(); }
inline Bts2Ipc_RequestPasskeyRes* ptrNew_Bts2Ipc_RequestPasskeyRes(void) { return new Bts2Ipc_RequestPasskeyRes(); }
inline Bts2Ipc_RequestConfirmationRes* ptrNew_Bts2Ipc_RequestConfirmationRes(void) { return new Bts2Ipc_RequestConfirmationRes(); }
inline Bts2Ipc_CancelRes* ptrNew_Bts2Ipc_CancelRes(void) { return new Bts2Ipc_CancelRes(); }
inline Bts2Ipc_CancelRequestRes* ptrNew_Bts2Ipc_CancelRequestRes(void) { return new Bts2Ipc_CancelRequestRes(); }
inline Bts2Ipc_AuthorizeServiceRes* ptrNew_Bts2Ipc_AuthorizeServiceRes(void) { return new Bts2Ipc_AuthorizeServiceRes(); }
inline Bts2Ipc_RequestAuthorizationRes* ptrNew_Bts2Ipc_RequestAuthorizationRes(void) { return new Bts2Ipc_RequestAuthorizationRes(); }
inline Bts2Ipc_RequestLinkkeyRes* ptrNew_Bts2Ipc_RequestLinkkeyRes(void) { return new Bts2Ipc_RequestLinkkeyRes(); }
inline Bts2Ipc_DisplayPasskeyRes* ptrNew_Bts2Ipc_DisplayPasskeyRes(void) { return new Bts2Ipc_DisplayPasskeyRes(); }
inline Bts2Ipc_StartDiscovery* ptrNew_Bts2Ipc_StartDiscovery(void) { return new Bts2Ipc_StartDiscovery(); }
inline Bts2Ipc_StopDiscovery* ptrNew_Bts2Ipc_StopDiscovery(void) { return new Bts2Ipc_StopDiscovery(); }
inline Bts2Ipc_RemoveDevice* ptrNew_Bts2Ipc_RemoveDevice(void) { return new Bts2Ipc_RemoveDevice(); }
inline Bts2Ipc_CreateDevice* ptrNew_Bts2Ipc_CreateDevice(void) { return new Bts2Ipc_CreateDevice(); }
inline Bts2Ipc_SendHCICmd* ptrNew_Bts2Ipc_SendHCICmd(void) { return new Bts2Ipc_SendHCICmd(); }
inline Bts2Ipc_GetAdapterAddress* ptrNew_Bts2Ipc_GetAdapterAddress(void) { return new Bts2Ipc_GetAdapterAddress(); }
inline Bts2Ipc_GetAdapterClass* ptrNew_Bts2Ipc_GetAdapterClass(void) { return new Bts2Ipc_GetAdapterClass(); }
inline Bts2Ipc_GetAdapterAlias* ptrNew_Bts2Ipc_GetAdapterAlias(void) { return new Bts2Ipc_GetAdapterAlias(); }
inline Bts2Ipc_SetAdapterAlias* ptrNew_Bts2Ipc_SetAdapterAlias(void) { return new Bts2Ipc_SetAdapterAlias(); }
inline Bts2Ipc_GetAdapterPowered* ptrNew_Bts2Ipc_GetAdapterPowered(void) { return new Bts2Ipc_GetAdapterPowered(); }
inline Bts2Ipc_SetAdapterPowered* ptrNew_Bts2Ipc_SetAdapterPowered(void) { return new Bts2Ipc_SetAdapterPowered(); }
inline Bts2Ipc_GetAdapterDiscoverable* ptrNew_Bts2Ipc_GetAdapterDiscoverable(void) { return new Bts2Ipc_GetAdapterDiscoverable(); }
inline Bts2Ipc_SetAdapterDiscoverable* ptrNew_Bts2Ipc_SetAdapterDiscoverable(void) { return new Bts2Ipc_SetAdapterDiscoverable(); }
inline Bts2Ipc_GetAdapterDiscoverabletimeout* ptrNew_Bts2Ipc_GetAdapterDiscoverabletimeout(void) { return new Bts2Ipc_GetAdapterDiscoverabletimeout(); }
inline Bts2Ipc_SetAdapterDiscoverabletimeout* ptrNew_Bts2Ipc_SetAdapterDiscoverabletimeout(void) { return new Bts2Ipc_SetAdapterDiscoverabletimeout(); }
inline Bts2Ipc_GetAdapterPairable* ptrNew_Bts2Ipc_GetAdapterPairable(void) { return new Bts2Ipc_GetAdapterPairable(); }
inline Bts2Ipc_SetAdapterPairable* ptrNew_Bts2Ipc_SetAdapterPairable(void) { return new Bts2Ipc_SetAdapterPairable(); }
inline Bts2Ipc_GetAdapterPairabletimeout* ptrNew_Bts2Ipc_GetAdapterPairabletimeout(void) { return new Bts2Ipc_GetAdapterPairabletimeout(); }
inline Bts2Ipc_SetAdapterPairabletimeout* ptrNew_Bts2Ipc_SetAdapterPairabletimeout(void) { return new Bts2Ipc_SetAdapterPairabletimeout(); }
inline Bts2Ipc_GetAdapterDiscovering* ptrNew_Bts2Ipc_GetAdapterDiscovering(void) { return new Bts2Ipc_GetAdapterDiscovering(); }
inline Bts2Ipc_GetAdapterUuids* ptrNew_Bts2Ipc_GetAdapterUuids(void) { return new Bts2Ipc_GetAdapterUuids(); }
inline Bts2Ipc_SetAdapterUuids* ptrNew_Bts2Ipc_SetAdapterUuids(void) { return new Bts2Ipc_SetAdapterUuids(); }
inline Bts2Ipc_GetAdapterWbsMode* ptrNew_Bts2Ipc_GetAdapterWbsMode(void) { return new Bts2Ipc_GetAdapterWbsMode(); }
inline Bts2Ipc_SetAdapterWbsMode* ptrNew_Bts2Ipc_SetAdapterWbsMode(void) { return new Bts2Ipc_SetAdapterWbsMode(); }
inline Bts2Ipc_GetAdapterConnectable* ptrNew_Bts2Ipc_GetAdapterConnectable(void) { return new Bts2Ipc_GetAdapterConnectable(); }
inline Bts2Ipc_SetAdapterConnectable* ptrNew_Bts2Ipc_SetAdapterConnectable(void) { return new Bts2Ipc_SetAdapterConnectable(); }
inline Bts2Ipc_GetAdapterHcimode* ptrNew_Bts2Ipc_GetAdapterHcimode(void) { return new Bts2Ipc_GetAdapterHcimode(); }
inline Bts2Ipc_SetAdapterHcimode* ptrNew_Bts2Ipc_SetAdapterHcimode(void) { return new Bts2Ipc_SetAdapterHcimode(); }
inline Bts2Ipc_GetAdapterVersion* ptrNew_Bts2Ipc_GetAdapterVersion(void) { return new Bts2Ipc_GetAdapterVersion(); }
inline Bts2Ipc_GetAdapterTraceLevel* ptrNew_Bts2Ipc_GetAdapterTraceLevel(void) { return new Bts2Ipc_GetAdapterTraceLevel(); }
inline Bts2Ipc_SetAdapterTraceLevel* ptrNew_Bts2Ipc_SetAdapterTraceLevel(void) { return new Bts2Ipc_SetAdapterTraceLevel(); }
inline Bts2Ipc_GetAdapterTraceCategory* ptrNew_Bts2Ipc_GetAdapterTraceCategory(void) { return new Bts2Ipc_GetAdapterTraceCategory(); }
inline Bts2Ipc_SetAdapterTraceCategory* ptrNew_Bts2Ipc_SetAdapterTraceCategory(void) { return new Bts2Ipc_SetAdapterTraceCategory(); }
inline Bts2Ipc_GetAdapterAvailableSppServers* ptrNew_Bts2Ipc_GetAdapterAvailableSppServers(void) { return new Bts2Ipc_GetAdapterAvailableSppServers(); }
inline Bts2Ipc_SetAdapterAvailableSppServers* ptrNew_Bts2Ipc_SetAdapterAvailableSppServers(void) { return new Bts2Ipc_SetAdapterAvailableSppServers(); }
inline Bts2Ipc_RegisterAgent* ptrNew_Bts2Ipc_RegisterAgent(void) { return new Bts2Ipc_RegisterAgent(); }
inline Bts2Ipc_UnregisterAgent* ptrNew_Bts2Ipc_UnregisterAgent(void) { return new Bts2Ipc_UnregisterAgent(); }
inline Bts2Ipc_RequestDefaultAgent* ptrNew_Bts2Ipc_RequestDefaultAgent(void) { return new Bts2Ipc_RequestDefaultAgent(); }
inline Bts2Ipc_DeviceConnect* ptrNew_Bts2Ipc_DeviceConnect(void) { return new Bts2Ipc_DeviceConnect(); }
inline Bts2Ipc_DeviceDisconnect* ptrNew_Bts2Ipc_DeviceDisconnect(void) { return new Bts2Ipc_DeviceDisconnect(); }
inline Bts2Ipc_Pair* ptrNew_Bts2Ipc_Pair(void) { return new Bts2Ipc_Pair(); }
inline Bts2Ipc_CancelPairing* ptrNew_Bts2Ipc_CancelPairing(void) { return new Bts2Ipc_CancelPairing(); }
inline Bts2Ipc_DiscoverServices* ptrNew_Bts2Ipc_DiscoverServices(void) { return new Bts2Ipc_DiscoverServices(); }
inline Bts2Ipc_CancelDiscovery* ptrNew_Bts2Ipc_CancelDiscovery(void) { return new Bts2Ipc_CancelDiscovery(); }
inline Bts2Ipc_GetDeviceAddress* ptrNew_Bts2Ipc_GetDeviceAddress(void) { return new Bts2Ipc_GetDeviceAddress(); }
inline Bts2Ipc_GetDeviceClass* ptrNew_Bts2Ipc_GetDeviceClass(void) { return new Bts2Ipc_GetDeviceClass(); }
inline Bts2Ipc_GetDeviceIcon* ptrNew_Bts2Ipc_GetDeviceIcon(void) { return new Bts2Ipc_GetDeviceIcon(); }
inline Bts2Ipc_GetDeviceUuids* ptrNew_Bts2Ipc_GetDeviceUuids(void) { return new Bts2Ipc_GetDeviceUuids(); }
inline Bts2Ipc_GetDevicePaired* ptrNew_Bts2Ipc_GetDevicePaired(void) { return new Bts2Ipc_GetDevicePaired(); }
inline Bts2Ipc_GetDeviceConnected* ptrNew_Bts2Ipc_GetDeviceConnected(void) { return new Bts2Ipc_GetDeviceConnected(); }
inline Bts2Ipc_GetDeviceTrusted* ptrNew_Bts2Ipc_GetDeviceTrusted(void) { return new Bts2Ipc_GetDeviceTrusted(); }
inline Bts2Ipc_SetDeviceTrusted* ptrNew_Bts2Ipc_SetDeviceTrusted(void) { return new Bts2Ipc_SetDeviceTrusted(); }
inline Bts2Ipc_GetDeviceBlocked* ptrNew_Bts2Ipc_GetDeviceBlocked(void) { return new Bts2Ipc_GetDeviceBlocked(); }
inline Bts2Ipc_SetDeviceBlocked* ptrNew_Bts2Ipc_SetDeviceBlocked(void) { return new Bts2Ipc_SetDeviceBlocked(); }
inline Bts2Ipc_GetDeviceAlias* ptrNew_Bts2Ipc_GetDeviceAlias(void) { return new Bts2Ipc_GetDeviceAlias(); }
inline Bts2Ipc_SetDeviceAlias* ptrNew_Bts2Ipc_SetDeviceAlias(void) { return new Bts2Ipc_SetDeviceAlias(); }
inline Bts2Ipc_GetDeviceAdapter* ptrNew_Bts2Ipc_GetDeviceAdapter(void) { return new Bts2Ipc_GetDeviceAdapter(); }
inline Bts2Ipc_GetDeviceModalias* ptrNew_Bts2Ipc_GetDeviceModalias(void) { return new Bts2Ipc_GetDeviceModalias(); }
inline Bts2Ipc_GetDeviceRssi* ptrNew_Bts2Ipc_GetDeviceRssi(void) { return new Bts2Ipc_GetDeviceRssi(); }
inline Bts2Ipc_GetDeviceVendorId* ptrNew_Bts2Ipc_GetDeviceVendorId(void) { return new Bts2Ipc_GetDeviceVendorId(); }
inline Bts2Ipc_GetDeviceVendorIdSource* ptrNew_Bts2Ipc_GetDeviceVendorIdSource(void) { return new Bts2Ipc_GetDeviceVendorIdSource(); }
inline Bts2Ipc_GetDeviceProductId* ptrNew_Bts2Ipc_GetDeviceProductId(void) { return new Bts2Ipc_GetDeviceProductId(); }
inline Bts2Ipc_GetDeviceMapInfo* ptrNew_Bts2Ipc_GetDeviceMapInfo(void) { return new Bts2Ipc_GetDeviceMapInfo(); }
inline Bts2Ipc_GetDeviceConnectedService* ptrNew_Bts2Ipc_GetDeviceConnectedService(void) { return new Bts2Ipc_GetDeviceConnectedService(); }
inline Bts2Ipc_GetDeviceVersion* ptrNew_Bts2Ipc_GetDeviceVersion(void) { return new Bts2Ipc_GetDeviceVersion(); }
inline Bts2Ipc_GetDevicePbapInfo* ptrNew_Bts2Ipc_GetDevicePbapInfo(void) { return new Bts2Ipc_GetDevicePbapInfo(); }
inline Bts2Ipc_GetDeviceMode* ptrNew_Bts2Ipc_GetDeviceMode(void) { return new Bts2Ipc_GetDeviceMode(); }
inline Bts2Ipc_GetDeviceRole* ptrNew_Bts2Ipc_GetDeviceRole(void) { return new Bts2Ipc_GetDeviceRole(); }
inline Bts2Ipc_GetDeviceEnableAvpPause* ptrNew_Bts2Ipc_GetDeviceEnableAvpPause(void) { return new Bts2Ipc_GetDeviceEnableAvpPause(); }
inline Bts2Ipc_SetDeviceEnableAvpPause* ptrNew_Bts2Ipc_SetDeviceEnableAvpPause(void) { return new Bts2Ipc_SetDeviceEnableAvpPause(); }
inline Bts2Ipc_BtApplDeviceConnectReq* ptrNew_Bts2Ipc_BtApplDeviceConnectReq(void) { return new Bts2Ipc_BtApplDeviceConnectReq(); }
inline Bts2Ipc_BtApplDeviceDisconnectReq* ptrNew_Bts2Ipc_BtApplDeviceDisconnectReq(void) { return new Bts2Ipc_BtApplDeviceDisconnectReq(); }
inline Bts2Ipc_BtApplCancelConnectReq* ptrNew_Bts2Ipc_BtApplCancelConnectReq(void) { return new Bts2Ipc_BtApplCancelConnectReq(); }
inline Bts2Ipc_BtApplGetHwVersionReq* ptrNew_Bts2Ipc_BtApplGetHwVersionReq(void) { return new Bts2Ipc_BtApplGetHwVersionReq(); }
inline Bts2Ipc_BtApplSetConfigurationReq* ptrNew_Bts2Ipc_BtApplSetConfigurationReq(void) { return new Bts2Ipc_BtApplSetConfigurationReq(); }
inline Bts2Ipc_BtApplReadConfigurationReq* ptrNew_Bts2Ipc_BtApplReadConfigurationReq(void) { return new Bts2Ipc_BtApplReadConfigurationReq(); }
inline Bts2Ipc_BtApplTestModeReq* ptrNew_Bts2Ipc_BtApplTestModeReq(void) { return new Bts2Ipc_BtApplTestModeReq(); }
inline Bts2Ipc_BtApplTestModeLinkQualityReq* ptrNew_Bts2Ipc_BtApplTestModeLinkQualityReq(void) { return new Bts2Ipc_BtApplTestModeLinkQualityReq(); }
inline Bts2Ipc_Connect* ptrNew_Bts2Ipc_Connect(void) { return new Bts2Ipc_Connect(); }
inline Bts2Ipc_Disconnect* ptrNew_Bts2Ipc_Disconnect(void) { return new Bts2Ipc_Disconnect(); }
inline Bts2Ipc_GetServiceRemoteUuid* ptrNew_Bts2Ipc_GetServiceRemoteUuid(void) { return new Bts2Ipc_GetServiceRemoteUuid(); }
inline Bts2Ipc_GetServiceState* ptrNew_Bts2Ipc_GetServiceState(void) { return new Bts2Ipc_GetServiceState(); }
inline Bts2Ipc_GetServiceDevice* ptrNew_Bts2Ipc_GetServiceDevice(void) { return new Bts2Ipc_GetServiceDevice(); }
inline Bts2Ipc_GetServiceVersion* ptrNew_Bts2Ipc_GetServiceVersion(void) { return new Bts2Ipc_GetServiceVersion(); }
inline Bts2Ipc_DebugTraceConfig* ptrNew_Bts2Ipc_DebugTraceConfig(void) { return new Bts2Ipc_DebugTraceConfig(); }
inline Bts2Ipc_ProtocolTraceConfig* ptrNew_Bts2Ipc_ProtocolTraceConfig(void) { return new Bts2Ipc_ProtocolTraceConfig(); }
inline Bts2Ipc_BtApplDidSetReq* ptrNew_Bts2Ipc_BtApplDidSetReq(void) { return new Bts2Ipc_BtApplDidSetReq(); }
inline Bts2Ipc_GetDunDeviceFilePath* ptrNew_Bts2Ipc_GetDunDeviceFilePath(void) { return new Bts2Ipc_GetDunDeviceFilePath(); }
inline Bts2Ipc_BtApplSppSetUuidReq* ptrNew_Bts2Ipc_BtApplSppSetUuidReq(void) { return new Bts2Ipc_BtApplSppSetUuidReq(); }
inline Bts2Ipc_CreateSession* ptrNew_Bts2Ipc_CreateSession(void) { return new Bts2Ipc_CreateSession(); }
inline Bts2Ipc_RemoveSession* ptrNew_Bts2Ipc_RemoveSession(void) { return new Bts2Ipc_RemoveSession(); }
inline Bts2Ipc_CancelSession* ptrNew_Bts2Ipc_CancelSession(void) { return new Bts2Ipc_CancelSession(); }
inline Bts2Ipc_GetConnManManagerProperties* ptrNew_Bts2Ipc_GetConnManManagerProperties(void) { return new Bts2Ipc_GetConnManManagerProperties(); }
inline Bts2Ipc_GetConnManTechnologies* ptrNew_Bts2Ipc_GetConnManTechnologies(void) { return new Bts2Ipc_GetConnManTechnologies(); }
inline Bts2Ipc_GetConnManServices* ptrNew_Bts2Ipc_GetConnManServices(void) { return new Bts2Ipc_GetConnManServices(); }
inline Bts2Ipc_GetConnManServiceProperties* ptrNew_Bts2Ipc_GetConnManServiceProperties(void) { return new Bts2Ipc_GetConnManServiceProperties(); }
inline Bts2Ipc_ConnManServiceConnect* ptrNew_Bts2Ipc_ConnManServiceConnect(void) { return new Bts2Ipc_ConnManServiceConnect(); }
inline Bts2Ipc_ConnManServiceDisconnect* ptrNew_Bts2Ipc_ConnManServiceDisconnect(void) { return new Bts2Ipc_ConnManServiceDisconnect(); }
inline Bts2Ipc_CreateLeDevice* ptrNew_Bts2Ipc_CreateLeDevice(void) { return new Bts2Ipc_CreateLeDevice(); }
inline Bts2Ipc_RemoveLeDevice* ptrNew_Bts2Ipc_RemoveLeDevice(void) { return new Bts2Ipc_RemoveLeDevice(); }
inline Bts2Ipc_GetLeAdapterAddressType* ptrNew_Bts2Ipc_GetLeAdapterAddressType(void) { return new Bts2Ipc_GetLeAdapterAddressType(); }
inline Bts2Ipc_GetLeAdapterAddress* ptrNew_Bts2Ipc_GetLeAdapterAddress(void) { return new Bts2Ipc_GetLeAdapterAddress(); }
inline Bts2Ipc_GetLeAdapterAlias* ptrNew_Bts2Ipc_GetLeAdapterAlias(void) { return new Bts2Ipc_GetLeAdapterAlias(); }
inline Bts2Ipc_SetLeAdapterAlias* ptrNew_Bts2Ipc_SetLeAdapterAlias(void) { return new Bts2Ipc_SetLeAdapterAlias(); }
inline Bts2Ipc_GetLeAdapterAdvertisingTimeout* ptrNew_Bts2Ipc_GetLeAdapterAdvertisingTimeout(void) { return new Bts2Ipc_GetLeAdapterAdvertisingTimeout(); }
inline Bts2Ipc_SetLeAdapterAdvertisingTimeout* ptrNew_Bts2Ipc_SetLeAdapterAdvertisingTimeout(void) { return new Bts2Ipc_SetLeAdapterAdvertisingTimeout(); }
inline Bts2Ipc_GetLeAdapterDiscoverableMode* ptrNew_Bts2Ipc_GetLeAdapterDiscoverableMode(void) { return new Bts2Ipc_GetLeAdapterDiscoverableMode(); }
inline Bts2Ipc_SetLeAdapterDiscoverableMode* ptrNew_Bts2Ipc_SetLeAdapterDiscoverableMode(void) { return new Bts2Ipc_SetLeAdapterDiscoverableMode(); }
inline Bts2Ipc_GetLeAdapterAdvertisingData* ptrNew_Bts2Ipc_GetLeAdapterAdvertisingData(void) { return new Bts2Ipc_GetLeAdapterAdvertisingData(); }
inline Bts2Ipc_SetLeAdapterAdvertisingData* ptrNew_Bts2Ipc_SetLeAdapterAdvertisingData(void) { return new Bts2Ipc_SetLeAdapterAdvertisingData(); }
inline Bts2Ipc_GetLeAdapterAdvertiseEnable* ptrNew_Bts2Ipc_GetLeAdapterAdvertiseEnable(void) { return new Bts2Ipc_GetLeAdapterAdvertiseEnable(); }
inline Bts2Ipc_SetLeAdapterAdvertiseEnable* ptrNew_Bts2Ipc_SetLeAdapterAdvertiseEnable(void) { return new Bts2Ipc_SetLeAdapterAdvertiseEnable(); }
inline Bts2Ipc_LeDeviceDisconnect* ptrNew_Bts2Ipc_LeDeviceDisconnect(void) { return new Bts2Ipc_LeDeviceDisconnect(); }
inline Bts2Ipc_GetLeDeviceAddressType* ptrNew_Bts2Ipc_GetLeDeviceAddressType(void) { return new Bts2Ipc_GetLeDeviceAddressType(); }
inline Bts2Ipc_GetLeDeviceAddress* ptrNew_Bts2Ipc_GetLeDeviceAddress(void) { return new Bts2Ipc_GetLeDeviceAddress(); }
inline Bts2Ipc_GetLeDeviceConnected* ptrNew_Bts2Ipc_GetLeDeviceConnected(void) { return new Bts2Ipc_GetLeDeviceConnected(); }
inline Bts2Ipc_SendSeamlessPairingErrorCode* ptrNew_Bts2Ipc_SendSeamlessPairingErrorCode(void) { return new Bts2Ipc_SendSeamlessPairingErrorCode(); }
inline Bts2Ipc_SeamlessPairingAllowAccess* ptrNew_Bts2Ipc_SeamlessPairingAllowAccess(void) { return new Bts2Ipc_SeamlessPairingAllowAccess(); }
inline Bts2Ipc_GetSeamlessPairingPairingData* ptrNew_Bts2Ipc_GetSeamlessPairingPairingData(void) { return new Bts2Ipc_GetSeamlessPairingPairingData(); }
inline Bts2Ipc_SetSeamlessPairingPairingData* ptrNew_Bts2Ipc_SetSeamlessPairingPairingData(void) { return new Bts2Ipc_SetSeamlessPairingPairingData(); }
inline Bts2Ipc_GetManagedObjectsTelephony* ptrNew_Bts2Ipc_GetManagedObjectsTelephony(void) { return new Bts2Ipc_GetManagedObjectsTelephony(); }
inline Bts2Ipc_GetAllPropertiesTelephony* ptrNew_Bts2Ipc_GetAllPropertiesTelephony(void) { return new Bts2Ipc_GetAllPropertiesTelephony(); }
inline Bts2Ipc_GetIntrospectionTelephony* ptrNew_Bts2Ipc_GetIntrospectionTelephony(void) { return new Bts2Ipc_GetIntrospectionTelephony(); }
inline Bts2Ipc_GetHandsfreeProperties* ptrNew_Bts2Ipc_GetHandsfreeProperties(void) { return new Bts2Ipc_GetHandsfreeProperties(); }
inline Bts2Ipc_GetModems* ptrNew_Bts2Ipc_GetModems(void) { return new Bts2Ipc_GetModems(); }
inline Bts2Ipc_GetModemProperties* ptrNew_Bts2Ipc_GetModemProperties(void) { return new Bts2Ipc_GetModemProperties(); }
inline Bts2Ipc_GetManagedObjectsPhonebook* ptrNew_Bts2Ipc_GetManagedObjectsPhonebook(void) { return new Bts2Ipc_GetManagedObjectsPhonebook(); }
inline Bts2Ipc_GetAllPropertiesPhonebook* ptrNew_Bts2Ipc_GetAllPropertiesPhonebook(void) { return new Bts2Ipc_GetAllPropertiesPhonebook(); }
inline Bts2Ipc_GetIntrospectionPhonebook* ptrNew_Bts2Ipc_GetIntrospectionPhonebook(void) { return new Bts2Ipc_GetIntrospectionPhonebook(); }
inline Bts2Ipc_GetPimSessionSource* ptrNew_Bts2Ipc_GetPimSessionSource(void) { return new Bts2Ipc_GetPimSessionSource(); }
inline Bts2Ipc_GetPimSessionDestination* ptrNew_Bts2Ipc_GetPimSessionDestination(void) { return new Bts2Ipc_GetPimSessionDestination(); }
inline Bts2Ipc_GetPimSessionChannel* ptrNew_Bts2Ipc_GetPimSessionChannel(void) { return new Bts2Ipc_GetPimSessionChannel(); }
inline Bts2Ipc_GetPimSessionTarget* ptrNew_Bts2Ipc_GetPimSessionTarget(void) { return new Bts2Ipc_GetPimSessionTarget(); }
inline Bts2Ipc_PimTransferCancel* ptrNew_Bts2Ipc_PimTransferCancel(void) { return new Bts2Ipc_PimTransferCancel(); }
inline Bts2Ipc_GetPimTransferStatus* ptrNew_Bts2Ipc_GetPimTransferStatus(void) { return new Bts2Ipc_GetPimTransferStatus(); }
inline Bts2Ipc_GetPimTransferSession* ptrNew_Bts2Ipc_GetPimTransferSession(void) { return new Bts2Ipc_GetPimTransferSession(); }
inline Bts2Ipc_GetPimTransferName* ptrNew_Bts2Ipc_GetPimTransferName(void) { return new Bts2Ipc_GetPimTransferName(); }
inline Bts2Ipc_GetPimTransferType* ptrNew_Bts2Ipc_GetPimTransferType(void) { return new Bts2Ipc_GetPimTransferType(); }
inline Bts2Ipc_GetPimTransferTime* ptrNew_Bts2Ipc_GetPimTransferTime(void) { return new Bts2Ipc_GetPimTransferTime(); }
inline Bts2Ipc_GetPimTransferSize* ptrNew_Bts2Ipc_GetPimTransferSize(void) { return new Bts2Ipc_GetPimTransferSize(); }
inline Bts2Ipc_GetPimTransferTransferred* ptrNew_Bts2Ipc_GetPimTransferTransferred(void) { return new Bts2Ipc_GetPimTransferTransferred(); }
inline Bts2Ipc_GetPimTransferFilename* ptrNew_Bts2Ipc_GetPimTransferFilename(void) { return new Bts2Ipc_GetPimTransferFilename(); }
inline Bts2Ipc_GetManagedObjectsMessaging* ptrNew_Bts2Ipc_GetManagedObjectsMessaging(void) { return new Bts2Ipc_GetManagedObjectsMessaging(); }
inline Bts2Ipc_GetAllPropertiesMessaging* ptrNew_Bts2Ipc_GetAllPropertiesMessaging(void) { return new Bts2Ipc_GetAllPropertiesMessaging(); }
inline Bts2Ipc_GetIntrospectionMessaging* ptrNew_Bts2Ipc_GetIntrospectionMessaging(void) { return new Bts2Ipc_GetIntrospectionMessaging(); }
inline Bts2Ipc_GetMsgSessionSource* ptrNew_Bts2Ipc_GetMsgSessionSource(void) { return new Bts2Ipc_GetMsgSessionSource(); }
inline Bts2Ipc_GetMsgSessionDestination* ptrNew_Bts2Ipc_GetMsgSessionDestination(void) { return new Bts2Ipc_GetMsgSessionDestination(); }
inline Bts2Ipc_GetMsgSessionChannel* ptrNew_Bts2Ipc_GetMsgSessionChannel(void) { return new Bts2Ipc_GetMsgSessionChannel(); }
inline Bts2Ipc_GetMsgSessionTarget* ptrNew_Bts2Ipc_GetMsgSessionTarget(void) { return new Bts2Ipc_GetMsgSessionTarget(); }
inline Bts2Ipc_MsgTransferCancel* ptrNew_Bts2Ipc_MsgTransferCancel(void) { return new Bts2Ipc_MsgTransferCancel(); }
inline Bts2Ipc_GetMsgTransferStatus* ptrNew_Bts2Ipc_GetMsgTransferStatus(void) { return new Bts2Ipc_GetMsgTransferStatus(); }
inline Bts2Ipc_GetMsgTransferSession* ptrNew_Bts2Ipc_GetMsgTransferSession(void) { return new Bts2Ipc_GetMsgTransferSession(); }
inline Bts2Ipc_GetMsgTransferName* ptrNew_Bts2Ipc_GetMsgTransferName(void) { return new Bts2Ipc_GetMsgTransferName(); }
inline Bts2Ipc_GetMsgTransferType* ptrNew_Bts2Ipc_GetMsgTransferType(void) { return new Bts2Ipc_GetMsgTransferType(); }
inline Bts2Ipc_GetMsgTransferTime* ptrNew_Bts2Ipc_GetMsgTransferTime(void) { return new Bts2Ipc_GetMsgTransferTime(); }
inline Bts2Ipc_GetMsgTransferSize* ptrNew_Bts2Ipc_GetMsgTransferSize(void) { return new Bts2Ipc_GetMsgTransferSize(); }
inline Bts2Ipc_GetMsgTransferTransferred* ptrNew_Bts2Ipc_GetMsgTransferTransferred(void) { return new Bts2Ipc_GetMsgTransferTransferred(); }
inline Bts2Ipc_GetMsgTransferFilename* ptrNew_Bts2Ipc_GetMsgTransferFilename(void) { return new Bts2Ipc_GetMsgTransferFilename(); }
inline Bts2Ipc_GetManagedObjectsMediaPlayer* ptrNew_Bts2Ipc_GetManagedObjectsMediaPlayer(void) { return new Bts2Ipc_GetManagedObjectsMediaPlayer(); }
inline Bts2Ipc_GetAllPropertiesMediaPlayer* ptrNew_Bts2Ipc_GetAllPropertiesMediaPlayer(void) { return new Bts2Ipc_GetAllPropertiesMediaPlayer(); }
inline Bts2Ipc_GetIntrospectionMediaPlayer* ptrNew_Bts2Ipc_GetIntrospectionMediaPlayer(void) { return new Bts2Ipc_GetIntrospectionMediaPlayer(); }

} //genivi
} //btstackif

#endif //_BTS_2_IPC_MESSAGE_WRAPPER_GENIVI_H_
