/**
 * @file Bts2Ipc_MediaPlayer_GEN.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to IPC messages for function block BTS_FB_MEDIAPLAYER.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_MEDIAPLAYER.
 */

#ifndef _BTS_2_IPC_MEDIAPLAYER_MSG_GENIVI_H_
#define _BTS_2_IPC_MEDIAPLAYER_MSG_GENIVI_H_

#include "EvolutionGeniviStackTypes.h"
#include "Bts2Ipc_BaseMessage.h"

namespace btstackif {
namespace genivi {

/**
 *
 */
class Bts2Ipc_GetManagedObjectsMediaPlayer : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetManagedObjectsMediaPlayer();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetManagedObjectsMediaPlayer(IN const Bts2Ipc_GetManagedObjectsMediaPlayer& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetManagedObjectsMediaPlayer& operator=(IN const Bts2Ipc_GetManagedObjectsMediaPlayer& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetManagedObjectsMediaPlayer();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

/**
 *
 */
class Bts2Ipc_GetAllPropertiesMediaPlayer : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetAllPropertiesMediaPlayer();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetAllPropertiesMediaPlayer(IN const Bts2Ipc_GetAllPropertiesMediaPlayer& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetAllPropertiesMediaPlayer& operator=(IN const Bts2Ipc_GetAllPropertiesMediaPlayer& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetAllPropertiesMediaPlayer();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }
   inline void setInterface(IN const BTSDbusInterface& interface) { _interface = interface; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }
   inline void getInterface(OUT BTSDbusInterface& interface) const { interface = _interface; }
   inline const BTSDbusInterface& getInterface(void) const { return _interface; }
   inline BTSDbusInterface& getInterfaceMutable(void) { return _interface; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
   BTSDbusInterface _interface; /**< parameter interface */
};

/**
 *
 */
class Bts2Ipc_GetIntrospectionMediaPlayer : public Bts2Ipc_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2Ipc_GetIntrospectionMediaPlayer();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2Ipc_GetIntrospectionMediaPlayer(IN const Bts2Ipc_GetIntrospectionMediaPlayer& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2Ipc_GetIntrospectionMediaPlayer& operator=(IN const Bts2Ipc_GetIntrospectionMediaPlayer& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2Ipc_GetIntrospectionMediaPlayer();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2Ipc_BaseMessage* clone(void) const;

   inline void setBusType(IN const BTSCommonEnumClass busType) { _busType = busType; }
   inline void setBusName(IN const BTSBusName& busName) { _busName = busName; }
   inline void setObjPath(IN const BTSObjectPath& objPath) { _objPath = objPath; }

   inline BTSCommonEnumClass getBusType(void) const { return _busType; }
   inline void getBusName(OUT BTSBusName& busName) const { busName = _busName; }
   inline const BTSBusName& getBusName(void) const { return _busName; }
   inline BTSBusName& getBusNameMutable(void) { return _busName; }
   inline void getObjPath(OUT BTSObjectPath& objPath) const { objPath = _objPath; }
   inline const BTSObjectPath& getObjPath(void) const { return _objPath; }
   inline BTSObjectPath& getObjPathMutable(void) { return _objPath; }

private:
   BTSCommonEnumClass _busType; /**< parameter bus type */
   BTSBusName _busName; /**< parameter bus name */
   BTSObjectPath _objPath; /**< parameter obj path */
};

} //genivi
} //btstackif

#endif //_BTS_2_IPC_MEDIAPLAYER_MSG_GENIVI_H_
