/**
 * @file DeviceIdServiceRecordAlpsEvolutionExt.cpp
 *
 * @par SW-Component
 * State machine for device id service record
 *
 * @brief Implementation of Alps Evolution Genivi device id service record state machine.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Source file for implementation of Alps Evolution Genivi device id service record state machine.
 */

#include "DeviceIdServiceRecordAlpsEvolutionExt.h"
#include "IDeviceIdServiceRecordCallback.h"
#include "FwErrmemPrint.h"
#include "Bts2Ipc_MessageWrapper_GEN.h"
#include "Ipc2Bts_MessageWrapper_GEN.h"

namespace btstackif {
namespace genivi {
namespace alpsevolutionext {

DeviceIdServiceRecordAlpsEvolutionExt::DeviceIdServiceRecordAlpsEvolutionExt() :
_callback(0)
{
}

DeviceIdServiceRecordAlpsEvolutionExt::~DeviceIdServiceRecordAlpsEvolutionExt()
{
   _callback = 0;
}

void DeviceIdServiceRecordAlpsEvolutionExt::reset(void)
{
}

void DeviceIdServiceRecordAlpsEvolutionExt::setCallback(IN IDeviceIdServiceRecordCallback* callback)
{
   _callback = callback;

   FW_ERRMEM_ASSERT(0 != _callback);
}

void DeviceIdServiceRecordAlpsEvolutionExt::setDeviceIdServiceRecord(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN const BTSDeviceIdServiceRecord& serviceRecord)
{
   (void)(bts2AppMsgList);

   Bts2Ipc_BtApplDidSetReq* msg = ptrNew_Bts2Ipc_BtApplDidSetReq();
   if(0 != msg)
   {
      msg->setServiceRecord(serviceRecord);
      msg->setResponseMessageFlag(true);
      bts2IpcMsgList.push_back(msg);
   }
}

IDeviceIdServiceRecordRequest* DeviceIdServiceRecordAlpsEvolutionExt::getRequestIf(void)
{
   return this;
}

void DeviceIdServiceRecordAlpsEvolutionExt::handleDidSetReqResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode errorCode)
{
   FW_ERRMEM_IF_NULL_PTR_RETURN(_callback);

   if(BTS_IPC_SUCCESS == errorCode)
   {
      // wait for signal ("confirmation")
   }
   else
   {
      // error happened => we assume that in this case no BtApplDidSetCfm signal will be received
      _callback->setDeviceIdServiceRecordResult(bts2IpcMsgList, bts2AppMsgList, messageItem, BTS_REQ_FAILED);
   }
}

void DeviceIdServiceRecordAlpsEvolutionExt::handleDidSetCfm(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSStatusCode status)
{
   FW_ERRMEM_IF_NULL_PTR_RETURN(_callback);

   _callback->setDeviceIdServiceRecordResult(bts2IpcMsgList, bts2AppMsgList, messageItem, ((BTS_STATUS_CODE_SUCCESS == status) ? BTS_REQ_SUCCESS : BTS_REQ_FAILED));
}

} //alpsevolutionext
} //genivi
} //btstackif
