/**
 * @file IBasicConfigurationAlpsEvolutionExt.h
 *
 * @par SW-Component
 * State machine for basic configuration
 *
 * @brief Interface definition for Alps Evolution Genivi basic configuration state machine.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the Alps Evolution Genivi basic configuration state machine.
 */

#ifndef _I_BASIC_CONFIGURATION_ALPS_EVOLUTION_EXT_H_
#define _I_BASIC_CONFIGURATION_ALPS_EVOLUTION_EXT_H_

#include "EvolutionGeniviStackTypes.h"

namespace btstackif {

// class forward declarations
class IBasicConfigurationRequest;
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;

namespace genivi {
namespace alpsevolutionext {

/**
 * Interface definition.
 */
class IBasicConfigurationAlpsEvolutionExt
{
public:
   /**
    * Destructor.
    */
   virtual ~IBasicConfigurationAlpsEvolutionExt() {}

   /**
    * Get request interface.
    *
    * @return = request interface
    */
   virtual IBasicConfigurationRequest* getRequestIf(void) = 0;

   /**
    * Handle result for setting configuration item (DBUS method return/error: request result).
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] errorCode: error result
    * @param[in] instance: instance
    * @param[in] configId: configuration id
    */
   virtual void handleSetConfigurationReqResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode errorCode, IN const BTSInstanceIndex instance, IN const BTSEvoConfigIdEnum configId) = 0;

   /**
    * Handle result for setting configuration item (DBUS signal: confirmation).
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] status: status code (result)
    * @param[in] instance: instance
    * @param[in] configId: configuration id
    */
   virtual void handleSetConfigurationCfm(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSStatusCode status, IN const BTSInstanceIndex instance, IN const BTSEvoConfigIdEnum configId) = 0;

   /**
    * Handle result for reading configuration item (DBUS method return/error: request result).
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] errorCode: error result
    * @param[in] instance: instance
    * @param[in] configId: configuration id
    */
   virtual void handleReadConfigurationReqResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSIpcCommonErrorCode errorCode, IN const BTSInstanceIndex instance, IN const BTSEvoConfigIdEnum configId) = 0;

   /**
    * Handle result for reading configuration item (DBUS signal: confirmation).
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] status: status code (result)
    * @param[in] instance: instance
    * @param[in] configId: configuration id
    * @param[in] data: data
    */
   virtual void handleReadConfigurationCfm(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSStatusCode status, IN const BTSInstanceIndex instance, IN const BTSEvoConfigIdEnum configId, IN const BTSEvoConfigDataStream& data) = 0;
};

} //alpsevolutionext
} //genivi
} //btstackif

#endif //_I_BASIC_CONFIGURATION_ALPS_EVOLUTION_EXT_H_
