/**
 * @file AlpsEvolutionOrgFreedesktopObjectManagerFactory.cpp
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief OrgFreedesktop instance factory for ObjectManager.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details OrgFreedesktop instance factory for ObjectManager.
 */

#include "AlpsEvolutionOrgFreedesktopObjectManagerFactory.h"
#include "AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf.h"

namespace btstackif {
namespace genivi {
namespace alpsevolutionext {

AlpsEvolutionOrgFreedesktopObjectManagerFactory::AlpsEvolutionOrgFreedesktopObjectManagerFactory() :
_createdLocally(true),
_cb(0)
{
}

AlpsEvolutionOrgFreedesktopObjectManagerFactory::~AlpsEvolutionOrgFreedesktopObjectManagerFactory()
{
   _cb = 0;
}

AlpsEvolutionOrgFreedesktopObjectManagerFactory& AlpsEvolutionOrgFreedesktopObjectManagerFactory::getInstance(void)
{
   static AlpsEvolutionOrgFreedesktopObjectManagerFactory factory;
   return factory;
}

IAlpsEvolutionOrgFreedesktopObjectManagerCallbackIf* AlpsEvolutionOrgFreedesktopObjectManagerFactory::getCb(IDbusRecHandler* handler)
{
   if(0 != _cb)
   {
      // already created; set receive handler
      _cb->setReceiveHandler(handler);
   }
   else
   {
      _cb = new AlpsEvolutionOrgFreedesktopObjectManagerCallbackIf(handler);
      _createdLocally = true;
   }

   return _cb;
}

void AlpsEvolutionOrgFreedesktopObjectManagerFactory::destroyCb(void)
{
   if((0 != _cb) && (true == _createdLocally))
   {
      delete _cb;
      _cb = 0;
   }
}

void AlpsEvolutionOrgFreedesktopObjectManagerFactory::setCbForTesting(IAlpsEvolutionOrgFreedesktopObjectManagerCallbackIf* testCallback)
{
   if(0 != _cb)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _cb = testCallback;
      _createdLocally = false;
   }
}

} //alpsevolutionext
} //genivi
} //btstackif
