/**
 * @file AlpsEvolutionOrgFreedesktopObjectManagerFactory.h
 *
 * @par SW-Component
 * BtStackIf
 *
 * @brief OrgFreedesktop instance factory for ObjectManager.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details OrgFreedesktop instance factory for ObjectManager.
 */

#ifndef _ALPSEVOLUTION_ORG_FREEDESKTOP_OBJECT_MANAGER_FACTORY_H_
#define _ALPSEVOLUTION_ORG_FREEDESKTOP_OBJECT_MANAGER_FACTORY_H_

namespace btstackif {

// class forward declarations
class IDbusRecHandler;

namespace genivi {
namespace alpsevolutionext {

// class forward declarations
class IAlpsEvolutionOrgFreedesktopObjectManagerCallbackIf;

/**
 * Factory class for AlpsEvolutionOrgFreedesktopObjectManager.
 */
class AlpsEvolutionOrgFreedesktopObjectManagerFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static AlpsEvolutionOrgFreedesktopObjectManagerFactory& getInstance(void);

   /**
    * Get callback instance (pointer).
    *
    * @param[in] handler: receive handler
    *
    * @return = pointer to callback instance
    */
   IAlpsEvolutionOrgFreedesktopObjectManagerCallbackIf* getCb(IDbusRecHandler* handler);

   /**
    * Destroy callback instance (pointer).
    */
   void destroyCb(void);

   /**
    * Set callback instance (pointer).
    * For testing purpose (unit test).
    * If callback instance is set by external user via this interface the caller is responsible to free the callback instance at the end of the test run.
    *
    * @param[in] testCallback: test version of callback instance (pointer)
    */
   void setCbForTesting(IAlpsEvolutionOrgFreedesktopObjectManagerCallbackIf* testCallback);

private:
   /**
    * Default constructor. Private!!!
    */
   AlpsEvolutionOrgFreedesktopObjectManagerFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~AlpsEvolutionOrgFreedesktopObjectManagerFactory();

   bool _createdLocally; /**< creator flag */
   IAlpsEvolutionOrgFreedesktopObjectManagerCallbackIf* _cb; /**< callback instance */
};

} //alpsevolutionext
} //genivi
} //btstackif

#endif //_ALPSEVOLUTION_ORG_FREEDESKTOP_OBJECT_MANAGER_FACTORY_H_
