/**
 * @file AlpsEvolutionConnectionControl.h
 *
 * @par SW-Component
 * Control Extension
 *
 * @brief Implementation of Alps Evolution Genivi connection control extension.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Header file for implementation of Alps Evolution Genivi connection control extension.
 */

#ifndef _ALPS_EVOLUTION_CONNECTION_CONTROL_H_
#define _ALPS_EVOLUTION_CONNECTION_CONTROL_H_

#include "IControlHandler.h"
#include "IConnectionSmExtension.h"
#include "EvolutionGeniviStackTypes.h"

namespace btstackif {
namespace genivi {

// class forward declarations
// Ipc2Bts messages TODO: to be shifted to alpsevolutionext
class Ipc2Bts_BtApplTestModeReqResult;
class Ipc2Bts_BtApplTestModeLinkQualityReqResult;
class Ipc2Bts_BtApplTestModeCfm;
class Ipc2Bts_BtApplTestModeCompInd;
class Ipc2Bts_BtApplTestModeLinkQualityCfm;
class Ipc2Bts_ServiceAvailabilityConnection;
class Ipc2Bts_GetAllPropertiesConnection;
class Ipc2Bts_CreateLeDeviceResult;
class Ipc2Bts_RemoveLeDeviceResult;
class Ipc2Bts_LeAdapterInitialization;
class Ipc2Bts_LeDeviceCreated;
class Ipc2Bts_LeDeviceRemoved;
class Ipc2Bts_LeAdapterAddressTypeUpdate;
class Ipc2Bts_LeAdapterAddressUpdate;
class Ipc2Bts_LeAdapterAliasUpdate;
class Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate;
class Ipc2Bts_LeAdapterDiscoverableModeUpdate;
class Ipc2Bts_LeAdapterAdvertisingDataUpdate;
class Ipc2Bts_LeAdapterAdvertiseEnableUpdate;
class Ipc2Bts_AddLeDeviceObjectPathMapping;
class Ipc2Bts_DelLeDeviceObjectPathMapping;
class Ipc2Bts_LeDeviceDisconnectResult;
class Ipc2Bts_LeDisconnectionComp;
class Ipc2Bts_LeDeviceAddressTypeUpdate;
class Ipc2Bts_LeDeviceAddressUpdate;
class Ipc2Bts_LeDeviceConnectedUpdate;
class Ipc2Bts_SendSeamlessPairingErrorCodeResult;
class Ipc2Bts_SeamlessPairingAllowAccessResult;
class Ipc2Bts_SeamlessPairingErrorCodeReceived;
class Ipc2Bts_SeamlessPairingAccessRequest;
class Ipc2Bts_SeamlessPairingPairingDataUpdate;

namespace alpsevolutionext {

// class forward declarations
class TestModeAlpsEvolutionExt;
class IBluetoothLowEnergyAlpsEvolutionExt;

/**
 * Alps Evolution Genivi connection control class.
 */
class AlpsEvolutionConnectionControl : public IControlHandler, public IConnectionSmExtension
{
public:
   /**
    * Default constructor.
    */
   AlpsEvolutionConnectionControl();

   /**
    * Destructor.
    */
   virtual ~AlpsEvolutionConnectionControl();

   virtual void setControlIf(IN IBasicControl* control);

   virtual void setTimerPoolIf(IN ITimerPool* timerPool);

   virtual void enable(IN const bool enable);

   virtual void initialize(void);

   virtual void destroy(void);

   virtual void setStackConfiguration(IN const BTSFunctionBlock component, IN const BTSInterfaceType stackInterface, IN const BTSFunctionBlock subComponent, IN const BTSUserMode userMode,
            OUT ::std::vector<BTSDbusInterfaceItem>& dbusInterfaces, IN const BTSLocalConfigurationContainer& configuration);

   virtual bool doApp2BtsMsgPrecheck(OUT bool& continueProcessing, OUT bool& rejectRequest, OUT BTSCommonEnumClass& resultCode, OUT BTSCommonEnumClass& statusCode, OUT bool& skipOpCodeCheck, IN App2Bts_BaseMessage* message);

   virtual bool getSimilarOpCodes(OUT ::std::vector< BTSApp2BtsMessageMasterCompareItem >& itemList, IN const App2Bts_BaseMessage* message) const;

   virtual bool getMatchingOpCodes(OUT ::std::vector< BTSApp2BtsMessageMasterCompareItem >& itemList, OUT ::std::vector< BTSApp2BtsMessageMasterCompareItem >& highPrioItemList, IN const App2Bts_BaseMessage* message) const;

   virtual bool triggerInitializedCallback(void);

   virtual bool handleDoubledApp2BtsMessages(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, IN App2Bts_BaseMessage* message, IN const BTSCommonEnumClass resultCode, IN const BTSCommonEnumClass statusCode);

   virtual bool handleApp2BtsMessage(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT bool& deleteApp2BtsMessage, IN App2Bts_BaseMessage* message);

   virtual bool handleIpc2BtsMessage(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_BaseMessage* message);

   virtual bool setSubControlTestCommand(IN const char* testCommand, IN const unsigned int testData);

   virtual bool setSubControlTestCommand(IN const char* testCommand, IN const unsigned char* testData);

   virtual bool handleTTFisCommand(IN const unsigned char* testData);

   virtual bool handleApp2BtsTestCommand(IN const unsigned char* testData);

   virtual ITestModeRequest* getTestMode(void);

private:
   IBasicControl* _controlIf; /**< basic control interface */
   ITimerPool* _timerPoolIf; /**< timer pool interface */
   bool _enabled; /**< enabled flag */
   bool _initialized; /**< initialized flag */

   TestModeAlpsEvolutionExt* _testMode; /**< specific SM for test mode */
   IBluetoothLowEnergyAlpsEvolutionExt* _ble; /**< specific SM for BLE */

   /**
    * Handle received Ipc2Bts message.
    * Handle any error within this function.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] message: received Ipc2Bts message
    *
    * @return = true: given message was handled ("extension is responsible for this message request"),
    * @return = false: given message was not handled ("extension is not responsible for this message request")
    */
   bool handleIpc2BtsBtApplTestModeReqResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_BtApplTestModeReqResult* message);
   bool handleIpc2BtsBtApplTestModeLinkQualityReqResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_BtApplTestModeLinkQualityReqResult* message);
   bool handleIpc2BtsBtApplTestModeCfm(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_BtApplTestModeCfm* message);
   bool handleIpc2BtsBtApplTestModeCompInd(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_BtApplTestModeCompInd* message);
   bool handleIpc2BtsBtApplTestModeLinkQualityCfm(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_BtApplTestModeLinkQualityCfm* message);
   bool handleIpc2BtsServiceAvailabilityConnection(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_ServiceAvailabilityConnection* message);
   bool handleIpc2BtsGetAllPropertiesConnection(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_GetAllPropertiesConnection* message);
   bool handleIpc2BtsCreateLeDeviceResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_CreateLeDeviceResult* message);
   bool handleIpc2BtsRemoveLeDeviceResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_RemoveLeDeviceResult* message);
   bool handleIpc2BtsLeAdapterInitialization(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterInitialization* message);
   bool handleIpc2BtsLeDeviceCreated(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeDeviceCreated* message);
   bool handleIpc2BtsLeDeviceRemoved(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeDeviceRemoved* message);
   bool handleIpc2BtsLeAdapterAddressTypeUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterAddressTypeUpdate* message);
   bool handleIpc2BtsLeAdapterAddressUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterAddressUpdate* message);
   bool handleIpc2BtsLeAdapterAliasUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterAliasUpdate* message);
   bool handleIpc2BtsLeAdapterAdvertisingTimeoutUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterAdvertisingTimeoutUpdate* message);
   bool handleIpc2BtsLeAdapterDiscoverableModeUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterDiscoverableModeUpdate* message);
   bool handleIpc2BtsLeAdapterAdvertisingDataUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterAdvertisingDataUpdate* message);
   bool handleIpc2BtsLeAdapterAdvertiseEnableUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeAdapterAdvertiseEnableUpdate* message);
   bool handleIpc2BtsAddLeDeviceObjectPathMapping(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_AddLeDeviceObjectPathMapping* message);
   bool handleIpc2BtsDelLeDeviceObjectPathMapping(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_DelLeDeviceObjectPathMapping* message);
   bool handleIpc2BtsLeDeviceDisconnectResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeDeviceDisconnectResult* message);
   bool handleIpc2BtsLeDisconnectionComp(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeDisconnectionComp* message);
   bool handleIpc2BtsLeDeviceAddressTypeUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeDeviceAddressTypeUpdate* message);
   bool handleIpc2BtsLeDeviceAddressUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeDeviceAddressUpdate* message);
   bool handleIpc2BtsLeDeviceConnectedUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_LeDeviceConnectedUpdate* message);
   bool handleIpc2BtsSendSeamlessPairingErrorCodeResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_SendSeamlessPairingErrorCodeResult* message);
   bool handleIpc2BtsSeamlessPairingAllowAccessResult(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_SeamlessPairingAllowAccessResult* message);
   bool handleIpc2BtsSeamlessPairingErrorCodeReceived(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_SeamlessPairingErrorCodeReceived* message);
   bool handleIpc2BtsSeamlessPairingAccessRequest(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_SeamlessPairingAccessRequest* message);
   bool handleIpc2BtsSeamlessPairingPairingDataUpdate(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN Ipc2Bts_SeamlessPairingPairingDataUpdate* message);
};

} //alpsevolutionext
} //genivi
} //btstackif

#endif //_ALPS_EVOLUTION_CONNECTION_CONTROL_H_
