/**
 * @file StateMachine.cpp
 *
 * @par SW-Component
 * State machine
 *
 * @brief Base class definition for state machines.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the base class for state machines.
 */

#include "StateMachine.h"

namespace btstackif {

StateMachine::StateMachine() :
_blockingIpc(false),
_blockingApp(false)
{
}

StateMachine::~StateMachine()
{
}

void StateMachine::reset(void)
{
   _blockingIpc = false;
   _blockingApp = false;
}

void StateMachine::forceInitialState(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList)
{
   (void)(bts2AppMsgList);
   StateMachine::reset();
}

void StateMachine::setBlockingIpc(IN const bool enable)
{
   _blockingIpc = enable;
}

void StateMachine::setBlockingApp(IN const bool enable)
{
   _blockingApp = enable;
}

} //btstackif
