/**
 * @file StateMachine.h
 *
 * @par SW-Component
 * State machine
 *
 * @brief Base class declaration for state machines.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file declares the base class for state machines.
 */

#ifndef _STATE_MACHINE_H_
#define _STATE_MACHINE_H_

#include "IStateMachine.h"

namespace btstackif {

/**
 * SM base class declaration.
 */
class StateMachine : public IStateMachine
{
public:
   /**
    * Default constructor.
    */
   StateMachine();

   /**
    * Destructor.
    */
   virtual ~StateMachine();

   virtual void reset(void);

   virtual void forceInitialState(OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList);

   virtual void setBlockingIpc(IN const bool enable);

   virtual void setBlockingApp(IN const bool enable);

protected:
   bool _blockingIpc; /**< blocking flag for IPC communication (BTS2IPC + IPC2BTS) */
   bool _blockingApp; /**< blocking flag for APP communication (BTS2APP + APP2BTS) */
};

} //btstackif

#endif //_STATE_MACHINE_H_
