/**
 * @file WblStartupData.cpp
 *
 * @par SW-Component
 * State machine for WBL startup
 *
 * @brief Implementation of WBL startup data.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Source file for implementation of WBL startup data.
 */

#include "WblStartupData.h"

namespace btstackif {

WblStartupData::WblStartupData() :
pending()
{
}

WblStartupData::~WblStartupData()
{
}

WblStartupData::WblStartupData(const WblStartupData& ref) :
pending(ref.pending)
{
}

WblStartupData& WblStartupData::operator=(const WblStartupData& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   pending = ref.pending;

   return *this;
}

bool WblStartupData::operator==(const WblStartupData& ref) const
{
   bool result = true;

   result = (true == result) && (pending == ref.pending);

   return result;
}

bool WblStartupData::operator!=(const WblStartupData& ref) const
{
   return !(operator==(ref));
}

void WblStartupData::reset(void)
{
   pending.setData(0);
}

} //btstackif
