/**
 * @file IWblStartupRequest.h
 *
 * @par SW-Component
 * State machine for WBL startup
 *
 * @brief Request interface definition for WBL startup state machine.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the request interface to be implemented by specific WBL startup state machine.
 */

#ifndef _I_WBL_STARTUP_REQUEST_H_
#define _I_WBL_STARTUP_REQUEST_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class IWblStartupCallback;
class IBasicControl;

/**
 * Interface definition.
 */
class IWblStartupRequest
{
public:
   /**
    * Destructor.
    */
   virtual ~IWblStartupRequest() {}

   /**
    * Set callback instance (implementation).
    *
    * @param[in] callback: callback instance (implementation)
    */
   virtual void setCallback(IN IWblStartupCallback* callback) = 0;

   /**
    * Set basic control interface.
    *
    * @param[in] control: basic control interface
    */
   virtual void setControlIf(IN IBasicControl* control) = 0;
};

} //btstackif

#endif //_I_WBL_STARTUP_REQUEST_H_
