/**
 * @file ISppPoolCallback.h
 *
 * @par SW-Component
 * State machine for SPP pool
 *
 * @brief Callback interface definition for SPP pool state machine.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details This file defines the callback interface to be used by specific SPP pool state machine.
 *          Callback interface must be provided by generic SPP pool state machine.
 */

#ifndef _I_SPP_POOL_CALLBACK_H_
#define _I_SPP_POOL_CALLBACK_H_

#include "BtStackInternalTypes.h"

namespace btstackif {

// class forward declarations
class Bts2Ipc_BaseMessage;
class Bts2App_BaseMessage;
class App2Bts_BaseMessage;

/**
 * Interface definition.
 */
class ISppPoolCallback
{
public:
   /**
    * Destructor.
    */
   virtual ~ISppPoolCallback() {}

   /**
    * Update local SPP UUIDs.
    *
    * @param[out] bts2IpcMsgList: list of Bts2Ipc messages to be sent
    * @param[out] bts2AppMsgList: list of Bts2App messages to be sent
    * @param[out] messageItem: message item
    * @param[in] uuidList: UUID list
    * @param[in] success: success/failed flag
    */
   virtual void updateLocalSppUuids(OUT ::std::vector< Bts2Ipc_BaseMessage* >& bts2IpcMsgList, OUT ::std::vector< Bts2App_BaseMessage* >& bts2AppMsgList, OUT BTSHandleIpc2BtsMessageItem& messageItem, IN const BTSUuidList& uuidList, IN const bool success) = 0;
};

} //btstackif

#endif //_I_SPP_POOL_CALLBACK_H_
