/**
 * @file ServiceSearchData.cpp
 *
 * @par SW-Component
 * State machine for service search
 *
 * @brief Implementation of service search data.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Source file for implementation of service search data.
 */

#include "ServiceSearchData.h"

namespace btstackif {

ServiceSearchData::ServiceSearchData() :
sdpRecordAvailable(),
pendingGetData(),
supportedServices(),
serviceInfoList(),
protocolVersionAvailable(),
serviceRecord(),
didDataAvailable(),
sspCapabilities(),
pbapRecord(),
mapRecords(),
stackSdpSearchActive(false),
automaticSdpSearch(false),
ongoing(false),
resultPending(false),
dataPending(false),
cancelRequested(false),
cancelPending(false),
createPending(false),
type(BTS_SEARCH_LAST),
internal(false),
retryNmb(0),
requestItem(),
retryTimer(),
pageTimeoutTimer(),
pageTimeoutHappened(false),
pageTimeout(0),
deviceConnected(false),
lastPairingSuccessful(false),
avrcpVersionRequested(false)
{
}

ServiceSearchData::~ServiceSearchData()
{
}

ServiceSearchData::ServiceSearchData(const ServiceSearchData& ref)
{
   sdpRecordAvailable = ref.sdpRecordAvailable;
   pendingGetData = ref.pendingGetData;
   supportedServices = ref.supportedServices;
   serviceInfoList = ref.serviceInfoList;
   protocolVersionAvailable = ref.protocolVersionAvailable;
   serviceRecord = ref.serviceRecord;
   didDataAvailable = ref.didDataAvailable;
   sspCapabilities = ref.sspCapabilities;
   pbapRecord = ref.pbapRecord;
   mapRecords = ref.mapRecords;
   stackSdpSearchActive = ref.stackSdpSearchActive;
   automaticSdpSearch = ref.automaticSdpSearch;
   ongoing = ref.ongoing;
   resultPending = ref.resultPending;
   dataPending = ref.dataPending;
   cancelRequested = ref.cancelRequested;
   cancelPending = ref.cancelPending;
   createPending = ref.createPending;
   type = ref.type;
   internal = ref.internal;
   retryNmb = ref.retryNmb;
   requestItem = ref.requestItem;
   retryTimer = ref.retryTimer;
   pageTimeoutTimer = ref.pageTimeoutTimer;
   pageTimeoutHappened = ref.pageTimeoutHappened;
   pageTimeout = ref.pageTimeout;
   deviceConnected = ref.deviceConnected;
   lastPairingSuccessful = ref.lastPairingSuccessful;
   avrcpVersionRequested = ref.avrcpVersionRequested;
}

ServiceSearchData& ServiceSearchData::operator=(const ServiceSearchData& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   sdpRecordAvailable = ref.sdpRecordAvailable;
   pendingGetData = ref.pendingGetData;
   supportedServices = ref.supportedServices;
   serviceInfoList = ref.serviceInfoList;
   protocolVersionAvailable = ref.protocolVersionAvailable;
   serviceRecord = ref.serviceRecord;
   didDataAvailable = ref.didDataAvailable;
   sspCapabilities = ref.sspCapabilities;
   pbapRecord = ref.pbapRecord;
   mapRecords = ref.mapRecords;
   stackSdpSearchActive = ref.stackSdpSearchActive;
   automaticSdpSearch = ref.automaticSdpSearch;
   ongoing = ref.ongoing;
   resultPending = ref.resultPending;
   dataPending = ref.dataPending;
   cancelRequested = ref.cancelRequested;
   cancelPending = ref.cancelPending;
   createPending = ref.createPending;
   type = ref.type;
   internal = ref.internal;
   retryNmb = ref.retryNmb;
   requestItem = ref.requestItem;
   retryTimer = ref.retryTimer;
   pageTimeoutTimer = ref.pageTimeoutTimer;
   pageTimeoutHappened = ref.pageTimeoutHappened;
   pageTimeout = ref.pageTimeout;
   deviceConnected = ref.deviceConnected;
   lastPairingSuccessful = ref.lastPairingSuccessful;
   avrcpVersionRequested = ref.avrcpVersionRequested;

   return *this;
}

bool ServiceSearchData::operator==(const ServiceSearchData& ref) const
{
   bool result = true;

   result = (true == result) && (sdpRecordAvailable == ref.sdpRecordAvailable);
   result = (true == result) && (pendingGetData == ref.pendingGetData);
   result = (true == result) && (supportedServices == ref.supportedServices);
   result = (true == result) && (serviceInfoList == ref.serviceInfoList);
   result = (true == result) && (protocolVersionAvailable == ref.protocolVersionAvailable);
   result = (true == result) && (serviceRecord == ref.serviceRecord);
   result = (true == result) && (didDataAvailable == ref.didDataAvailable);
   result = (true == result) && (sspCapabilities == ref.sspCapabilities);
   result = (true == result) && (pbapRecord == ref.pbapRecord);
   result = (true == result) && (mapRecords == ref.mapRecords);
   result = (true == result) && (stackSdpSearchActive == ref.stackSdpSearchActive);
   result = (true == result) && (automaticSdpSearch == ref.automaticSdpSearch);
   result = (true == result) && (ongoing == ref.ongoing);
   result = (true == result) && (resultPending == ref.resultPending);
   result = (true == result) && (dataPending == ref.dataPending);
   result = (true == result) && (cancelRequested == ref.cancelRequested);
   result = (true == result) && (cancelPending == ref.cancelPending);
   result = (true == result) && (createPending == ref.createPending);
   result = (true == result) && (type == ref.type);
   result = (true == result) && (internal == ref.internal);
   result = (true == result) && (retryNmb == ref.retryNmb);
   result = (true == result) && (requestItem == ref.requestItem);
   result = (true == result) && (retryTimer == ref.retryTimer);
   result = (true == result) && (pageTimeoutTimer == ref.pageTimeoutTimer);
   result = (true == result) && (pageTimeoutHappened == ref.pageTimeoutHappened);
   result = (true == result) && (pageTimeout == ref.pageTimeout);
   result = (true == result) && (deviceConnected == ref.deviceConnected);
   result = (true == result) && (lastPairingSuccessful == ref.lastPairingSuccessful);
   result = (true == result) && (avrcpVersionRequested == ref.avrcpVersionRequested);

   return result;
}

bool ServiceSearchData::operator!=(const ServiceSearchData& ref) const
{
   return !(operator==(ref));
}

} //btstackif
